/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class BelisLocationSearchStatement
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
MetaObjectNodeServerSearch {
    private static final transient Logger LOG = Logger.getLogger(BelisLocationSearchStatement.class);
    private final SearchInfo searchInfo = new SearchInfo();
    private String strassenschluessel;
    private Integer kennziffer;
    private Integer laufendeNummer;

    public BelisLocationSearchStatement() {
        this.searchInfo.setKey(((Object)((Object)this)).getClass().getName());
        this.searchInfo.setName(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setDescription("Search for Belis entites by location key");
        LinkedList<SearchParameterInfo> parameterDescription = new LinkedList<SearchParameterInfo>();
        SearchParameterInfo searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("strassenschluessel");
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("kennziffer");
        searchParameterInfo.setType(Type.INTEGER);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("laufendeNummer");
        searchParameterInfo.setType(Type.INTEGER);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo resultParameterInfo = new SearchParameterInfo();
        resultParameterInfo.setKey("return");
        resultParameterInfo.setArray(true);
        resultParameterInfo.setType(Type.UNDEFINED);
        this.searchInfo.setResultDescription(resultParameterInfo);
    }

    public BelisLocationSearchStatement(String strassenschluessel, Integer kennziffer, Integer laufendeNummer) {
        this();
        this.setStrassenschluessel(strassenschluessel);
        this.setKennziffer(kennziffer);
        this.setLaufendeNummer(laufendeNummer);
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            MetaService ms = (MetaService)this.getActiveLocalServers().get("BELIS2");
            if (this.strassenschluessel == null && this.kennziffer == null && this.laufendeNummer == null) {
                return new ArrayList<MetaObjectNode>();
            }
            HashSet<ArrayList> results = new HashSet<ArrayList>();
            results.addAll(this.retrieveStandort(ms, this.strassenschluessel, this.kennziffer, this.laufendeNummer));
            results.addAll(this.retrieveSchaltstelle(ms, this.strassenschluessel, this.laufendeNummer));
            results.addAll(this.retrieveMauerlasche(ms, this.strassenschluessel, this.laufendeNummer));
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            for (ArrayList al : results) {
                if (al == null) continue;
                int cid = (Integer)al.get(0);
                int oid = (Integer)al.get(1);
                MetaObjectNode mon = new MetaObjectNode("BELIS2", oid, cid, "", null, null);
                result.add(mon);
            }
            return result;
        }
        catch (Exception ex) {
            LOG.error((Object)"while executing location search", (Throwable)ex);
            return new ArrayList<MetaObjectNode>();
        }
    }

    private Collection<ArrayList> retrieveStandort(MetaService ms, String strassenschluessel, Integer kennziffer, Integer laufendeNummer) {
        try {
            if (strassenschluessel == null) {
                System.out.println("At least the strassenschluessel must be != null");
                return new ArrayList<ArrayList>();
            }
            MetaClass MC_STANDORT = ms.getClassByTableName(this.getUser(), "tdta_standort_mast");
            String query = kennziffer != null ? "SELECT " + MC_STANDORT.getId() + ", tdta_standort_mast.id FROM tdta_standort_mast, tkey_strassenschluessel, tkey_kennziffer WHERE tdta_standort_mast.fk_strassenschluessel = tkey_strassenschluessel.id AND tkey_strassenschluessel.pk like '" + strassenschluessel + "' AND tdta_standort_mast.fk_kennziffer = tkey_kennziffer.id AND tkey_kennziffer.kennziffer = " + kennziffer + " " : "SELECT " + MC_STANDORT.getId() + ", tdta_standort_mast.id FROM tdta_standort_mast, tkey_strassenschluessel WHERE tdta_standort_mast.fk_strassenschluessel = tkey_strassenschluessel.id AND tkey_strassenschluessel.pk like '" + strassenschluessel + "' ";
            if (laufendeNummer != null) {
                query = query + "AND tdta_standort_mast.lfd_nummer = " + laufendeNummer + " ";
            }
            query = query + "AND (tdta_standort_mast.is_deleted IS NULL or tdta_standort_mast.is_deleted IS FALSE) ";
            LOG.info((Object)query);
            return ms.performCustomSearch(query);
        }
        catch (Exception ex) {
            LOG.error((Object)"error in retrieveStandort", (Throwable)ex);
            return new ArrayList<ArrayList>();
        }
    }

    private Collection<ArrayList> retrieveSchaltstelle(MetaService ms, String strassenschluessel, Integer laufendeNummer) {
        try {
            if (strassenschluessel == null) {
                return new ArrayList<ArrayList>();
            }
            MetaClass MC_SCHALTSTELLE = ms.getClassByTableName(this.getUser(), "schaltstelle");
            String query = "SELECT " + MC_SCHALTSTELLE.getId() + ", schaltstelle.id FROM schaltstelle, tkey_strassenschluessel WHERE schaltstelle.fk_strassenschluessel = tkey_strassenschluessel.id AND tkey_strassenschluessel.pk like '" + strassenschluessel + "' ";
            if (laufendeNummer != null) {
                query = query + "AND schaltstelle.laufende_nummer = " + laufendeNummer + " ";
            }
            query = query + "AND (schaltstelle.is_deleted IS NULL or schaltstelle.is_deleted IS FALSE) ";
            LOG.info((Object)query);
            return ms.performCustomSearch(query);
        }
        catch (Exception ex) {
            LOG.error((Object)"error in retrieveSchaltstelle", (Throwable)ex);
            return new ArrayList<ArrayList>();
        }
    }

    private Collection<ArrayList> retrieveMauerlasche(MetaService ms, String strassenschluessel, Integer laufendeNummer) {
        try {
            if (strassenschluessel == null) {
                return new ArrayList<ArrayList>();
            }
            MetaClass MC_MAUERLASCHE = ms.getClassByTableName(this.getUser(), "mauerlasche");
            String query = "SELECT " + MC_MAUERLASCHE.getId() + ", mauerlasche.id FROM mauerlasche, tkey_strassenschluessel WHERE mauerlasche.fk_strassenschluessel = tkey_strassenschluessel.id AND tkey_strassenschluessel.pk like '" + strassenschluessel + "' ";
            if (laufendeNummer != null) {
                query = query + "AND mauerlasche.laufende_nummer = " + laufendeNummer + " ";
            }
            query = query + "AND (mauerlasche.is_deleted IS NULL or mauerlasche.is_deleted IS FALSE) ";
            LOG.info((Object)query);
            return ms.performCustomSearch(query);
        }
        catch (Exception ex) {
            LOG.error((Object)"error in retrieveMauerlasche", (Throwable)ex);
            return new ArrayList<ArrayList>();
        }
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public String getStrassenschluessel() {
        return this.strassenschluessel;
    }

    public void setStrassenschluessel(String strassenschluessel) {
        this.strassenschluessel = strassenschluessel;
    }

    public Integer getKennziffer() {
        return this.kennziffer;
    }

    public void setKennziffer(Integer kennziffer) {
        this.kennziffer = kennziffer;
    }

    public Integer getLaufendeNummer() {
        return this.laufendeNummer;
    }

    public void setLaufendeNummer(Integer laufendeNummer) {
        this.laufendeNummer = laufendeNummer;
    }
}

