/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.action;

import Sirius.server.newuser.User;
import de.cismet.belis2.server.action.AbstractBelisServerActionV3;
import de.cismet.belis2.server.utils.BelisWebdavProperties;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.commons.security.WebDavClient;
import de.cismet.commons.security.WebDavHelper;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.ExifReader;
import de.cismet.tools.PasswordEncrypter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class UploadDocumentAction
implements ServerAction,
UserAwareServerAction {
    private static final Logger LOG = Logger.getLogger(UploadDocumentAction.class);
    private static final ConnectionContext CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.ACTION, (String)"UploadTzbAction");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected final Map<String, Object> paramsHashMap = new HashMap<String, Object>();
    private User usr = null;

    public User getUser() {
        return this.usr;
    }

    public void setUser(User user) {
        this.usr = user;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        String data = null;
        String name = null;
        String resultUrlAsString = null;
        for (ServerActionParameter param : params) {
            String key = param.getKey().toLowerCase();
            Object value = param.getValue();
            if (key.equalsIgnoreCase(ParameterType.data.name())) {
                data = value.toString();
                continue;
            }
            if (!key.equalsIgnoreCase(ParameterType.name.name())) continue;
            name = value.toString();
        }
        try {
            String imageData;
            if (data instanceof String && (imageData = data) != null) {
                try {
                    resultUrlAsString = UploadDocumentAction.writeImage(imageData, name);
                    CidsBean url = AbstractBelisServerActionV3.createDmsURLFromLink(resultUrlAsString, name);
                    return url.toJSONString(true);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    return "{\"error\":, \"" + ex.getMessage() + "\"}";
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot create tzb_tree_action cids bean", (Throwable)e);
            return "{\"error\":, \"" + e.getMessage() + "\"}";
        }
        return "{\"error\":, \"no data\"}";
    }

    protected void addParam(String key, Object value) {
        this.paramsHashMap.put(key, value);
    }

    protected Object getParam(String key, Class clazz) {
        Collection values = this.getListParam(key, clazz);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Collection getListParam(String key, Class clazz) {
        ArrayList<java.util.Date> objects = new ArrayList<java.util.Date>();
        if (!this.paramsHashMap.containsKey(key.toLowerCase())) return objects;
        for (Object val : (List)this.paramsHashMap.get(key.toLowerCase())) {
            Object object = null;
            if (val instanceof String) {
                long timestamp;
                String value = (String)val;
                if (java.util.Date.class.equals((Object)clazz)) {
                    timestamp = Long.parseLong(value);
                    object = new java.util.Date(timestamp);
                } else if (Date.class.equals((Object)clazz)) {
                    timestamp = Long.parseLong(value);
                    object = new Date(timestamp);
                } else if (Timestamp.class.equals((Object)clazz)) {
                    timestamp = Long.parseLong(value);
                    object = new Timestamp(timestamp);
                } else if (Integer.class.equals((Object)clazz)) {
                    object = Integer.parseInt(value);
                } else if (Float.class.equals((Object)clazz)) {
                    object = Float.valueOf(Float.parseFloat(value));
                } else if (Long.class.equals((Object)clazz)) {
                    object = Long.parseLong(value);
                } else if (Double.class.equals((Object)clazz)) {
                    object = Double.parseDouble(value);
                } else if (Boolean.class.equals((Object)clazz)) {
                    if ("ja".equals(value.toLowerCase())) {
                        object = true;
                    } else {
                        if (!"nein".equals(value.toLowerCase())) throw new UnsupportedOperationException("wrong boolean value");
                        object = false;
                    }
                } else {
                    if (!String.class.equals((Object)clazz)) throw new UnsupportedOperationException("this class is not supported");
                    object = value;
                }
            } else if (val == null) {
                object = null;
            } else if (ArrayList.class.equals((Object)clazz)) {
                object = val;
            }
            objects.add((java.util.Date)object);
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeImage(String imageData, String name) throws Exception {
        FileOutputStream fos = null;
        try {
            BelisWebdavProperties properties = BelisWebdavProperties.load();
            String ending = "";
            if (name.lastIndexOf(".") != -1) {
                ending = name.substring(name.lastIndexOf(".") + 1);
            }
            String webDavRoot = properties.getUrl();
            String webFileName = UploadDocumentAction.createFileName(ending);
            File tempFile = UploadDocumentAction.uploadToWebDav(webDavRoot, properties.getUsername(), properties.getPassword(), imageData, null, webFileName, ending);
            if (ending.equals("jpg") || ending.equals("png")) {
                byte[] bytes = UploadDocumentAction.createThumbnail(tempFile, ending);
                UploadDocumentAction.uploadToWebDav(webDavRoot, properties.getUsername(), properties.getPassword(), imageData, bytes, webFileName + ".thumbnail." + ending, ending);
            }
            String string = webDavRoot + webFileName;
            return string;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                LOG.fatal((Object)ex, (Throwable)ex);
            }
        }
    }

    private static String createFileName(String ending) {
        Random rand = new Random();
        return "IMG-" + rand.nextInt() + "_" + System.currentTimeMillis() + "." + ending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File uploadToWebDav(String webDavRoot, String user, String passwd, String imageData, byte[] imageAsBytes, String webFileName, String ending) throws Exception {
        File tempFile = File.createTempFile("file", "." + ending);
        FileOutputStream fos = null;
        WebDavClient webDavClient = null;
        byte[] imageDataAsByteA = imageAsBytes;
        if (imageDataAsByteA == null) {
            imageDataAsByteA = UploadDocumentAction.convertFileDataToBytes(imageData);
        }
        try {
            int httpStatusCode;
            fos = new FileOutputStream(tempFile);
            fos.write(imageDataAsByteA);
            fos.close();
            if (webDavClient == null) {
                String pass = passwd;
                if (pass != null && pass.startsWith(PasswordEncrypter.CRYPT_PREFIX)) {
                    pass = PasswordEncrypter.decryptString((String)passwd);
                }
                webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), user, pass);
            }
            if ((httpStatusCode = WebDavHelper.uploadFileToWebDAV((String)webFileName, (File)tempFile, (String)webDavRoot, webDavClient, null)) / 100 != 2) {
                throw new Exception("Cannot upload image. Status code = " + httpStatusCode);
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        return tempFile;
    }

    private static BufferedImage rotate(BufferedImage src, int degrees) {
        if (degrees % 360 == 0) {
            return src;
        }
        double rads = Math.toRadians(degrees);
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int dstW = degrees == 90 || degrees == 270 ? srcH : srcW;
        int dstH = degrees == 90 || degrees == 270 ? srcW : srcH;
        BufferedImage dst = new BufferedImage(dstW, dstH, 1);
        Graphics2D g = dst.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        switch (degrees) {
            case 90: {
                g.translate(dstW, 0);
                break;
            }
            case 180: {
                g.translate(dstW, dstH);
                break;
            }
            case 270: {
                g.translate(0, dstH);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported rotation: " + degrees);
            }
        }
        g.rotate(rads);
        g.drawImage((Image)src, 0, 0, null);
        g.dispose();
        return dst;
    }

    public static byte[] createThumbnail(File tempFile, String ending) throws Exception {
        BufferedImage imgOrig = ImageIO.read(tempFile);
        ExifReader reader = new ExifReader(tempFile);
        Double rotation = reader.getOrientationRotation();
        if (rotation == null) {
            rotation = 0.0;
        }
        BufferedImage orientedImg = UploadDocumentAction.rotate(imgOrig, rotation.intValue());
        int height = orientedImg.getHeight(null);
        int width = orientedImg.getWidth(null);
        int longestSide = Math.max(width, height);
        double scale = 1.0;
        if (longestSide > 600) {
            scale = 600.0 / (double)longestSide;
        }
        int swidth = (int)Math.round((double)width * scale);
        int sheight = (int)Math.round((double)height * scale);
        BufferedImage imgThumb = new BufferedImage(swidth, sheight, 1);
        Graphics2D g = imgThumb.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(orientedImg, 0, 0, swidth, sheight, null);
        g.dispose();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)imgThumb, ending, os);
        return os.toByteArray();
    }

    public static void main(String[] args) {
        try {
            byte[] thumb = UploadDocumentAction.createThumbnail(new File("/home/therter/Downloads/IMG-887392315_1768496235662.jpg"), "jpg");
            FileOutputStream fos = new FileOutputStream("/home/therter/Downloads/IMG-887392315_1768496235662.jpg.t.jpg");
            fos.write(thumb);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] convertFileDataToBytes(String imageData) {
        String base64String = imageData.indexOf("base64,") != -1 ? imageData.substring(imageData.indexOf("base64,") + "base64,".length()) : imageData;
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(base64String);
    }

    public String getTaskName() {
        return "uploadBelisDocument";
    }

    public static enum ParameterType {
        data,
        name;

    }
}

