/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class NextVeranlassungNummerSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(NextVeranlassungNummerSearch.class);
    private static final DecimalFormat DF = new DecimalFormat("00000000");
    private final SearchInfo searchInfo = new SearchInfo();

    public NextVeranlassungNummerSearch() {
        this.searchInfo.setKey(((Object)((Object)this)).getClass().getName());
        this.searchInfo.setName(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setDescription("Search for next Veranlassungsnummer");
        LinkedList parameterDescription = new LinkedList();
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo resultParameterInfo = new SearchParameterInfo();
        resultParameterInfo.setKey("return");
        resultParameterInfo.setArray(true);
        resultParameterInfo.setType(Type.LONG);
        this.searchInfo.setResultDescription(resultParameterInfo);
    }

    public static String getStringRepresentation(List<Long> searchResult) {
        Long number = searchResult.isEmpty() ? null : searchResult.get(0);
        return DF.format(number);
    }

    public Collection performServerSearch() {
        ArrayList<Long> numbers = new ArrayList<Long>();
        String query = "SELECT nextval('veranlassungnummer_seq');";
        MetaService metaService = (MetaService)this.getActiveLocalServers().get("BELIS2");
        try {
            for (ArrayList fields : metaService.performCustomSearch("SELECT nextval('veranlassungnummer_seq');")) {
                numbers.add((Long)fields.get(0));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"", (Throwable)ex);
        }
        return numbers;
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }
}

