/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.utils;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import de.cismet.belis2.server.search.LockedEntitySearch;
import de.cismet.belis2.server.utils.ActionNotSuccessfulException;
import de.cismet.belis2.server.utils.LockAlreadyExistsException;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.tools.URLSplitter;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Logger;

public class BelisServerUtils {
    private static final Logger LOG = Logger.getLogger(BelisServerUtils.class);

    public static MetaObjectNode lockEntities(Collection<String> objectsToLock, User user) throws ActionNotSuccessfulException, LockAlreadyExistsException {
        try {
            if (objectsToLock != null) {
                Collection<MetaObjectNode> locks = BelisServerUtils.checkIfLocked(objectsToLock, user);
                if (locks != null && !locks.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"A lock for the desired object is already existing");
                    }
                    throw new LockAlreadyExistsException("A lock for the desired object is already existing", locks);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"There is no Lock for the object");
                }
                CidsBean newLock = CidsBean.createNewCidsBeanFromTableName((String)"BELIS2", (String)"sperre");
                newLock.setProperty("lock_timestamp", (Object)new java.sql.Date(new Date().getTime()));
                newLock.setProperty("user_string", (Object)(user.getName() + (user.getUserGroup() != null ? "@" + user.getUserGroup() : "")));
                for (String objectToLock : objectsToLock) {
                    String[] splitted = objectToLock.split("@");
                    Integer objectId = Integer.parseInt(splitted[0]);
                    Integer classdId = Integer.parseInt(splitted[1]);
                    CidsBean newLockEntity = CidsBean.createNewCidsBeanFromTableName((String)"BELIS2", (String)"sperre_entity");
                    newLockEntity.setProperty("class_id", (Object)classdId);
                    newLockEntity.setProperty("object_id", (Object)objectId);
                    newLock.getBeanCollectionProperty("n_sperre_entities").add(newLockEntity);
                }
                MetaObject persisted = DomainServerImpl.getServerInstance().insertMetaObject(user, newLock.getMetaObject());
                MetaObjectNode mon = new MetaObjectNode("BELIS2", persisted.getID(), persisted.getClassID(), "", null, null);
                mon.setObject(persisted);
                return mon;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The objectcollection to lock is null");
            }
            throw new ActionNotSuccessfulException("The objectcollection to lock is null");
        }
        catch (ActionNotSuccessfulException e) {
            throw e;
        }
        catch (LockAlreadyExistsException e) {
            throw e;
        }
        catch (Exception ex) {
            LOG.error((Object)"Exception while creating lock", (Throwable)ex);
            throw new ActionNotSuccessfulException("Exception while creating lock", ex);
        }
    }

    public static Collection<MetaObjectNode> checkIfLocked(Collection<String> objectToCheck, User user) throws Exception {
        LockedEntitySearch search = new LockedEntitySearch(objectToCheck);
        search.setUser(user);
        return search.performServerSearch();
    }

    public void unlock(CidsBean holdedLock, User user) throws ActionNotSuccessfulException {
        try {
            if (holdedLock != null) {
                DomainServerImpl.getServerInstance().deleteMetaObject(user, holdedLock.getMetaObject());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failure while releasing lock", (Throwable)ex);
            throw new ActionNotSuccessfulException("Failure while releasing lock", ex);
        }
    }

    public static String implodeArray(String[] inputArray, String glueString) {
        String output = "";
        if (inputArray.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(inputArray[0]);
            for (int i = 1; i < inputArray.length; ++i) {
                sb.append(glueString);
                sb.append(inputArray[i]);
            }
            output = sb.toString();
        }
        return output;
    }

    public static CidsBean createDmsURLFromLink(String link, String description) throws Exception {
        if (link == null || description == null) {
            throw new NullPointerException();
        }
        CidsBean dmsUrlBean = CidsBean.createNewCidsBeanFromTableName((String)"BELIS2", (String)"dms_url");
        CidsBean urlBean = CidsBean.createNewCidsBeanFromTableName((String)"BELIS2", (String)"url");
        CidsBean urlBaseBean = CidsBean.createNewCidsBeanFromTableName((String)"BELIS2", (String)"url_base");
        URLSplitter splitter = new URLSplitter(link);
        dmsUrlBean.setProperty("description", (Object)description);
        urlBean.setProperty("url_base_id", (Object)urlBaseBean);
        dmsUrlBean.setProperty("url_id", (Object)urlBean);
        urlBaseBean.setProperty("path", (Object)splitter.getPath());
        urlBaseBean.setProperty("prot_prefix", (Object)splitter.getProt_prefix());
        urlBaseBean.setProperty("server", (Object)splitter.getServer());
        urlBean.setProperty("object_name", (Object)splitter.getObject_name());
        return dmsUrlBean;
    }
}

