/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.action;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.belis2.server.action.AbstractBelisServerActionV3;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.util.List;
import org.apache.log4j.Logger;

public class AddDokumentServerActionV3
extends AbstractBelisServerActionV3 {
    private static final Logger LOG = Logger.getLogger(AddDokumentServerActionV3.class);
    private static final ConnectionContext CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.ACTION, (String)"AddDokumentServerAction");

    @Override
    protected Object processExecution() throws Exception {
        String dokumenteProperty;
        int objectId = (Integer)this.getParam(ParameterType.OBJEKT_ID.toString(), Integer.class);
        String className = (String)this.getParam(ParameterType.OBJEKT_TYP.toString(), String.class);
        MetaClass metaClass = CidsBean.getMetaClassFromTableName((String)"BELIS2", (String)className.toLowerCase(), (ConnectionContext)CC);
        if (metaClass == null) {
            throw new Exception("metaclass " + className + " not found");
        }
        int classId = metaClass.getID();
        CidsBean bean = DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), objectId, classId, CC).getBean();
        if (bean == null) {
            throw new Exception(className + " with id " + objectId + " not found");
        }
        String tableName = metaClass.getTableName().toLowerCase();
        if ("leitung".equals(tableName)) {
            dokumenteProperty = "dokumente";
        } else if ("tdta_leuchten".equals(tableName)) {
            dokumenteProperty = "dokumente";
        } else if ("tdta_standort_mast".equals(tableName)) {
            dokumenteProperty = "dokumente";
        } else if ("abzweigdose".equals(tableName)) {
            dokumenteProperty = "dokumente";
        } else if ("mauerlasche".equals(tableName)) {
            dokumenteProperty = "dokumente";
        } else if ("schaltstelle".equals(tableName)) {
            dokumenteProperty = "dokumente";
        } else if ("geometrie".equals(tableName)) {
            dokumenteProperty = "dokumente";
        } else {
            throw new Exception("dokument upload not supported for " + className);
        }
        List dokumente = bean.getBeanCollectionProperty(dokumenteProperty);
        for (String urlMitBeschreibung : this.getListParam(ParameterType.DOKUMENT_URL.toString(), String.class)) {
            String[] urlMitBeschreibungArray = urlMitBeschreibung.split("\\n");
            String url = urlMitBeschreibungArray[0];
            String beschreibung = urlMitBeschreibungArray[1];
            CidsBean dmsUrl = AddDokumentServerActionV3.createDmsURLFromLink(url, beschreibung);
            dokumente.add(dmsUrl);
        }
        DomainServerImpl.getServerInstance().updateMetaObject(this.getUser(), bean.getMetaObject(), CC);
        return true;
    }

    public String getTaskName() {
        return "addDocument";
    }

    public static enum ParameterType {
        OBJEKT_ID,
        OBJEKT_TYP,
        DOKUMENT_URL;

    }
}

