/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.action;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.belis2.server.action.AbstractBelisServerActionV3;
import de.cismet.belis2.server.action.ProtokollAktion.ProtokollFortfuehrungsantragServerActionV3;
import de.cismet.belis2.server.action.UploadDocumentServerActionV3;
import de.cismet.belis2.server.search.NextArbeitsauftragNummerSearch;
import de.cismet.belis2.server.search.NextVeranlassungNummerSearch;
import de.cismet.belis2.server.search.VeranlassungsArtSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NewIncidentActionV3
extends AbstractBelisServerActionV3 {
    private static final Logger LOG = Logger.getLogger(NewIncidentActionV3.class);
    private static final String SCHLUESSEL_STOERUNG = "S";
    public static final String TASKNAME = "addIncident";
    private final Map dummyLocalServers = new HashMap();

    @Override
    protected Object processExecution() throws Exception {
        CidsBean goBean;
        CidsBean arbeitsauftragBean;
        MetaClass goMetaClass;
        int goId = (Integer)this.getParam(ParameterType.OBJEKT_ID.toString(), Integer.class);
        String goClassName = ((String)this.getParam(ParameterType.OBJEKT_TYP.toString(), String.class)).toLowerCase();
        String bezeichnung = (String)this.getParam(ParameterType.BEZEICHNUNG.toString(), String.class);
        String beschreibung = (String)this.getParam(ParameterType.BESCHREIBUNG.toString(), String.class);
        String bemerkung = (String)this.getParam(ParameterType.BEMERKUNG.toString(), String.class);
        String aktion = (String)this.getParam(ParameterType.AKTION.toString(), String.class);
        Integer arbeitsauftragZugewiesenAn = (Integer)this.getParam(ParameterType.ARBEITSAUFTRAG_ZUGEWIESEN_AN.toString(), Integer.class);
        Double ccnonce = (Double)this.getParam(ProtokollFortfuehrungsantragServerActionV3.ParameterType.CCNONCE.toString(), Double.class);
        ArrayList images = (ArrayList)this.getListParam(ParameterType.IMAGES.toString(), ArrayList.class);
        ArrayList<String> urls = new ArrayList<String>();
        if (images != null) {
            for (Object image : images) {
                ImageData data = new ImageData((Map)image);
                String url = UploadDocumentServerActionV3.writeImage(data.getPrefix(), data.getTs(), data.getDescription(), data.getEnding(), data.getImageData(), goId, goClassName);
                urls.add(url);
            }
        }
        try {
            goMetaClass = CidsBean.getMetaClassFromTableName((String)"BELIS2", (String)goClassName);
        }
        catch (Exception ex) {
            throw this.logAndNewException("could not get Metaclass with tableName=" + goClassName, ex, ExceptionType.ERROR);
        }
        if (goMetaClass == null) {
            throw this.logAndNewException("metaclass " + goClassName + " not found", ExceptionType.WARN);
        }
        Date now = new Date(Calendar.getInstance().getTime().getTime());
        if (Aktion.EINZELAUFTRAG.toString().equals(aktion)) {
            try {
                arbeitsauftragBean = this.createArbeitsauftragBean(arbeitsauftragZugewiesenAn, now, ccnonce);
            }
            catch (Exception ex) {
                throw this.logAndNewException("could not create Arbeitsauftrag", ex, ExceptionType.WARN);
            }
        }
        if (Aktion.ADD2ARBEITSAUFTRAG.toString().equals(aktion)) {
            int arbeitsauftragId = (Integer)this.getParam(ParameterType.ARBEITSAUFTRAG.toString(), Integer.class);
            try {
                arbeitsauftragBean = this.searchArbeitsauftragBean(arbeitsauftragId);
            }
            catch (Exception ex) {
                throw this.logAndNewException("search Arbeitsauftrag failed", ex, ExceptionType.WARN);
            }
            if (arbeitsauftragBean == null) {
                throw this.logAndNewException("could not find Arbeitsauftrag with id=" + arbeitsauftragId, ExceptionType.WARN);
            }
        } else if (Aktion.VERANLASSUNG.toString().equals(aktion)) {
            arbeitsauftragBean = null;
        } else {
            throw this.logAndNewException("unknow Aktion-Type: " + aktion, ExceptionType.WARN);
        }
        try {
            goBean = DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), goId, goMetaClass.getID()).getBean();
        }
        catch (Exception ex) {
            throw this.logAndNewException("could not find " + goClassName + " with id=" + goId, ex, ExceptionType.WARN);
        }
        CidsBean veranlassungBean = this.createVeranlassungBean(goBean, goClassName, bezeichnung, beschreibung, bemerkung, now, urls);
        try {
            DomainServerImpl.getServerInstance().insertMetaObject(this.getUser(), veranlassungBean.getMetaObject());
        }
        catch (Exception ex) {
            throw this.logAndNewException("could not insert new Veranlassung", ex, ExceptionType.ERROR);
        }
        if (arbeitsauftragBean != null) {
            CidsBean arbeitsauftragProtokollBean;
            List arbeitsprotokolle = arbeitsauftragBean.getBeanCollectionProperty("ar_protokolle");
            try {
                arbeitsauftragProtokollBean = this.createArbeitsprotokollBean(goBean, goClassName, arbeitsprotokolle.size() + 1, (String)veranlassungBean.getProperty("nummer"), ccnonce);
            }
            catch (Exception ex) {
                throw this.logAndNewException("could not create arbeitsprotokoll", ex, ExceptionType.ERROR);
            }
            arbeitsprotokolle.add(arbeitsauftragProtokollBean);
            if (1 == arbeitsauftragBean.getMetaObject().getStatus()) {
                try {
                    DomainServerImpl.getServerInstance().insertMetaObject(this.getUser(), arbeitsauftragBean.getMetaObject());
                }
                catch (Exception ex) {
                    throw this.logAndNewException("could not insert new Arbeitsauftrag", ex, ExceptionType.ERROR);
                }
            }
            try {
                DomainServerImpl.getServerInstance().updateMetaObject(this.getUser(), arbeitsauftragBean.getMetaObject());
            }
            catch (Exception ex) {
                throw this.logAndNewException("could not update Veranlassung", ex, ExceptionType.ERROR);
            }
        }
        return true;
    }

    private Exception logAndNewException(String message, ExceptionType type) {
        return this.logAndNewException(message, null, type);
    }

    private Exception logAndNewException(String message, Exception ex, ExceptionType type) {
        if (type != null) {
            switch (type) {
                case WARN: {
                    if (ex == null) {
                        LOG.warn((Object)message);
                        break;
                    }
                    LOG.warn((Object)message, (Throwable)ex);
                    break;
                }
                case ERROR: {
                    if (ex == null) {
                        LOG.error((Object)message);
                        break;
                    }
                    LOG.error((Object)message, (Throwable)ex);
                }
            }
        }
        if (ex == null) {
            return new Exception(message);
        }
        return new Exception(message, ex);
    }

    private CidsBean searchArbeitsauftragBean(int arbeitsauftragId) throws Exception {
        MetaClass arbeitsauftragMetaClass = CidsBean.getMetaClassFromTableName((String)"BELIS2", (String)"arbeitsauftrag");
        if (arbeitsauftragMetaClass == null) {
            throw new Exception("metaclass " + arbeitsauftragMetaClass + " not found");
        }
        MetaObject arbeitsauftragMo = DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), arbeitsauftragId, arbeitsauftragMetaClass.getId());
        if (arbeitsauftragMo == null) {
            throw new Exception("arbeitsauftrag with id " + arbeitsauftragId + " not found");
        }
        CidsBean arbeitsauftragBean = arbeitsauftragMo.getBean();
        return arbeitsauftragBean;
    }

    private CidsBean getTeamBean(int teamId) throws Exception {
        MetaClass teamMetaClass = CidsBean.getMetaClassFromTableName((String)"BELIS2", (String)"team");
        if (teamMetaClass == null) {
            throw new Exception("metaclass for team not found");
        }
        MetaObject teamMo = DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), teamId, teamMetaClass.getId());
        if (teamMo == null) {
            throw new Exception("team with id " + teamId + " not found");
        }
        CidsBean teamBean = teamMo.getBean();
        return teamBean;
    }

    private CidsBean createArbeitsauftragBean(Integer arbeitsauftragZugewiesenAn, Date now, double ccnonce) throws Exception {
        CidsBean arbeitsauftragBean = CidsBean.createNewCidsBeanFromTableName((String)"BELIS2", (String)"arbeitsauftrag");
        String arbeitsauftragNummer = NextArbeitsauftragNummerSearch.getStringRepresentation((List)this.executeSearch((CidsServerSearch)new NextArbeitsauftragNummerSearch()));
        arbeitsauftragBean.setProperty("nummer", (Object)arbeitsauftragNummer);
        arbeitsauftragBean.setProperty("angelegt_am", (Object)now);
        arbeitsauftragBean.setProperty("angelegt_von", (Object)this.getUser().getName());
        arbeitsauftragBean.setProperty("ccnonce", (Object)ccnonce);
        if (arbeitsauftragZugewiesenAn != null) {
            arbeitsauftragBean.setProperty("zugewiesen_an", (Object)this.getTeamBean(arbeitsauftragZugewiesenAn));
        }
        return arbeitsauftragBean;
    }

    private CidsBean createVeranlassungBean(CidsBean goBean, String goClassName, String bezeichnung, String beschreibung, String bemerkung, Date now, Collection<String> urls) throws Exception {
        String veranlassungGoCollectionProperty;
        CidsBean veranlassungBean = CidsBean.createNewCidsBeanFromTableName((String)"BELIS2", (String)"veranlassung");
        if ("abzweigdose".equalsIgnoreCase(goClassName)) {
            veranlassungGoCollectionProperty = "ar_abzweigdosen";
        } else if ("leitung".equalsIgnoreCase(goClassName)) {
            veranlassungGoCollectionProperty = "ar_leitungen";
        } else if ("tdta_leuchten".equalsIgnoreCase(goClassName)) {
            veranlassungGoCollectionProperty = "ar_leuchten";
        } else if ("mauerlasche".equalsIgnoreCase(goClassName)) {
            veranlassungGoCollectionProperty = "ar_mauerlaschen";
        } else if ("schaltstelle".equalsIgnoreCase(goClassName)) {
            veranlassungGoCollectionProperty = "ar_schaltstellen";
        } else if ("tdta_standort_mast".equalsIgnoreCase(goClassName)) {
            veranlassungGoCollectionProperty = "ar_standorte";
        } else {
            throw new Exception("could not determine collectionProperty for " + goClassName);
        }
        String veranlassungNummer = NextVeranlassungNummerSearch.getStringRepresentation((List)this.executeSearch((CidsServerSearch)new NextVeranlassungNummerSearch()));
        Collection veranlassungsArtMos = this.executeSearch((CidsServerSearch)new VeranlassungsArtSearch(VeranlassungsArtSearch.SearchBy.SCHLUESSEL, SCHLUESSEL_STOERUNG, true));
        if (veranlassungsArtMos == null || veranlassungsArtMos.isEmpty()) {
            throw new Exception("could not find veranlassung_art with schluessel = S");
        }
        CidsBean veranlassungsArtBean = ((MetaObject)veranlassungsArtMos.iterator().next()).getBean();
        veranlassungBean.getBeanCollectionProperty(veranlassungGoCollectionProperty).add(goBean);
        veranlassungBean.setProperty("bezeichnung", (Object)bezeichnung);
        veranlassungBean.setProperty("beschreibung", (Object)beschreibung);
        veranlassungBean.setProperty("bemerkungen", (Object)bemerkung);
        veranlassungBean.setProperty("datum", (Object)now);
        veranlassungBean.setProperty("username", (Object)this.getUser().getName());
        veranlassungBean.setProperty("nummer", (Object)veranlassungNummer);
        veranlassungBean.setProperty("fk_art", (Object)veranlassungsArtBean);
        if (urls != null) {
            for (String urlMitBeschreibung : urls) {
                String[] urlMitBeschreibungArray = urlMitBeschreibung.split("\\n");
                String url = urlMitBeschreibungArray[0];
                String urlBeschreibung = urlMitBeschreibungArray[1];
                CidsBean dmsUrl = NewIncidentActionV3.createDmsURLFromLink(url, urlBeschreibung);
                veranlassungBean.getBeanCollectionProperty("ar_dokumente").add(dmsUrl);
            }
        }
        return veranlassungBean;
    }

    private CidsBean createArbeitsprotokollBean(CidsBean goBean, String goClassName, int protokollnummer, String veranlassungsnummer, Double ccnonce) throws Exception {
        String arbeitsauftragProtokollCollectionProperty;
        CidsBean arbeitsauftragProtokoll = CidsBean.createNewCidsBeanFromTableName((String)"BELIS2", (String)"arbeitsprotokoll");
        if ("abzweigdose".equalsIgnoreCase(goClassName)) {
            arbeitsauftragProtokollCollectionProperty = "fk_abzweigdose";
        } else if ("leitung".equalsIgnoreCase(goClassName)) {
            arbeitsauftragProtokollCollectionProperty = "fk_leitung";
        } else if ("tdta_leuchten".equalsIgnoreCase(goClassName)) {
            arbeitsauftragProtokollCollectionProperty = "fk_leuchte";
        } else if ("mauerlasche".equalsIgnoreCase(goClassName)) {
            arbeitsauftragProtokollCollectionProperty = "fk_mauerlasche";
        } else if ("schaltstelle".equalsIgnoreCase(goClassName)) {
            arbeitsauftragProtokollCollectionProperty = "fk_schaltstelle";
        } else if ("tdta_standort_mast".equalsIgnoreCase(goClassName)) {
            arbeitsauftragProtokollCollectionProperty = "fk_standort";
        } else {
            throw new Exception("could not determine collectionProperty for " + goClassName);
        }
        arbeitsauftragProtokoll.setProperty(arbeitsauftragProtokollCollectionProperty, (Object)goBean);
        arbeitsauftragProtokoll.setProperty("protokollnummer", (Object)protokollnummer);
        arbeitsauftragProtokoll.setProperty("veranlassungsnummer", (Object)veranlassungsnummer);
        arbeitsauftragProtokoll.setProperty("ccnonce", (Object)ccnonce);
        return arbeitsauftragProtokoll;
    }

    private Collection executeSearch(CidsServerSearch search) throws SearchException {
        search.setUser(this.getUser());
        search.setActiveLocalServers(this.getDummyLocalServers());
        return search.performServerSearch();
    }

    @Override
    public void setMetaService(MetaService metaService) {
        super.setMetaService(metaService);
        this.getDummyLocalServers().put("BELIS2", this.getMetaService());
    }

    public String getTaskName() {
        return TASKNAME;
    }

    public Map getDummyLocalServers() {
        return this.dummyLocalServers;
    }

    private static class ImageData {
        String imageData;
        String ending;
        String description;
        long ts;
        String prefix;

        public ImageData(Map data) {
            this.imageData = this.getParam(data, "imagedata");
            this.ending = this.getParam(data, "ending");
            this.description = this.getParam(data, "description");
            this.prefix = this.getParam(data, "prefix");
            this.ts = Long.parseLong(this.getParam(data, "ts"));
        }

        private String getParam(Map data, String name) {
            for (Object key : data.keySet()) {
                String keyString;
                if (!(key instanceof String) || !(keyString = (String)key).equalsIgnoreCase(name.toLowerCase())) continue;
                return (String)data.get(key);
            }
            return null;
        }

        public String getImageData() {
            return this.imageData;
        }

        public String getEnding() {
            return this.ending;
        }

        public String getDescription() {
            return this.description;
        }

        public long getTs() {
            return this.ts;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    public static enum ExceptionType {
        ERROR,
        WARN;

    }

    public static enum Aktion {
        VERANLASSUNG,
        EINZELAUFTRAG,
        ADD2ARBEITSAUFTRAG;

    }

    public static enum ParameterType {
        OBJEKT_ID,
        OBJEKT_TYP,
        DOKUMENT_URLS,
        BEZEICHNUNG,
        BESCHREIBUNG,
        BEMERKUNG,
        AKTION,
        ARBEITSAUFTRAG,
        ARBEITSAUFTRAG_ZUGEWIESEN_AN,
        IMAGES,
        CCNONCE;

    }
}

