/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.action;

import de.cismet.belis2.server.action.AddDokumentServerActionV3;
import de.cismet.belis2.server.action.UploadDocumentAction;
import de.cismet.belis2.server.utils.BelisWebdavProperties;
import de.cismet.cids.utils.serverresources.ServerResource;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.cids.utils.serverresources.TextServerResource;
import de.cismet.commons.security.WebDavClient;
import de.cismet.commons.security.WebDavHelper;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.PasswordEncrypter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.GregorianCalendar;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class UploadDocumentServerActionV3
extends AddDokumentServerActionV3 {
    private static final Logger LOG = Logger.getLogger(UploadDocumentServerActionV3.class);
    private static final String FILE_PREFIX = "DOC-";
    private static final String LOCAL_FILE_PREFIX = "DEV-";

    @Override
    protected Object processExecution() throws Exception {
        String imageData = (String)this.getParam(ParameterType.ImageData.toString(), String.class);
        String dev = (String)this.getParam(ParameterType.PREFIX.toString(), String.class);
        int objectId = (Integer)this.getParam(AddDokumentServerActionV3.ParameterType.OBJEKT_ID.toString(), Integer.class);
        String className = (String)this.getParam(AddDokumentServerActionV3.ParameterType.OBJEKT_TYP.toString(), String.class);
        try {
            String endung = (String)this.getParam(ParameterType.Ending.toString(), String.class);
            String beschreibung = (String)this.getParam(ParameterType.Description.toString(), String.class);
            Long ts = (Long)this.getParam(ParameterType.TS.toString(), Long.class);
            String documentUrl = UploadDocumentServerActionV3.writeImage(dev, ts, beschreibung, endung, imageData, objectId, className);
            this.addParam(AddDokumentServerActionV3.ParameterType.DOKUMENT_URL.toString().toLowerCase(), documentUrl);
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
            throw ex;
        }
        return super.processExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeImage(String prefix, Long ts, String description, String ending, String imageData, Integer objectId, String className) throws Exception {
        FileOutputStream fos = null;
        String tsString = UploadDocumentServerActionV3.dateFromTimestamp(ts);
        try {
            if (prefix == null || !prefix.toLowerCase().equals("dev")) {
                Object bytes;
                String pre = prefix == null ? FILE_PREFIX : prefix;
                String webFileName = UploadDocumentServerActionV3.createFileName(pre, className, objectId, ending);
                BelisWebdavProperties properties = BelisWebdavProperties.load();
                String webDavRoot = properties.getUrl();
                File tempFile = UploadDocumentServerActionV3.uploadToWebDav(imageData, null, webFileName, ending);
                if (ending.equals("jpg") || ending.equals("png")) {
                    bytes = UploadDocumentAction.createThumbnail(tempFile, ending);
                    UploadDocumentServerActionV3.uploadToWebDav(imageData, bytes, webFileName + ".thumbnail." + ending, ending);
                }
                bytes = webDavRoot + webFileName + "\n" + description + tsString;
                return bytes;
            }
            UploadConfig config = (UploadConfig)ServerResourcesLoader.getInstance().loadJson((ServerResource)new TextServerResource("/imageUpload/config.json"), UploadConfig.class);
            if (!config.useDefaultWebdav) {
                String webFileName = UploadDocumentServerActionV3.createFileName(LOCAL_FILE_PREFIX, className, objectId, ending);
                String rootPath = config.getPath();
                if (!rootPath.endsWith("/")) {
                    rootPath = rootPath + "/";
                }
                fos = new FileOutputStream(new File(rootPath, webFileName));
                fos.write(UploadDocumentServerActionV3.convertFileDataToBytes(imageData));
                String webDavRoot = rootPath + webFileName + "\n" + description + tsString;
                return webDavRoot;
            }
            String pre = prefix == null ? LOCAL_FILE_PREFIX : prefix;
            String webDavPath = config.getPath().endsWith("/") ? config.getPath() : config.getPath() + "/";
            String webFileName = UploadDocumentServerActionV3.createFileName(pre, className, objectId, ending);
            BelisWebdavProperties properties = BelisWebdavProperties.load();
            String webDavRoot = properties.getUrl();
            File tempFile = UploadDocumentServerActionV3.uploadToWebDav(imageData, null, webDavPath + webFileName, ending);
            if (ending.equals("jpg") || ending.equals("png")) {
                byte[] bytes = UploadDocumentAction.createThumbnail(tempFile, ending);
                UploadDocumentServerActionV3.uploadToWebDav(imageData, bytes, webDavPath + webFileName + ".thumbnail." + ending, ending);
            }
            String string = webDavRoot + webFileName + "\n" + description + tsString;
            return string;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                LOG.fatal((Object)ex, (Throwable)ex);
            }
        }
    }

    private static String createFileName(String prefix, String type, Integer id, String ending) {
        return prefix + "." + type + "." + id + "." + System.currentTimeMillis() + "." + ending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File uploadToWebDav(String imageData, byte[] imageAsBytes, String webFileName, String ending) throws Exception {
        File tempFile = File.createTempFile("file", "." + ending);
        FileOutputStream fos = null;
        WebDavClient webDavClient = null;
        byte[] imageDataAsByteA = imageAsBytes;
        if (imageDataAsByteA == null) {
            imageDataAsByteA = UploadDocumentServerActionV3.convertFileDataToBytes(imageData);
        }
        try {
            int httpStatusCode;
            fos = new FileOutputStream(tempFile);
            fos.write(imageDataAsByteA);
            fos.close();
            BelisWebdavProperties properties = BelisWebdavProperties.load();
            String webDavRoot = properties.getUrl();
            if (webDavClient == null) {
                String user = properties.getUsername();
                String pass = properties.getPassword();
                if (pass != null && pass.startsWith(PasswordEncrypter.CRYPT_PREFIX)) {
                    pass = PasswordEncrypter.decryptString((String)pass);
                }
                webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), user, pass);
            }
            if ((httpStatusCode = WebDavHelper.uploadFileToWebDAV((String)webFileName, (File)tempFile, (String)webDavRoot, webDavClient, null)) / 100 != 2) {
                throw new Exception("Cannot upload image. Status code = " + httpStatusCode);
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        return tempFile;
    }

    private static byte[] createThumbnail(File tempFile, String ending) throws Exception {
        BufferedImage img = ImageIO.read(tempFile);
        int height = ((Image)img).getHeight(null);
        int width = ((Image)img).getWidth(null);
        int longestSide = Math.max(width, height);
        double scale = 1.0;
        if (longestSide > 600) {
            scale = 600.0 / (double)longestSide;
        }
        BufferedImage imgThumb = new BufferedImage((int)((double)width * scale), (int)((double)height * scale), 1);
        imgThumb.createGraphics().drawImage(img.getScaledInstance((int)((double)width * scale), (int)((double)height * scale), 4), 0, 0, null);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)imgThumb, ending, os);
        return os.toByteArray();
    }

    public static void main(String[] args) {
        System.out.println("time:" + UploadDocumentServerActionV3.dateFromTimestamp(1634234133025L));
    }

    private static String dateFromTimestamp(Long ts) {
        if (ts == null) {
            return "";
        }
        GregorianCalendar gc = new GregorianCalendar();
        StringBuilder sb = new StringBuilder(13);
        gc.setTimeInMillis(ts);
        sb.append(" (").append(gc.get(5)).append(".").append(gc.get(2) + 1).append(".").append(gc.get(1)).append(")");
        return sb.toString();
    }

    private static byte[] convertFileDataToBytes(String imageData) {
        String base64String = imageData.indexOf("base64,") != -1 ? imageData.substring(imageData.indexOf("base64,") + "base64,".length()) : imageData;
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(base64String);
    }

    @Override
    public String getTaskName() {
        return "uploadDocument";
    }

    private static class UploadConfig {
        boolean useDefaultWebdav;
        String path;

        public boolean isUseDefaultWebdav() {
            return this.useDefaultWebdav;
        }

        public String getPath() {
            return this.path;
        }

        public void setUseDefaultWebdav(boolean useDefaultWebdav) {
            this.useDefaultWebdav = useDefaultWebdav;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static enum ParameterType {
        ImageData,
        PREFIX,
        Ending,
        Description,
        TS;

    }
}

