/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.sql.PreparableStatement;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKTReader;
import de.cismet.belis2.server.utils.BelisServerUtils;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.builtin.GeoSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class BelisSearchStatement
extends AbstractCidsServerSearch
implements GeoSearch,
RestApiCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(BelisSearchStatement.class);
    private static int SRID = 25832;
    private final SearchInfo searchInfo = new SearchInfo();
    private boolean standortEnabled = false;
    private boolean mastOhneLeuchtenEnabled = false;
    private boolean mastMitLeuchtenEnabled = false;
    private boolean schaltstelleEnabled = false;
    private boolean mauerlascheEnabled = false;
    private boolean leitungEnabled = false;
    private boolean abzweigdoseEnabled = false;
    private boolean leuchteEnabled = false;
    private boolean veranlassungEnabled = false;
    private boolean arbeitsauftragEnabled = false;
    private boolean arbeitsprotokollEnabled = false;
    private boolean activeObjectsOnly = true;
    private boolean workedoffObjectsOnly = false;
    private boolean specialOnly = false;
    private boolean deletedOnly = false;
    private boolean showDeleted = false;
    private Geometry geometry;
    private String geometryFromWkt;

    public BelisSearchStatement() {
        this.searchInfo.setKey(((Object)((Object)this)).getClass().getName());
        this.searchInfo.setName(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setDescription("Search for Belis Entities");
        LinkedList<SearchParameterInfo> parameterDescription = new LinkedList<SearchParameterInfo>();
        SearchParameterInfo searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("standortEnabled");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("mastOhneLeuchtenEnabled");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("mastMitLeuchtenEnabled");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("schaltstelleEnabled");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("mauerlascheEnabled");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("leitungEnabled");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("abzweigdoseEnabled");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("leuchteEnabled");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("veranlassungEnabled");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("arbeitsauftragEnabled");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("arbeitsprotokollEnabled");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("activeObjectsOnly");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("workedoffObjectsOnly");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("specialOnly");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("deletedOnly");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("showDeleted");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("geometry");
        searchParameterInfo.setType(Type.UNDEFINED);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("geometryFromWkt");
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo resultParameterInfo = new SearchParameterInfo();
        resultParameterInfo.setKey("return");
        resultParameterInfo.setArray(true);
        resultParameterInfo.setType(Type.NODE);
        this.searchInfo.setResultDescription(resultParameterInfo);
    }

    public BelisSearchStatement(boolean standortEnabled, boolean leuchteEnabled, boolean schaltstelleEnabled, boolean mauerlascheEnabled, boolean leitungEnabled, boolean abzweigdoseEnabled, boolean veranlassungEnabled, boolean arbeitsauftragEnabled) {
        this();
        this.setStandortEnabled(standortEnabled);
        this.setLeuchteEnabled(leuchteEnabled);
        this.setSchaltstelleEnabled(schaltstelleEnabled);
        this.setMauerlascheEnabled(mauerlascheEnabled);
        this.setLeitungEnabled(leitungEnabled);
        this.setAbzweigdoseEnabled(abzweigdoseEnabled);
        this.setVeranlassungEnabled(veranlassungEnabled);
        this.setArbeitsauftragEnabled(arbeitsauftragEnabled);
        this.setArbeitsprotokollEnabled(false);
        this.setSpecialOnly(false);
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            String percentCondition;
            String closedSelect;
            MetaService ms = (MetaService)this.getActiveLocalServers().get("BELIS2");
            MetaClass MC_STANDORT = ms.getClassByTableName(this.getUser(), "tdta_standort_mast");
            MetaClass MC_LEUCHTE = ms.getClassByTableName(this.getUser(), "tdta_leuchten");
            MetaClass MC_SCHALTSTELLE = ms.getClassByTableName(this.getUser(), "schaltstelle");
            MetaClass MC_LEITUNG = ms.getClassByTableName(this.getUser(), "leitung");
            MetaClass MC_ABZWEIGDOSE = ms.getClassByTableName(this.getUser(), "abzweigdose");
            MetaClass MC_MAUERLASCHE = ms.getClassByTableName(this.getUser(), "mauerlasche");
            MetaClass MC_VERANLASSUNG = ms.getClassByTableName(this.getUser(), "veranlassung");
            MetaClass MC_ARBEITSAUFTRAG = ms.getClassByTableName(this.getUser(), "arbeitsauftrag");
            MetaClass MC_ARBEITSPROTOKOLL = ms.getClassByTableName(this.getUser(), "arbeitsprotokoll");
            if (!(this.standortEnabled || this.mastMitLeuchtenEnabled || this.mastOhneLeuchtenEnabled || this.leuchteEnabled || this.schaltstelleEnabled || this.mauerlascheEnabled || this.leitungEnabled || this.abzweigdoseEnabled || this.veranlassungEnabled || this.arbeitsauftragEnabled || this.arbeitsprotokollEnabled)) {
                return new ArrayList<MetaObjectNode>();
            }
            ArrayList<String> union = new ArrayList<String>();
            ArrayList<String> join = new ArrayList<String>();
            ArrayList<String> joinFilter = new ArrayList<String>();
            if (!this.specialOnly && (this.standortEnabled || this.mastMitLeuchtenEnabled || this.mastOhneLeuchtenEnabled)) {
                union.add("SELECT " + MC_STANDORT.getId() + " AS classid, id AS objectid, id AS searchIntoId, is_deleted, fk_geom, 'Standort'::text AS searchIntoClass FROM tdta_standort_mast");
                join.add("tdta_standort_mast ON geom_objects.searchIntoClass = 'Standort' AND tdta_standort_mast.id = geom_objects.searchIntoId");
                if (!(!this.isMastMitLeuchtenEnabled() && !this.isMastOhneLeuchtenEnabled() || this.isMastMitLeuchtenEnabled() && this.isMastOhneLeuchtenEnabled())) {
                    join.add("tdta_leuchten AS _tdta_leuchten ON _tdta_leuchten.fk_standort = tdta_standort_mast.id");
                }
                joinFilter.add("tdta_standort_mast.id IS NOT null");
            }
            if (!this.specialOnly && this.leuchteEnabled) {
                union.add("SELECT " + MC_LEUCHTE.getId() + " AS classid, tdta_leuchten.id AS objectid, tdta_leuchten.id AS searchIntoId, tdta_standort_mast.is_deleted, tdta_standort_mast.fk_geom AS fk_geom, 'Leuchte'::text AS searchIntoClass FROM tdta_leuchten LEFT JOIN tdta_standort_mast ON tdta_leuchten.fk_standort = tdta_standort_mast.id");
                join.add("tdta_leuchten ON geom_objects.searchIntoClass = 'Leuchte' AND tdta_leuchten.id = geom_objects.searchIntoId AND (tdta_leuchten.is_deleted IS NULL OR tdta_leuchten.is_deleted IS FALSE)");
                joinFilter.add("tdta_leuchten.id IS NOT null");
            }
            if (!this.specialOnly && this.schaltstelleEnabled) {
                union.add("SELECT " + MC_SCHALTSTELLE.getId() + " AS classid, id AS objectid, id AS searchIntoId, is_deleted, fk_geom, 'Schaltstelle'::text AS searchIntoClass FROM schaltstelle");
                join.add("schaltstelle ON geom_objects.searchIntoClass = 'Schaltstelle' AND schaltstelle.id = geom_objects.searchIntoId");
                joinFilter.add("schaltstelle.id IS NOT null");
            }
            if (!this.specialOnly && this.mauerlascheEnabled) {
                union.add("SELECT " + MC_MAUERLASCHE.getId() + " AS classid, id AS objectid, id AS searchIntoId, is_deleted, fk_geom, 'Mauerlasche'::text AS searchIntoClass FROM mauerlasche");
                join.add("mauerlasche ON geom_objects.searchIntoClass = 'Mauerlasche' AND mauerlasche.id = geom_objects.searchIntoId");
                joinFilter.add("mauerlasche.id IS NOT null");
            }
            if (!this.specialOnly && this.leitungEnabled) {
                union.add("SELECT " + MC_LEITUNG.getId() + " AS classid, id AS objectid, id AS searchIntoId, is_deleted, fk_geom, 'Leitung'::text AS searchIntoClass FROM leitung");
                join.add("leitung ON geom_objects.searchIntoClass = 'Leitung' AND leitung.id = geom_objects.searchIntoId");
                joinFilter.add("leitung.id IS NOT null");
            }
            if (!this.specialOnly && this.abzweigdoseEnabled) {
                union.add("SELECT " + MC_ABZWEIGDOSE.getId() + " AS classid, id AS objectid, id AS searchIntoId, is_deleted, fk_geom, 'Abzweigdose'::text AS searchIntoClass FROM abzweigdose");
                join.add("abzweigdose ON geom_objects.searchIntoClass = 'Abzweigdose' AND abzweigdose.id = geom_objects.searchIntoId");
                joinFilter.add("abzweigdose.id IS NOT null");
            }
            if (this.veranlassungEnabled) {
                closedSelect = "SELECT veranlassung.id AS veranlassung_id, count(*) AS arbeitsprotokoll_count FROM arbeitsprotokoll, veranlassung WHERE veranlassung.nummer = arbeitsprotokoll.veranlassungsnummer GROUP BY veranlassung.id";
                percentCondition = (this.activeObjectsOnly ? "closedselect.arbeitsprotokoll_count IS NULL" : "TRUE") + " AND " + (this.workedoffObjectsOnly ? "closedselect.arbeitsprotokoll_count IS NOT NULL" : "TRUE");
                if (!this.specialOnly || this.specialOnly && this.leuchteEnabled) {
                    union.add("SELECT    " + MC_VERANLASSUNG.getId() + " AS classid,    veranlassung.id AS objectid,    veranlassung.id AS searchIntoId,    veranlassung.is_deleted AS is_deleted,    tdta_standort_mast.fk_geom AS fk_geom,    'Veranlassung'::text AS searchIntoClass FROM    veranlassung LEFT JOIN (" + "SELECT veranlassung.id AS veranlassung_id, count(*) AS arbeitsprotokoll_count FROM arbeitsprotokoll, veranlassung WHERE veranlassung.nummer = arbeitsprotokoll.veranlassungsnummer GROUP BY veranlassung.id" + ") AS closedSelect ON closedselect.veranlassung_id = veranlassung.id,    jt_veranlassung_leuchte,    tdta_leuchten,    tdta_standort_mast WHERE    veranlassung.ar_leuchten = jt_veranlassung_leuchte.veranlassung_reference    AND tdta_leuchten.id = jt_veranlassung_leuchte.fk_leuchte    AND tdta_standort_mast.id = tdta_leuchten.fk_standort    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.leitungEnabled) {
                    union.add("SELECT    " + MC_VERANLASSUNG.getId() + " AS classid,    veranlassung.id AS objectid,    veranlassung.id AS searchIntoId,    veranlassung.is_deleted AS is_deleted,    leitung.fk_geom AS fk_geom,    'Veranlassung'::text AS searchIntoClass FROM    veranlassung LEFT JOIN (" + "SELECT veranlassung.id AS veranlassung_id, count(*) AS arbeitsprotokoll_count FROM arbeitsprotokoll, veranlassung WHERE veranlassung.nummer = arbeitsprotokoll.veranlassungsnummer GROUP BY veranlassung.id" + ") AS closedSelect ON closedselect.veranlassung_id = veranlassung.id,    jt_veranlassung_leitung,    leitung WHERE    veranlassung.ar_leitungen = jt_veranlassung_leitung.veranlassung_reference    AND leitung.id = jt_veranlassung_leitung.fk_leitung    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.abzweigdoseEnabled) {
                    union.add("SELECT    " + MC_VERANLASSUNG.getId() + " AS classid,    veranlassung.id AS objectid,    veranlassung.id AS searchIntoId,    veranlassung.is_deleted AS is_deleted,    abzweigdose.fk_geom AS fk_geom,    'Veranlassung'::text AS searchIntoClass FROM    veranlassung LEFT JOIN (" + "SELECT veranlassung.id AS veranlassung_id, count(*) AS arbeitsprotokoll_count FROM arbeitsprotokoll, veranlassung WHERE veranlassung.nummer = arbeitsprotokoll.veranlassungsnummer GROUP BY veranlassung.id" + ") AS closedSelect ON closedselect.veranlassung_id = veranlassung.id,    jt_veranlassung_abzweigdose,    abzweigdose WHERE    veranlassung.ar_leitungen = jt_veranlassung_abzweigdose.veranlassung_reference    AND abzweigdose.id = jt_veranlassung_abzweigdose.fk_abzweigdose    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.standortEnabled) {
                    union.add("SELECT    " + MC_VERANLASSUNG.getId() + " AS classid,    veranlassung.id AS objectid,    veranlassung.id AS searchIntoId,    veranlassung.is_deleted AS is_deleted,    tdta_standort_mast.fk_geom AS fk_geom,    'Veranlassung'::text AS searchIntoClass FROM    veranlassung LEFT JOIN (" + "SELECT veranlassung.id AS veranlassung_id, count(*) AS arbeitsprotokoll_count FROM arbeitsprotokoll, veranlassung WHERE veranlassung.nummer = arbeitsprotokoll.veranlassungsnummer GROUP BY veranlassung.id" + ") AS closedSelect ON closedselect.veranlassung_id = veranlassung.id,    jt_veranlassung_standort,    tdta_standort_mast WHERE    veranlassung.ar_standorte = jt_veranlassung_standort.veranlassung_reference    AND tdta_standort_mast.id = jt_veranlassung_standort.fk_standort    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.schaltstelleEnabled) {
                    union.add("SELECT    " + MC_VERANLASSUNG.getId() + " AS classid,    veranlassung.id AS objectid,    veranlassung.id AS searchIntoId,    veranlassung.is_deleted AS is_deleted,    schaltstelle.fk_geom AS fk_geom,    'Veranlassung'::text AS searchIntoClass FROM    veranlassung LEFT JOIN (" + "SELECT veranlassung.id AS veranlassung_id, count(*) AS arbeitsprotokoll_count FROM arbeitsprotokoll, veranlassung WHERE veranlassung.nummer = arbeitsprotokoll.veranlassungsnummer GROUP BY veranlassung.id" + ") AS closedSelect ON closedselect.veranlassung_id = veranlassung.id,    jt_veranlassung_schaltstelle,    schaltstelle WHERE    veranlassung.ar_schaltstellen = jt_veranlassung_schaltstelle.veranlassung_reference    AND schaltstelle.id = jt_veranlassung_schaltstelle.fk_schaltstelle    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.mauerlascheEnabled) {
                    union.add("SELECT    " + MC_VERANLASSUNG.getId() + " AS classid,    veranlassung.id AS objectid,    veranlassung.id AS searchIntoId,    veranlassung.is_deleted AS is_deleted,    mauerlasche.fk_geom AS fk_geom,    'Veranlassung'::text AS searchIntoClass FROM    veranlassung LEFT JOIN (" + "SELECT veranlassung.id AS veranlassung_id, count(*) AS arbeitsprotokoll_count FROM arbeitsprotokoll, veranlassung WHERE veranlassung.nummer = arbeitsprotokoll.veranlassungsnummer GROUP BY veranlassung.id" + ") AS closedSelect ON closedselect.veranlassung_id = veranlassung.id,    jt_veranlassung_mauerlasche,    mauerlasche WHERE    veranlassung.ar_mauerlaschen = jt_veranlassung_mauerlasche.veranlassung_reference    AND mauerlasche.id = jt_veranlassung_mauerlasche.fk_mauerlasche    AND " + percentCondition);
                }
                union.add("SELECT    " + MC_VERANLASSUNG.getId() + " AS classid,    veranlassung.id AS objectid,    veranlassung.id AS searchIntoId,    veranlassung.is_deleted AS is_deleted,    geometrie.fk_geom AS fk_geom,    'Veranlassung'::text AS searchIntoClass FROM    veranlassung LEFT JOIN (" + "SELECT veranlassung.id AS veranlassung_id, count(*) AS arbeitsprotokoll_count FROM arbeitsprotokoll, veranlassung WHERE veranlassung.nummer = arbeitsprotokoll.veranlassungsnummer GROUP BY veranlassung.id" + ") AS closedSelect ON closedselect.veranlassung_id = veranlassung.id,    jt_veranlassung_geometrie,    geometrie WHERE    veranlassung.ar_geometrien = jt_veranlassung_geometrie.veranlassung_reference AND    geometrie.id = jt_veranlassung_geometrie.fk_geometrie    AND " + percentCondition);
                join.add("veranlassung ON geom_objects.searchIntoClass = 'Veranlassung' AND veranlassung.id = geom_objects.searchIntoId");
                joinFilter.add("veranlassung.id IS NOT null");
            }
            if (this.arbeitsauftragEnabled) {
                closedSelect = "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN arbeitsprotokollstatus.schluessel::int > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id";
                percentCondition = (this.activeObjectsOnly ? "closedselect.percent < 1" : "TRUE") + " AND " + (this.workedoffObjectsOnly ? "closedselect.percent >= 1" : "TRUE");
                if (!this.specialOnly || this.specialOnly && this.leuchteEnabled) {
                    union.add("SELECT    " + MC_ARBEITSAUFTRAG.getId() + " AS classid,    arbeitsauftrag.id AS objectid,    arbeitsauftrag.id AS searchIntoId,    arbeitsauftrag.is_deleted AS is_deleted,    tdta_standort_mast.fk_geom AS fk_geom,    'Arbeitsauftrag'::text AS searchIntoClass FROM arbeitsauftrag    LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference    LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll,    tdta_leuchten,    tdta_standort_mast,    (" + "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN arbeitsprotokollstatus.schluessel::int > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id" + ") AS closedSelect WHERE tdta_leuchten.id = arbeitsprotokoll.fk_leuchte    AND tdta_standort_mast.id = tdta_leuchten.fk_standort    AND closedselect.arbeitsauftrag_id = arbeitsauftrag.id    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.leitungEnabled) {
                    union.add("SELECT    " + MC_ARBEITSAUFTRAG.getId() + " AS classid,    arbeitsauftrag.id AS objectid,    arbeitsauftrag.id AS searchIntoId,    arbeitsauftrag.is_deleted AS is_deleted,    leitung.fk_geom AS fk_geom,    'Arbeitsauftrag'::text AS searchIntoClass FROM arbeitsauftrag    LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference    LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll,    leitung,    (" + "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN arbeitsprotokollstatus.schluessel::int > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id" + ") AS closedSelect WHERE leitung.id = arbeitsprotokoll.fk_leitung    AND closedselect.arbeitsauftrag_id = arbeitsauftrag.id    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.abzweigdoseEnabled) {
                    union.add("SELECT    " + MC_ARBEITSAUFTRAG.getId() + " AS classid,    arbeitsauftrag.id AS objectid,    arbeitsauftrag.id AS searchIntoId,    arbeitsauftrag.is_deleted AS is_deleted,    abzweigdose.fk_geom AS fk_geom,    'Arbeitsauftrag'::text AS searchIntoClass FROM arbeitsauftrag    LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference    LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll,    abzweigdose,    (" + "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN arbeitsprotokollstatus.schluessel::int > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id" + ") AS closedSelect WHERE abzweigdose.id = arbeitsprotokoll.fk_abzweigdose    AND closedselect.arbeitsauftrag_id = arbeitsauftrag.id    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.standortEnabled) {
                    union.add("SELECT    " + MC_ARBEITSAUFTRAG.getId() + " AS classid,    arbeitsauftrag.id AS objectid,    arbeitsauftrag.id AS searchIntoId,    arbeitsauftrag.is_deleted AS is_deleted,    tdta_standort_mast.fk_geom AS fk_geom,    'Arbeitsauftrag'::text AS searchIntoClass FROM arbeitsauftrag    LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference    LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll,    tdta_standort_mast,    (" + "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN arbeitsprotokollstatus.schluessel::int > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id" + ") AS closedSelect WHERE tdta_standort_mast.id = arbeitsprotokoll.fk_standort    AND closedselect.arbeitsauftrag_id = arbeitsauftrag.id    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.schaltstelleEnabled) {
                    union.add("SELECT    " + MC_ARBEITSAUFTRAG.getId() + " AS classid,    arbeitsauftrag.id AS objectid,    arbeitsauftrag.id AS searchIntoId,    arbeitsauftrag.is_deleted AS is_deleted,    schaltstelle.fk_geom AS fk_geom,    'Arbeitsauftrag'::text AS searchIntoClass FROM arbeitsauftrag    LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference    LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll,    schaltstelle,    (" + "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN arbeitsprotokollstatus.schluessel::int > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id" + ") AS closedSelect WHERE schaltstelle.id = arbeitsprotokoll.fk_schaltstelle    AND closedselect.arbeitsauftrag_id = arbeitsauftrag.id    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.mauerlascheEnabled) {
                    union.add("SELECT    " + MC_ARBEITSAUFTRAG.getId() + " AS classid,    arbeitsauftrag.id AS objectid,    arbeitsauftrag.id AS searchIntoId,    arbeitsauftrag.is_deleted AS is_deleted,    mauerlasche.fk_geom AS fk_geom,    'Arbeitsauftrag'::text AS searchIntoClass FROM arbeitsauftrag    LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference    LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll,    mauerlasche,    (" + "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN arbeitsprotokollstatus.schluessel::int > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id" + ") AS closedSelect WHERE mauerlasche.id = arbeitsprotokoll.fk_mauerlasche    AND closedselect.arbeitsauftrag_id = arbeitsauftrag.id    AND " + percentCondition);
                }
                union.add("SELECT    " + MC_ARBEITSAUFTRAG.getId() + " AS classid,    arbeitsauftrag.id AS objectid,    arbeitsauftrag.id AS searchIntoId,    arbeitsauftrag.is_deleted AS is_deleted,    geometrie.fk_geom AS fk_geom,    'Arbeitsauftrag'::text AS searchIntoClass FROM arbeitsauftrag    LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference    LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll,    geometrie,    (" + "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN arbeitsprotokollstatus.schluessel::int > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id" + ") AS closedSelect WHERE geometrie.id = arbeitsprotokoll.fk_geometrie    AND closedselect.arbeitsauftrag_id = arbeitsauftrag.id    AND " + percentCondition);
                join.add("arbeitsauftrag ON geom_objects.searchIntoClass = 'Arbeitsauftrag' AND arbeitsauftrag.id = geom_objects.searchIntoId");
                joinFilter.add("arbeitsauftrag.id IS NOT null");
            }
            if (this.arbeitsprotokollEnabled) {
                closedSelect = "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN fk_status > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id";
                percentCondition = (this.activeObjectsOnly ? "closedselect.percent < 1" : "TRUE") + " AND " + (this.workedoffObjectsOnly ? "closedselect.percent >= 1" : "TRUE");
                if (!this.specialOnly || this.specialOnly && this.leuchteEnabled) {
                    union.add("SELECT    " + MC_ARBEITSPROTOKOLL.getId() + " AS classid,    arbeitsprotokoll.id AS objectid,    arbeitsprotokoll.id AS searchIntoId,    arbeitsprotokoll.is_deleted AS is_deleted,    tdta_standort_mast.fk_geom AS fk_geom,    'Arbeitsprotokoll'::text AS searchIntoClass FROM arbeitsauftrag    LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference    LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll,    tdta_leuchten,    tdta_standort_mast,    (" + "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN fk_status > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id" + ") AS closedSelect WHERE tdta_leuchten.id = arbeitsprotokoll.fk_leuchte    AND tdta_standort_mast.id = tdta_leuchten.fk_standort    AND closedselect.arbeitsauftrag_id = arbeitsauftrag.id    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.leitungEnabled) {
                    union.add("SELECT    " + MC_ARBEITSPROTOKOLL.getId() + " AS classid,    arbeitsprotokoll.id AS objectid,    arbeitsprotokoll.id AS searchIntoId,    arbeitsprotokoll.is_deleted AS is_deleted,    leitung.fk_geom AS fk_geom,    'Arbeitsauftrag'::text AS searchIntoClass FROM arbeitsauftrag    LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference    LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll,    leitung,    (" + "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN fk_status > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id" + ") AS closedSelect WHERE leitung.id = arbeitsprotokoll.fk_leitung    AND closedselect.arbeitsauftrag_id = arbeitsauftrag.id    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.abzweigdoseEnabled) {
                    union.add("SELECT    " + MC_ARBEITSPROTOKOLL.getId() + " AS classid,    arbeitsprotokoll.id AS objectid,    arbeitsprotokoll.id AS searchIntoId,    arbeitsprotokoll.is_deleted AS is_deleted,    abzweigdose.fk_geom AS fk_geom,    'Arbeitsauftrag'::text AS searchIntoClass FROM arbeitsauftrag    LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference    LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll,    abzweigdose,    (" + "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN fk_status > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id" + ") AS closedSelect WHERE abzweigdose.id = arbeitsprotokoll.fk_abzweigdose    AND closedselect.arbeitsauftrag_id = arbeitsauftrag.id    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.standortEnabled) {
                    union.add("SELECT    " + MC_ARBEITSPROTOKOLL.getId() + " AS classid,    arbeitsprotokoll.id AS objectid,    arbeitsprotokoll.id AS searchIntoId,    arbeitsprotokoll.is_deleted AS is_deleted,    tdta_standort_mast.fk_geom AS fk_geom,    'Arbeitsauftrag'::text AS searchIntoClass FROM arbeitsauftrag    LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference    LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll,    tdta_standort_mast,    (" + "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN fk_status > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id" + ") AS closedSelect WHERE tdta_standort_mast.id = arbeitsprotokoll.fk_standort    AND closedselect.arbeitsauftrag_id = arbeitsauftrag.id    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.schaltstelleEnabled) {
                    union.add("SELECT    " + MC_ARBEITSPROTOKOLL.getId() + " AS classid,    arbeitsprotokoll.id AS objectid,    arbeitsprotokoll.id AS searchIntoId,    arbeitsprotokoll.is_deleted AS is_deleted,    schaltstelle.fk_geom AS fk_geom,    'Arbeitsauftrag'::text AS searchIntoClass FROM arbeitsauftrag    LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference    LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll,    schaltstelle,    (" + "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN fk_status > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id" + ") AS closedSelect WHERE schaltstelle.id = arbeitsprotokoll.fk_schaltstelle    AND closedselect.arbeitsauftrag_id = arbeitsauftrag.id    AND " + percentCondition);
                }
                if (!this.specialOnly || this.specialOnly && this.mauerlascheEnabled) {
                    union.add("SELECT    " + MC_ARBEITSPROTOKOLL.getId() + " AS classid,    arbeitsprotokoll.id AS objectid,    arbeitsprotokoll.id AS searchIntoId,    arbeitsprotokoll.is_deleted AS is_deleted,    mauerlasche.fk_geom AS fk_geom,    'Arbeitsauftrag'::text AS searchIntoClass FROM arbeitsauftrag    LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference    LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll,    mauerlasche,    (" + "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN fk_status > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id" + ") AS closedSelect WHERE mauerlasche.id = arbeitsprotokoll.fk_mauerlasche    AND closedselect.arbeitsauftrag_id = arbeitsauftrag.id    AND " + percentCondition);
                }
                union.add("SELECT    " + MC_ARBEITSPROTOKOLL.getId() + " AS classid,    arbeitsprotokoll.id AS objectid,    arbeitsprotokoll.id AS searchIntoId,    arbeitsprotokoll.is_deleted AS is_deleted,    geometrie.fk_geom AS fk_geom,    'Arbeitsauftrag'::text AS searchIntoClass FROM arbeitsauftrag    LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference    LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll,    geometrie,    (" + "SELECT arbeitsauftrag.id AS arbeitsauftrag_id, (count(CASE WHEN fk_status > 0 THEN 1 ELSE null END) / count(*)::float) AS percent FROM arbeitsauftrag LEFT JOIN jt_arbeitsauftrag_arbeitsprotokoll ON arbeitsauftrag.id = jt_arbeitsauftrag_arbeitsprotokoll.arbeitsauftrag_reference LEFT JOIN  arbeitsprotokoll ON arbeitsprotokoll.id = jt_arbeitsauftrag_arbeitsprotokoll.fk_arbeitsprotokoll LEFT JOIN arbeitsprotokollstatus ON arbeitsprotokoll.fk_status = arbeitsprotokollstatus.id GROUP BY arbeitsauftrag.id" + ") AS closedSelect WHERE geometrie.id = arbeitsprotokoll.fk_geometrie    AND closedselect.arbeitsauftrag_id = arbeitsauftrag.id    AND " + percentCondition);
                join.add("arbeitsprotokoll ON geom_objects.searchIntoClass = 'Arbeitsprotokoll' AND arbeitsprotokoll.id = geom_objects.searchIntoId");
                joinFilter.add("arbeitsprotokoll.id IS NOT null");
            }
            String implodedUnion = BelisServerUtils.implodeArray(union.toArray(new String[0]), " UNION ");
            String implodedJoin = joinFilter.isEmpty() ? "" : " LEFT JOIN " + BelisServerUtils.implodeArray(join.toArray(new String[0]), " LEFT JOIN ");
            String implodedJoinFilter = BelisServerUtils.implodeArray(joinFilter.toArray(new String[0]), " OR ");
            String deletedCondition = this.isShowDeleted() ? (this.isDeletedOnly() ? "(geom_objects.is_deleted IS TRUE)" : "TRUE") : "(geom_objects.is_deleted IS NULL OR geom_objects.is_deleted IS FALSE)";
            String query = "SELECT DISTINCT classid, objectid FROM (" + implodedUnion + ") AS geom_objects " + implodedJoin + ", geom WHERE geom.id = geom_objects.fk_geom AND (" + implodedJoinFilter + ") AND " + deletedCondition + " ";
            Geometry geometryToUse = null;
            if (this.geometry == null && this.geometryFromWkt != null) {
                String wkt;
                int wktSrid;
                int skIndex = this.geometryFromWkt.indexOf(59);
                if (skIndex > 0) {
                    String sridKV = this.geometryFromWkt.substring(0, skIndex);
                    int eqIndex = sridKV.indexOf(61);
                    if (eqIndex > 0) {
                        wktSrid = Integer.parseInt(sridKV.substring(eqIndex + 1));
                        wkt = this.geometryFromWkt.substring(skIndex + 1);
                    } else {
                        wkt = this.geometryFromWkt;
                        wktSrid = SRID;
                    }
                } else {
                    wkt = this.geometryFromWkt;
                    wktSrid = SRID;
                }
                try {
                    if (wktSrid < 0) {
                        geometryToUse = new WKTReader().read(wkt);
                        geometryToUse.setSRID(wktSrid);
                    }
                    GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), wktSrid);
                    geometryToUse = new WKTReader(geomFactory).read(wkt);
                    geometryToUse.setSRID(wktSrid);
                }
                catch (Exception ex) {
                    LOG.error((Object)"could not parse or transform WKT String", (Throwable)ex);
                    throw new IllegalArgumentException(ex);
                }
            } else {
                geometryToUse = this.geometry;
            }
            if (geometryToUse != null) {
                Geometry transformedGeom;
                if (geometryToUse.getSRID() != SRID) {
                    try {
                        CrsTransformer crsTransformer = new CrsTransformer(CrsTransformer.createCrsFromSrid((int)SRID));
                        transformedGeom = crsTransformer.transformGeometry(geometryToUse, CrsTransformer.createCrsFromSrid((int)geometryToUse.getSRID()));
                        transformedGeom.setSRID(SRID);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"could not parse or transform WKT String", (Throwable)ex);
                        throw new IllegalArgumentException(ex);
                    }
                } else {
                    transformedGeom = geometryToUse;
                }
                String geostring = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)transformedGeom);
                query = transformedGeom instanceof Polygon || transformedGeom instanceof MultiPolygon ? query + " AND geo_field && st_buffer(st_GeometryFromText('" + geostring + "'), 0.000001) and st_intersects(geo_field,st_buffer(st_GeometryFromText('" + geostring + "'), 0.000001))" : query + " AND geo_field && st_buffer(st_GeometryFromText('" + geostring + "') , 0.000001) and st_intersects(geo_field, st_GeometryFromText('" + geostring + "'))";
            }
            String andQueryPart = this.getAndQueryPart();
            query = query + (andQueryPart != null && !andQueryPart.trim().isEmpty() ? " AND " + andQueryPart : "");
            query = query + " GROUP BY geom_objects.objectid, geom_objects.classid ";
            String having = "";
            if (!(!this.isMastMitLeuchtenEnabled() && !this.isMastOhneLeuchtenEnabled() || this.isMastMitLeuchtenEnabled() && this.isMastOhneLeuchtenEnabled())) {
                having = this.isMastMitLeuchtenEnabled() ? having + "count(_tdta_leuchten.id) >= 1" : having + "count(_tdta_leuchten.id) = 0";
            }
            String havingPart = this.getHavingPart();
            if (!(having = having + (havingPart != null && !havingPart.trim().isEmpty() ? " AND " + havingPart : "")).isEmpty()) {
                query = query + " HAVING " + having;
            }
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            ArrayList searchResult = ms.performCustomSearch(query);
            LOG.info((Object)query);
            for (ArrayList al : searchResult) {
                int cid = (Integer)al.get(0);
                int oid = (Integer)al.get(1);
                MetaObjectNode mon = new MetaObjectNode("BELIS2", oid, cid, "", null, null);
                result.add(mon);
            }
            return result;
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Problem", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    protected String getAndQueryPart() {
        return null;
    }

    protected String getHavingPart() {
        return null;
    }

    public static String generateIdQuery(String field, Integer id) {
        return id != null ? String.format("%s = %d", field, id) : "TRUE";
    }

    public static String generateLikeQuery(String field, String like) {
        return like != null ? String.format("%s LIKE '%s'", field, like) : "TRUE";
    }

    public static String generateVonBisQuery(String field, String von, String bis) {
        return von != null ? (bis != null ? String.format("%s >= '%s' AND %s <= '%s'", field, von, field, bis) : String.format("%s >= '%s'", field, von)) : (bis != null ? String.format("%s <= '%s'", field, bis) : "TRUE");
    }

    public PreparableStatement getSearchSql(String domainKey) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public boolean isStandortEnabled() {
        return this.standortEnabled;
    }

    public void setStandortEnabled(boolean standortEnabled) {
        this.standortEnabled = standortEnabled;
    }

    public boolean isMastOhneLeuchtenEnabled() {
        return this.mastOhneLeuchtenEnabled;
    }

    public void setMastOhneLeuchtenEnabled(boolean mastOhneLeuchtenEnabled) {
        this.mastOhneLeuchtenEnabled = mastOhneLeuchtenEnabled;
    }

    public boolean isMastMitLeuchtenEnabled() {
        return this.mastMitLeuchtenEnabled;
    }

    public void setMastMitLeuchtenEnabled(boolean mastMitLeuchtenEnabled) {
        this.mastMitLeuchtenEnabled = mastMitLeuchtenEnabled;
    }

    public boolean isSchaltstelleEnabled() {
        return this.schaltstelleEnabled;
    }

    public void setSchaltstelleEnabled(boolean schaltstelleEnabled) {
        this.schaltstelleEnabled = schaltstelleEnabled;
    }

    public boolean isMauerlascheEnabled() {
        return this.mauerlascheEnabled;
    }

    public void setMauerlascheEnabled(boolean mauerlascheEnabled) {
        this.mauerlascheEnabled = mauerlascheEnabled;
    }

    public boolean isLeitungEnabled() {
        return this.leitungEnabled;
    }

    public void setLeitungEnabled(boolean leitungEnabled) {
        this.leitungEnabled = leitungEnabled;
    }

    public boolean isAbzweigdoseEnabled() {
        return this.abzweigdoseEnabled;
    }

    public void setAbzweigdoseEnabled(boolean abzweigdoseEnabled) {
        this.abzweigdoseEnabled = abzweigdoseEnabled;
    }

    public boolean isLeuchteEnabled() {
        return this.leuchteEnabled;
    }

    public void setLeuchteEnabled(boolean leuchteEnabled) {
        this.leuchteEnabled = leuchteEnabled;
    }

    public boolean isVeranlassungEnabled() {
        return this.veranlassungEnabled;
    }

    public void setVeranlassungEnabled(boolean veranlassungEnabled) {
        this.veranlassungEnabled = veranlassungEnabled;
    }

    public boolean isArbeitsauftragEnabled() {
        return this.arbeitsauftragEnabled;
    }

    public void setArbeitsauftragEnabled(boolean arbeitsauftragEnabled) {
        this.arbeitsauftragEnabled = arbeitsauftragEnabled;
    }

    public boolean isArbeitsprotokollEnabled() {
        return this.arbeitsprotokollEnabled;
    }

    public void setArbeitsprotokollEnabled(boolean arbeitsprotokollEnabled) {
        this.arbeitsprotokollEnabled = arbeitsprotokollEnabled;
    }

    public boolean isActiveObjectsOnly() {
        return this.activeObjectsOnly;
    }

    public void setActiveObjectsOnly(boolean activeObjectsOnly) {
        this.activeObjectsOnly = activeObjectsOnly;
    }

    public boolean isWorkedoffObjectsOnly() {
        return this.workedoffObjectsOnly;
    }

    public void setWorkedoffObjectsOnly(boolean workedoffObjectsOnly) {
        this.workedoffObjectsOnly = workedoffObjectsOnly;
    }

    public boolean isSpecialOnly() {
        return this.specialOnly;
    }

    public void setSpecialOnly(boolean specialOnly) {
        this.specialOnly = specialOnly;
    }

    public boolean isDeletedOnly() {
        return this.deletedOnly;
    }

    public void setDeletedOnly(boolean deletedOnly) {
        this.deletedOnly = deletedOnly;
    }

    public boolean isShowDeleted() {
        return this.showDeleted;
    }

    public void setShowDeleted(boolean showDeleted) {
        this.showDeleted = showDeleted;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public String getGeometryFromWkt() {
        return this.geometryFromWkt;
    }

    public void setGeometryFromWkt(String geometryFromWkt) {
        this.geometryFromWkt = geometryFromWkt;
    }
}

