/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.belis2.server.search.BelisSearchStatement;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class BelisTopicSearchStatement
extends BelisSearchStatement {
    private static final transient Logger LOG = Logger.getLogger(BelisTopicSearchStatement.class);

    @Override
    public Collection<MetaObjectNode> performServerSearch() {
        try {
            MetaService ms = (MetaService)this.getActiveLocalServers().get("BELIS2");
            MetaClass MC_STANDORT = ms.getClassByTableName(this.getUser(), "tdta_standort_mast");
            MetaClass MC_LEUCHTE = ms.getClassByTableName(this.getUser(), "tdta_leuchten");
            MetaClass MC_SCHALTSTELLE = ms.getClassByTableName(this.getUser(), "schaltstelle");
            MetaClass MC_LEITUNG = ms.getClassByTableName(this.getUser(), "leitung");
            MetaClass MC_ABZWEIGDOSE = ms.getClassByTableName(this.getUser(), "abzweigdose");
            MetaClass MC_MAUERLASCHE = ms.getClassByTableName(this.getUser(), "mauerlasche");
            MetaClass MC_VERANLASSUNG = ms.getClassByTableName(this.getUser(), "veranlassung");
            MetaClass MC_ARBEITSAUFTRAG = ms.getClassByTableName(this.getUser(), "arbeitsauftrag");
            ArrayList<Integer> classeIdList = new ArrayList<Integer>();
            String snippet = ((String)this.getClassesInSnippetsPerDomain().get("BELIS2")).replace("(", "").replace(")", "");
            for (String classId : snippet.split(",")) {
                try {
                    classeIdList.add(Integer.parseInt(classId));
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while parsing id", (Throwable)ex);
                }
            }
            this.setStandortEnabled(classeIdList.contains(MC_STANDORT.getID()));
            this.setLeuchteEnabled(classeIdList.contains(MC_LEUCHTE.getID()));
            this.setSchaltstelleEnabled(classeIdList.contains(MC_SCHALTSTELLE.getID()));
            this.setLeitungEnabled(classeIdList.contains(MC_LEITUNG.getID()));
            this.setAbzweigdoseEnabled(classeIdList.contains(MC_ABZWEIGDOSE.getID()));
            this.setMauerlascheEnabled(classeIdList.contains(MC_MAUERLASCHE.getID()));
            this.setVeranlassungEnabled(classeIdList.contains(MC_VERANLASSUNG.getID()));
            this.setArbeitsauftragEnabled(classeIdList.contains(MC_ARBEITSAUFTRAG.getID()));
            return super.performServerSearch();
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Problem", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

