/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class HighestLfdNummerSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(HighestLfdNummerSearch.class);
    private final SearchInfo searchInfo = new SearchInfo();
    private String strassenschluessel;
    private Integer kennziffer;

    public HighestLfdNummerSearch() {
        this.searchInfo.setKey(((Object)((Object)this)).getClass().getName());
        this.searchInfo.setName(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setDescription("Search for laufende Nummer");
        LinkedList<SearchParameterInfo> parameterDescription = new LinkedList<SearchParameterInfo>();
        SearchParameterInfo searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("strassenschluessel");
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("kennziffer");
        searchParameterInfo.setType(Type.INTEGER);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo resultParameterInfo = new SearchParameterInfo();
        resultParameterInfo.setKey("return");
        resultParameterInfo.setArray(true);
        resultParameterInfo.setType(Type.INTEGER);
        this.searchInfo.setResultDescription(resultParameterInfo);
    }

    public HighestLfdNummerSearch(String strassenschluessel, Integer kennziffer) {
        this();
        this.setStrassenschluessel(strassenschluessel);
        this.setKennziffer(kennziffer);
    }

    public Collection performServerSearch() {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        String query = String.format("SELECT MAX(tdta_standort_mast.lfd_nummer) FROM tdta_standort_mast LEFT JOIN tkey_strassenschluessel ON tdta_standort_mast.fk_strassenschluessel = tkey_strassenschluessel.id LEFT JOIN tkey_kennziffer ON tdta_standort_mast.fk_kennziffer = tkey_kennziffer.id WHERE tkey_strassenschluessel.pk = '%s' AND tkey_kennziffer.kennziffer = %d;", this.strassenschluessel, this.kennziffer);
        MetaService metaService = (MetaService)this.getActiveLocalServers().get("BELIS2");
        try {
            for (ArrayList fields : metaService.performCustomSearch(query)) {
                numbers.add((Integer)fields.get(0));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"problem fortfuehrung item search", (Throwable)ex);
        }
        return numbers;
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public String getStrassenschluessel() {
        return this.strassenschluessel;
    }

    public void setStrassenschluessel(String strassenschluessel) {
        this.strassenschluessel = strassenschluessel;
    }

    public Integer getKennziffer() {
        return this.kennziffer;
    }

    public void setKennziffer(Integer kennziffer) {
        this.kennziffer = kennziffer;
    }
}

