/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.search;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.belis2.server.utils.BelisServerUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class LockedEntitySearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(LockedEntitySearch.class);
    private final SearchInfo searchInfo = new SearchInfo();
    private Collection<String> objectToCheck;

    public LockedEntitySearch() {
        this.searchInfo.setKey(((Object)((Object)this)).getClass().getName());
        this.searchInfo.setName(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setDescription("Search for Belis locks");
        LinkedList<SearchParameterInfo> parameterDescription = new LinkedList<SearchParameterInfo>();
        SearchParameterInfo searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("objectToCheck");
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo resultParameterInfo = new SearchParameterInfo();
        resultParameterInfo.setKey("return");
        resultParameterInfo.setArray(true);
        resultParameterInfo.setType(Type.UNDEFINED);
        this.searchInfo.setResultDescription(resultParameterInfo);
    }

    public LockedEntitySearch(Collection<String> objectToCheck) {
        this();
        this.setObjectToCheck(objectToCheck);
    }

    public Collection performServerSearch() {
        try {
            ArrayList<MetaObjectNode> locks = new ArrayList<MetaObjectNode>();
            ArrayList<String> whereList = new ArrayList<String>();
            for (String lockedObject : this.objectToCheck) {
                if (lockedObject != null) {
                    String[] splitted = lockedObject.split("@");
                    String objectId = splitted[0];
                    String classId = splitted[1];
                    whereList.add("(class_id = " + classId + " AND object_id = " + objectId + ")");
                    continue;
                }
                LOG.warn((Object)"Entity is null. could not check if its locked");
            }
            if (whereList.isEmpty()) {
                return locks;
            }
            String whereSnippet = BelisServerUtils.implodeArray(whereList.toArray(new String[0]), " OR ");
            MetaClass mcSperre = CidsBean.getMetaClassFromTableName((String)"BELIS2", (String)"sperre");
            MetaClass mcSperreEntity = CidsBean.getMetaClassFromTableName((String)"BELIS2", (String)"sperre_entity");
            String query = "SELECT DISTINCT " + mcSperre.getID() + ", " + mcSperre.getTableName() + "." + mcSperre.getPrimaryKey() + ", lock_timestamp FROM " + mcSperre.getTableName() + ", " + mcSperreEntity.getTableName() + " WHERE sperre.id = fk_sperre AND (" + whereSnippet + ") ORDER BY lock_timestamp;";
            MetaObject[] mos = DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), query);
            if (mos != null) {
                for (MetaObject mo : mos) {
                    locks.add(new MetaObjectNode("BELIS2", mo.getId(), mo.getClassID(), "", null, null));
                }
            }
            return locks;
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public Collection<String> getObjectToCheck() {
        return this.objectToCheck;
    }

    public void setObjectToCheck(Collection<String> objectToCheck) {
        this.objectToCheck = objectToCheck;
    }
}

