/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class VeranlassungsArtSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(VeranlassungsArtSearch.class);
    private final SearchInfo searchInfo = new SearchInfo();
    private String search;
    private SearchBy searchBy;
    private boolean exactSearch;

    public VeranlassungsArtSearch() {
        this.searchInfo.setKey(((Object)((Object)this)).getClass().getName());
        this.searchInfo.setName(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setDescription("get VeranlassungArt by search string");
        LinkedList<SearchParameterInfo> parameterDescription = new LinkedList<SearchParameterInfo>();
        SearchParameterInfo searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("search");
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        SearchParameterInfo searchByParameterInfo = new SearchParameterInfo();
        searchByParameterInfo.setKey("searchBy");
        searchByParameterInfo.setType(Type.UNDEFINED);
        parameterDescription.add(searchByParameterInfo);
        SearchParameterInfo exactSearchParameterInfo = new SearchParameterInfo();
        exactSearchParameterInfo.setKey("exactSearch");
        exactSearchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(exactSearchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo resultParameterInfo = new SearchParameterInfo();
        resultParameterInfo.setKey("return");
        resultParameterInfo.setArray(true);
        resultParameterInfo.setType(Type.ENTITY);
        this.searchInfo.setResultDescription(resultParameterInfo);
    }

    public VeranlassungsArtSearch(SearchBy searchBy, String search, boolean exactSearch) {
        this();
        this.setSearchBy(searchBy);
        this.setSearch(search);
        this.setExactSearch(exactSearch);
    }

    public Collection performServerSearch() {
        String query = "";
        try {
            String whereProp;
            ArrayList<MetaObject> result = new ArrayList<MetaObject>();
            MetaClass mcVeranlassungArt = ((MetaService)this.getActiveLocalServers().get("BELIS2")).getClassByTableName(this.getUser(), "veranlassungsart");
            switch (this.getSearchBy()) {
                case SCHLUESSEL: {
                    whereProp = "schluessel";
                    break;
                }
                default: {
                    whereProp = "bezeichnung";
                }
            }
            if (this.getSearch() != null && this.getSearch().contains("'")) {
                return null;
            }
            String whereSearch = this.isExactSearch() ? this.getSearch() : "%" + this.getSearch() + "%";
            query = "SELECT DISTINCT " + mcVeranlassungArt.getID() + ", " + mcVeranlassungArt.getPrimaryKey() + " FROM " + mcVeranlassungArt.getTableName() + " WHERE " + whereProp + " LIKE '" + whereSearch + "';";
            MetaObject[] mos = ((MetaService)this.getActiveLocalServers().get("BELIS2")).getMetaObject(this.getUser(), query);
            if (mos != null) {
                for (MetaObject mo : mos) {
                    result.add(mo);
                }
            }
            return result;
        }
        catch (Exception ex) {
            LOG.error((Object)("Error during performServerSearch(" + query + ");"), (Throwable)ex);
            return null;
        }
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public SearchBy getSearchBy() {
        return this.searchBy;
    }

    public void setSearchBy(SearchBy searchBy) {
        this.searchBy = searchBy;
    }

    public boolean isExactSearch() {
        return this.exactSearch;
    }

    public void setExactSearch(boolean exactSearch) {
        this.exactSearch = exactSearch;
    }

    public static enum SearchBy {
        BEZEICHNUNG,
        SCHLUESSEL;

    }
}

