/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class VeranlassungsschluesselSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(VeranlassungsschluesselSearch.class);
    private final SearchInfo searchInfo = new SearchInfo();
    private String veranlassungsnummer;

    public VeranlassungsschluesselSearch() {
        this.searchInfo.setKey(((Object)((Object)this)).getClass().getName());
        this.searchInfo.setName(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setDescription("Search for Veranlassungsschluessel");
        LinkedList<SearchParameterInfo> parameterDescription = new LinkedList<SearchParameterInfo>();
        SearchParameterInfo searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("veranlassungsnummer");
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo resultParameterInfo = new SearchParameterInfo();
        resultParameterInfo.setKey("return");
        resultParameterInfo.setArray(true);
        resultParameterInfo.setType(Type.STRING);
        this.searchInfo.setResultDescription(resultParameterInfo);
    }

    public VeranlassungsschluesselSearch(String veranlassungsnummer) {
        this();
        this.setVeranlassungsnummer(veranlassungsnummer);
    }

    public Collection performServerSearch() {
        ArrayList<String> numbers = new ArrayList<String>();
        String query = "SELECT 'V' || veranlassung.nummer || CASE WHEN veranlassungsart.schluessel IS NULL THEN '' ELSE veranlassungsart.schluessel END FROM veranlassung LEFT JOIN veranlassungsart ON veranlassungsart.id = veranlassung.fk_art WHERE nummer ilike '" + this.veranlassungsnummer + "'";
        MetaService metaService = (MetaService)this.getActiveLocalServers().get("BELIS2");
        try {
            for (ArrayList fields : metaService.performCustomSearch(query)) {
                numbers.add((String)fields.get(0));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"problem VeranlassungsschluesselSearch", (Throwable)ex);
        }
        return numbers;
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public String getVeranlassungsnummer() {
        return this.veranlassungsnummer;
    }

    public void setVeranlassungsnummer(String veranlassungsnummer) {
        this.veranlassungsnummer = veranlassungsnummer;
    }
}

