/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.action.ProtokollAktion;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.belis2.server.action.AbstractBelisServerActionV3;
import de.cismet.belis2.server.action.ProtokollAktion.ProtokollStatusServerAction;
import de.cismet.belis2.server.utils.BelisServerUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public abstract class AbstractProtokollServerActionV3
extends AbstractBelisServerActionV3 {
    private static final Logger LOG = Logger.getLogger(AbstractProtokollServerActionV3.class);
    private static final ConnectionContext CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.ACTION, (String)"ProtokollServerActionV3");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object processExecution() {
        Integer protokollId = (Integer)this.getParam(ParameterType.PROTOKOLL_ID.toString(), Integer.class);
        if (protokollId != null) {
            try {
                Collection<MetaObjectNode> locks;
                int classId = CidsBean.getMetaClassFromTableName((String)"BELIS2", (String)"arbeitsprotokoll", (ConnectionContext)CC).getId();
                String entityKey = protokollId + "@" + classId;
                ArrayList<String> toLock = new ArrayList<String>(Arrays.asList(entityKey));
                MetaObject mo = DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), protokollId.intValue(), classId, CC);
                CidsBean protokoll = mo.getBean();
                ArrayList<CidsBean> children = new ArrayList<CidsBean>();
                children.add((CidsBean)protokoll.getProperty("fk_mauerlasche"));
                children.add((CidsBean)protokoll.getProperty("fk_leuchte"));
                children.add((CidsBean)protokoll.getProperty("fk_leitung"));
                children.add((CidsBean)protokoll.getProperty("fk_standort"));
                children.add((CidsBean)protokoll.getProperty("fk_abzweigdose"));
                children.add((CidsBean)protokoll.getProperty("fk_schaltstelle"));
                children.add((CidsBean)protokoll.getProperty("fk_geometrie"));
                for (CidsBean child : children) {
                    if (child == null) continue;
                    toLock.add(child.getMetaObject().getID() + "@" + child.getMetaObject().getClassID());
                    break;
                }
                if (!(locks = BelisServerUtils.checkIfLocked(toLock, this.getUser())).isEmpty()) {
                    return locks;
                }
                MetaObjectNode lockNode = BelisServerUtils.lockEntities(toLock, this.getUser());
                try {
                    this.executeAktion(protokoll);
                    DomainServerImpl.getServerInstance().updateMetaObject(this.getUser(), mo, CC);
                }
                finally {
                    DomainServerImpl.getServerInstance().deleteMetaObject(this.getUser(), lockNode.getObject(), CC);
                }
                return true;
            }
            catch (Exception ex) {
                LOG.fatal((Object)ex, (Throwable)ex);
                return ex;
            }
        }
        throw new RuntimeException("missing id as param");
    }

    public static CidsBean createProtokollBean(String aenderung, String newValue, String oldValue, Double ccnonce) throws Exception {
        CidsBean arbeitsprotokollaktionBean = CidsBean.createNewCidsBeanFromTableName((String)"BELIS2", (String)"arbeitsprotokollaktion", (ConnectionContext)CC);
        arbeitsprotokollaktionBean.setProperty("aenderung", (Object)aenderung);
        arbeitsprotokollaktionBean.setProperty("alt", (Object)oldValue);
        arbeitsprotokollaktionBean.setProperty("neu", (Object)newValue);
        arbeitsprotokollaktionBean.setProperty("ccnonce", (Object)ccnonce);
        return arbeitsprotokollaktionBean;
    }

    protected static CidsBean createAktion(String desc, CidsBean workbenchEntity, String property, Object newValue, Double ccnonce) throws Exception {
        Object oldValue = workbenchEntity.getProperty(property);
        workbenchEntity.setProperty(property, newValue);
        return AbstractProtokollServerActionV3.createProtokollBean(desc, AbstractProtokollServerActionV3.valueToString(newValue), AbstractProtokollServerActionV3.valueToString(oldValue), ccnonce);
    }

    protected void setStatus(CidsBean protokoll) throws Exception {
        if (this.paramsHashMap.get((Object)ProtokollStatusServerAction.ParameterType.MONTEUR.toString().toLowerCase()) != null) {
            protokoll.setProperty("monteur", (Object)((String)this.getParam(ProtokollStatusServerAction.ParameterType.MONTEUR.toString(), String.class)));
        }
        if (this.paramsHashMap.get((Object)ProtokollStatusServerAction.ParameterType.DATUM.toString().toLowerCase()) != null) {
            protokoll.setProperty("datum", this.getParam(ProtokollStatusServerAction.ParameterType.DATUM.toString(), Date.class));
        }
        if (this.paramsHashMap.get((Object)ProtokollStatusServerAction.ParameterType.STATUS.toString().toLowerCase()) != null) {
            protokoll.setProperty("fk_status", (Object)this.getCidsBeanFromParam(ProtokollStatusServerAction.ParameterType.STATUS.toString(), "arbeitsprotokollstatus"));
        }
    }

    protected abstract void executeAktion(CidsBean var1) throws Exception;

    public static enum ParameterType {
        PROTOKOLL_ID;

    }
}

