/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.action;

import de.cismet.belis2.server.action.AddDokumentServerAction;
import de.cismet.belis2.server.utils.BelisWebdavProperties;
import de.cismet.commons.security.WebDavClient;
import de.cismet.commons.security.WebDavHelper;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.PasswordEncrypter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class UploadDokumentServerAction
extends AddDokumentServerAction {
    private static final Logger LOG = Logger.getLogger(UploadDokumentServerAction.class);
    private static final String FILE_PREFIX = "DOC-";
    private WebDavClient webDavClient = null;

    @Override
    protected Object processExecution() throws Exception {
        for (String dokumentInfo : this.getListParam(ParameterType.UPLOAD_INFO.toString(), String.class)) {
            FileOutputStream fos = null;
            try {
                String[] dokumentInfoArray = dokumentInfo.split("\\n");
                String endung = dokumentInfoArray[0];
                String beschreibung = dokumentInfoArray[1];
                File tempFile = File.createTempFile(beschreibung, "." + endung);
                String webFileName = WebDavHelper.generateWebDAVFileName((String)FILE_PREFIX, (File)tempFile);
                fos = new FileOutputStream(tempFile);
                fos.write((byte[])this.getBody());
                BelisWebdavProperties properties = BelisWebdavProperties.load();
                String webDavRoot = properties.getUrl();
                if (this.webDavClient == null) {
                    String user = properties.getUsername();
                    String pass = properties.getPassword();
                    if (pass != null && pass.startsWith(PasswordEncrypter.CRYPT_PREFIX)) {
                        pass = PasswordEncrypter.decryptString((String)pass);
                    }
                    this.webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), user, pass);
                }
                WebDavHelper.uploadFileToWebDAV((String)webFileName, (File)tempFile, (String)webDavRoot, (WebDavClient)this.webDavClient, null);
                this.addParam(AddDokumentServerAction.ParameterType.DOKUMENT_URL.toString().toLowerCase(), webDavRoot + webFileName + "\n" + beschreibung);
            }
            catch (Exception ex) {
                LOG.fatal((Object)ex, (Throwable)ex);
                throw ex;
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    LOG.fatal((Object)ex, (Throwable)ex);
                }
            }
        }
        return super.processExecution();
    }

    @Override
    public String getTaskName() {
        return "UploadDokument";
    }

    public static enum ParameterType {
        UPLOAD_INFO;

    }
}

