/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.backend.legacy;

import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.RESTfulConnection;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler;
import Sirius.server.localserver.attribute.ObjectAttribute;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.UserGroup;
import com.fasterxml.jackson.databind.JsonNode;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.CallServerService;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.ws.SSLConfig;
import de.cismet.cids.server.ws.SSLConfigProvider;
import de.cismet.cids.server.ws.rest.RESTfulSerialInterfaceConnector;
import de.cismet.cidsx.server.api.types.CidsNode;
import de.cismet.cidsx.server.api.types.User;
import de.cismet.cidsx.server.api.types.legacy.ClassNameCache;
import de.cismet.cidsx.server.cores.legacy.LegacyCidsServerCore;
import de.cismet.cidsx.server.data.RuntimeContainer;
import de.cismet.cidsx.server.data.StatusHolder;
import de.cismet.cidsx.server.exceptions.CidsServerException;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.openide.util.Lookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyCoreBackend
implements ConnectionContextProvider {
    private static final Logger log = LoggerFactory.getLogger(LegacyCoreBackend.class);
    private static final LegacyCoreBackend INSTANCE = new LegacyCoreBackend();
    final SSLConfigProvider sslConfigProvider = (SSLConfigProvider)Lookup.getDefault().lookup(SSLConfigProvider.class);
    final SSLConfig sslConfig = this.sslConfigProvider == null ? null : this.sslConfigProvider.getSSLConfig();
    private final HashMap<User, Sirius.server.newuser.User> userMap = new HashMap();
    private final HashMap<String, ServerAction> serverActionMap = new HashMap();
    private final transient ClassNameCache classNameCache = new ClassNameCache();
    private final CallServerService service = new RESTfulSerialInterfaceConnector(LegacyCidsServerCore.getCallserver(), this.sslConfig, LegacyCidsServerCore.getClientName(), LegacyCidsServerCore.isCompressionEnabled());
    private boolean testModeEnabled = false;
    private Sirius.server.newuser.User testUser = null;
    private final ConnectionContext connectionContext = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.LEGACY, (String)this.getClass().getSimpleName());
    private final HashMap<String, JsonNode> classCache = new HashMap();
    private final HashMap<String, byte[]> classIconCache = new HashMap();
    private final HashMap<String, byte[]> objectIconCache = new HashMap();
    private final HashMap<String, byte[]> nodeIconCache = new HashMap();

    private LegacyCoreBackend() {
        this.loadServerActions();
        log.info("LegacyCoreBackend initialized with " + this.serverActionMap.size() + " server actions");
    }

    public MetaClass getMetaClassForClassname(String className, Sirius.server.newuser.User cidsUser) throws RemoteException {
        String tableName = className.toLowerCase();
        String domainName = RuntimeContainer.getServer().getDomainName();
        MetaClass metaClass = LegacyCoreBackend.getInstance().getService().getClassByTableName(cidsUser, tableName, domainName, this.getConnectionContext());
        return metaClass;
    }

    private void initProxy(User user) {
        try {
            ConnectionInfo info = new ConnectionInfo();
            info.setCallserverURL(LegacyCidsServerCore.getCallserver());
            info.setUsergroup(null);
            info.setUserDomain(user.getDomain());
            info.setUsergroupDomain(null);
            if (user.getJwt() != null && (user.getPass() == null || user.getUser() == null || user.getUser().equals("jwt"))) {
                info.setUsername("jwt");
                info.setPassword(user.getJwt());
            } else {
                info.setUsername(user.getUser());
                info.setPassword(user.getPass());
            }
            info.setPassword(user.getPass() != null ? user.getPass() : user.getJwt());
            Connection connection = ConnectionFactory.getFactory().createConnection(RESTfulConnection.class.getCanonicalName(), info.getCallserverURL(), LegacyCidsServerCore.getClientName(), LegacyCidsServerCore.isCompressionEnabled(), this.getConnectionContext());
            ConnectionSession session = ConnectionFactory.getFactory().createSession(connection, info, true, this.getConnectionContext());
            ConnectionProxy proxy = ConnectionFactory.getFactory().createProxy(DefaultConnectionProxyHandler.class.getCanonicalName(), session, this.getConnectionContext());
            SessionManager.init((ConnectionProxy)proxy);
            ClassCacheMultiple.setInstance((String)user.getDomain(), (ConnectionContext)this.getConnectionContext());
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public final void loadServerActions() {
        Collection serverActions = Lookup.getDefault().lookupAll(ServerAction.class);
        for (ServerAction serverAction : serverActions) {
            this.serverActionMap.put(serverAction.getTaskName(), serverAction);
        }
    }

    public void setEnableTestMode(boolean enabled) {
        this.testModeEnabled = enabled;
        try {
            this.testUser = this.service.getUser(null, null, LegacyCidsServerCore.getTestDomain(), LegacyCidsServerCore.getTestUser(), LegacyCidsServerCore.getTestPassword());
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public HashMap<String, ServerAction> getServerActionMap() {
        return this.serverActionMap;
    }

    public static LegacyCoreBackend getInstance() {
        return INSTANCE;
    }

    public CallServerService getService() {
        return this.service;
    }

    public void registerUser(Sirius.server.newuser.User cidsUser, User user) {
        if (!this.mapContainsCurrentUser(user, cidsUser.getJwsToken())) {
            this.initProxy(user);
            this.userMap.put(user, cidsUser);
            StatusHolder.getInstance().putStatus("cachedUsers", String.valueOf(this.userMap.size()));
        }
    }

    private boolean mapContainsCurrentUser(User user, String jwt) {
        if (!this.userMap.containsKey(user)) {
            return false;
        }
        Sirius.server.newuser.User u = this.userMap.get(user);
        if (u != null) {
            return u.getJwsToken().equals(jwt);
        }
        return false;
    }

    public synchronized Sirius.server.newuser.User getCidsUser(User user, String role) {
        return this.getCidsUser(user, role, false);
    }

    public synchronized Sirius.server.newuser.User getCidsUser(User user, String role, boolean allowUserfromOtherDomain) {
        user.equals((Object)user);
        Sirius.server.newuser.User immutableCidsUser = this.userMap.get(user);
        if (immutableCidsUser == null) {
            if (allowUserfromOtherDomain) {
                return this.createCrossDomainedCidsUser(user);
            }
            log.warn("user '" + user.getUser() + "@" + user.getDomain() + "' not found");
            return null;
        }
        Sirius.server.newuser.User cidsUser = new Sirius.server.newuser.User(immutableCidsUser.getId(), immutableCidsUser.getName(), immutableCidsUser.getDomain(), immutableCidsUser.isAdmin(), user.getJwt());
        if (immutableCidsUser.isValid()) {
            cidsUser.setValid();
        } else {
            log.warn("user '" + cidsUser.getName() + "@" + cidsUser.getDomain() + "' is not valid!?");
        }
        cidsUser.setPotentialUserGroups(immutableCidsUser.getPotentialUserGroups());
        if (role == null || role.equalsIgnoreCase("all")) {
            cidsUser.setUserGroup(null);
        } else {
            for (UserGroup cidsUserGroup : cidsUser.getPotentialUserGroups()) {
                if (!role.equals(cidsUserGroup.getName())) continue;
                cidsUser.setUserGroup(cidsUserGroup);
                break;
            }
            if (cidsUser.getUserGroup() == null) {
                log.warn("role '" + role + "' of user '" + cidsUser.getName() + "@" + cidsUser.getDomain() + "' found in " + cidsUser.getPotentialUserGroups().size() + " potential usergroups, usergroups set to null -> user is acting with all " + cidsUser.getPotentialUserGroups().size() + " potential usergroups!");
                cidsUser.setUserGroup(null);
            }
        }
        return cidsUser;
    }

    public Sirius.server.newuser.User createCrossDomainedCidsUser(User user) {
        Sirius.server.newuser.User newCidsUser = new Sirius.server.newuser.User(9999, user.getUser(), user.getDomain(), user.getJwt());
        ArrayList<UserGroup> groups = new ArrayList<UserGroup>();
        for (String grString : user.getUserGroups()) {
            UserGroup gr = new UserGroup(-1, grString, user.getDomain());
            groups.add(gr);
        }
        newCidsUser.setPotentialUserGroups(groups);
        return newCidsUser;
    }

    public ClassNameCache getClassNameCache() {
        return this.classNameCache;
    }

    public boolean ensureDomainCached(String domain, User cidsUser) {
        if (!this.classNameCache.isDomainCached(domain)) {
            MetaClass[] metaClasses;
            if (log.isDebugEnabled()) {
                log.debug("need to fill the class name cache for domain '" + cidsUser.getDomain() + "' to loockup class with legacy ids.");
            }
            Sirius.server.newuser.User legacyUser = this.getCidsUser(cidsUser, null);
            try {
                metaClasses = LegacyCoreBackend.getInstance().getService().getClasses(legacyUser, cidsUser.getDomain(), LegacyCoreBackend.getInstance().getConnectionContext());
            }
            catch (RemoteException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw new RuntimeException(ex.getMessage(), ex);
            }
            if (metaClasses != null) {
                this.classNameCache.fillCache(cidsUser.getDomain(), metaClasses);
                StatusHolder.getInstance().putStatus("cachedClasses", String.valueOf(metaClasses.length));
            } else {
                String message = "cannot lookup class name for class with id '' and fill class name cache: no classes found at domain '" + domain + "' for user '" + cidsUser.getUser() + "'";
                log.error(message);
                throw new RuntimeException(message);
            }
        }
        return this.classNameCache.isDomainCached(domain);
    }

    public int getIdForClassName(User cidsUser, String className) throws Exception {
        if (!this.classNameCache.isDomainCached(cidsUser.getDomain())) {
            if (log.isDebugEnabled()) {
                log.debug("need to fill the class name cache for domain '" + cidsUser.getDomain() + "' to lookup class with legacy name '" + className + "'");
            }
            Sirius.server.newuser.User legacyUser = this.getCidsUser(cidsUser, null);
            MetaClass[] metaClasses = LegacyCoreBackend.getInstance().getService().getClasses(legacyUser, cidsUser.getDomain(), this.getConnectionContext());
            if (metaClasses != null) {
                this.classNameCache.fillCache(cidsUser.getDomain(), metaClasses);
            } else {
                String message = "cannot lookup class id for class with name '' and fill class name cache: no classes found at domain '" + cidsUser.getDomain() + "' for user '" + cidsUser.getUser() + "'";
                log.error(message);
                throw new Exception(message);
            }
        }
        return this.classNameCache.getClassIdForClassName(cidsUser.getDomain(), className);
    }

    public byte[] getNodeIcon(String baseIconString, CidsNode.IconType iconType) {
        block9: {
            if (baseIconString != null && !baseIconString.isEmpty() && baseIconString.lastIndexOf(".") != -1) {
                String iconString = iconType != null ? baseIconString.substring(0, baseIconString.lastIndexOf(".")) + iconType.getKey() + baseIconString.substring(baseIconString.lastIndexOf(".")) : baseIconString;
                if (log.isDebugEnabled()) {
                    log.debug("searching for icon '" + iconString + "'");
                }
                if (this.nodeIconCache.containsKey(iconString)) {
                    return this.nodeIconCache.get(iconString);
                }
                URL iconUrl = this.getClass().getResource(iconString);
                if (iconUrl != null) {
                    try {
                        BufferedImage iconImage = ImageIO.read(iconUrl);
                        if (iconImage != null) {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)iconImage, "png", bos);
                            bos.flush();
                            bos.close();
                            byte[] icon = bos.toByteArray();
                            this.nodeIconCache.put(iconString, icon);
                            return icon;
                        }
                        break block9;
                    }
                    catch (IOException ex) {
                        String message = "Could not load icon '" + iconString + "': " + ex.getMessage();
                        log.error(message, (Throwable)ex);
                        throw new CidsServerException(message, (Throwable)ex);
                    }
                }
                if (iconType != null) {
                    byte[] icon = this.getNodeIcon(baseIconString, null);
                    this.nodeIconCache.put(iconString, icon);
                    return icon;
                }
                this.nodeIconCache.put(iconString, null);
            } else {
                log.warn("invalid base icon string: '" + baseIconString + "'");
            }
        }
        return null;
    }

    public void applyCidsBeanUpdateStatus(CidsBean cidsBean, boolean setChanged) {
        if (cidsBean.getPrimaryKeyValue() == -1) {
            if (log.isDebugEnabled()) {
                log.debug("applying update status to NEW CidsBean '" + cidsBean.getCidsBeanInfo().getJsonObjectKey() + "' (setChanged: " + setChanged + ")");
            }
        } else if (cidsBean.getPrimaryKeyValue() == -1 && log.isDebugEnabled()) {
            log.debug("applying update status to UPDATED CidsBean '" + cidsBean.getCidsBeanInfo().getJsonObjectKey() + "' (setChanged: " + setChanged + ")");
        }
        this.applyMetaObjectUpdateStatus(cidsBean.getMetaObject(), setChanged);
    }

    private void applyMetaObjectUpdateStatus(MetaObject metaObject, boolean setChanged) {
        if (metaObject.getID() == -1) {
            metaObject.setStatus(1);
        } else if (setChanged) {
            metaObject.setStatus(2);
        }
        for (ObjectAttribute objectAttribute : metaObject.getAttribs()) {
            if (!objectAttribute.referencesObject() || objectAttribute.getValue() == null) continue;
            MetaObject attributeMetaObject = (MetaObject)objectAttribute.getValue();
            attributeMetaObject.setChanged(true);
            this.applyMetaObjectUpdateStatus(attributeMetaObject, setChanged);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public HashMap<String, JsonNode> getClassCache() {
        return this.classCache;
    }

    public HashMap<String, byte[]> getClassIconCache() {
        return this.classIconCache;
    }

    public HashMap<String, byte[]> getObjectIconCache() {
        return this.objectIconCache;
    }

    public HashMap<String, byte[]> getNodeIconCache() {
        return this.nodeIconCache;
    }
}

