/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cidsx.server.api.types.ActionResultInfo;
import de.cismet.cidsx.server.api.types.ActionTask;
import de.cismet.cidsx.server.api.types.GenericResourceWithContentType;
import de.cismet.cidsx.server.api.types.User;
import de.cismet.cidsx.server.backend.legacy.LegacyCoreBackend;
import de.cismet.cidsx.server.cores.ActionCore;
import de.cismet.cidsx.server.exceptions.CidsServerException;
import de.cismet.commons.concurrency.CismetExecutors;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyActionCore
implements ActionCore {
    private static final Logger log = LoggerFactory.getLogger(LegacyActionCore.class);
    private static final ObjectMapper MAPPER = new ObjectMapper(new JsonFactory());
    private static final String STREAMTYPE_APPOCTETSTREAM = "application/octet-stream";
    private static final ConcurrentHashMap<String, ExecutorService> actionExecutorServices = new ConcurrentHashMap();
    private final Map<String, ActionTask> taskMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, GenericResourceWithContentType> resultMap = Collections.synchronizedMap(new HashMap());

    public List<JsonNode> getAllActions(User user, String role) {
        if (log.isDebugEnabled()) {
            log.debug("getAllActions");
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            cidsUser.setUserGroup(null);
            ArrayList<JsonNode> taskNameNodes = new ArrayList<JsonNode>();
            HashMap<String, ServerAction> serverActionMap = LegacyCoreBackend.getInstance().getServerActionMap();
            for (String actionKey : serverActionMap.keySet()) {
                if (LegacyCoreBackend.getInstance().getService().hasConfigAttr(cidsUser, "csa://" + actionKey, LegacyCoreBackend.getInstance().getConnectionContext())) {
                    ServerAction cidsServerAction = serverActionMap.get(actionKey);
                    ActionTask actionTask = new ActionTask(cidsServerAction.getTaskName(), cidsServerAction.getTaskName(), "legacy ServerAction", null, null);
                    taskNameNodes.add((JsonNode)MAPPER.convertValue((Object)actionTask, JsonNode.class));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("user '" + user.getUser() + "' with role '" + role + "' does not have the permission to get the Action with actionKey '" + actionKey + "': Config Attribute '" + "csa://" + actionKey + "' not available for user. ");
            }
            return taskNameNodes;
        }
        catch (Exception ex) {
            String message = "error while getting all actions: " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public JsonNode getAction(User user, String actionKey, String role) {
        if (log.isDebugEnabled()) {
            log.debug("getAction with actionKey '" + actionKey + "'");
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            HashMap<String, ServerAction> serverActionMap = LegacyCoreBackend.getInstance().getServerActionMap();
            if (LegacyCoreBackend.getInstance().getService().hasConfigAttr(cidsUser, "csa://" + actionKey, LegacyCoreBackend.getInstance().getConnectionContext())) {
                ServerAction cidsServerAction = serverActionMap.get(actionKey);
                ActionTask actionTask = new ActionTask(cidsServerAction.getTaskName(), cidsServerAction.getTaskName(), "legacy ServerAction", null, null);
                return (JsonNode)MAPPER.convertValue((Object)actionTask, JsonNode.class);
            }
            log.warn("user '" + user.getUser() + "' with role '" + role + "' does not have the permission to get the Action with actionKey '" + actionKey + "': Config Attribute '" + "csa://" + actionKey + "' not found! ");
            return null;
        }
        catch (Exception ex) {
            String message = "error while getting action with actionKey '" + actionKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public List<JsonNode> getAllTasks(User user, String actionKey, String role) {
        if (log.isDebugEnabled()) {
            log.debug("getAllTasks with actionKey '" + actionKey + "'");
        }
        ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
        for (ActionTask actionTask : this.taskMap.values()) {
            if (actionTask == null || !actionTask.getActionKey().equals(actionKey)) continue;
            JsonNode on = (JsonNode)MAPPER.convertValue((Object)actionTask, JsonNode.class);
            nodes.add(on);
        }
        return nodes;
    }

    public GenericResourceWithContentType executeNewAction(User user, String actionKey, ActionTask actionTask, String role, String domain, InputStream fileAttachement) {
        if (log.isDebugEnabled()) {
            log.info("executeNewAction with actionKey '" + actionKey + "'");
        }
        ArrayList<ServerActionParameter> cidsSAPs = new ArrayList<ServerActionParameter>();
        Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role, true);
        if (actionTask != null && actionTask.getParameters() != null && !actionTask.getParameters().isEmpty()) {
            Map actionParameters = actionTask.getParameters();
            for (String parameterKey : actionParameters.keySet()) {
                Object parameterValue = actionParameters.get(parameterKey);
                ServerActionParameter cidsSAP = new ServerActionParameter(parameterKey, parameterValue);
                cidsSAPs.add(cidsSAP);
                if (!log.isDebugEnabled()) continue;
                log.debug("processing server action parameter '" + cidsSAP.toString() + "'");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("no server action parameters provided!");
        }
        try {
            Object taskResult;
            byte[] body;
            byte[] byArray = body = fileAttachement != null ? IOUtils.toByteArray((InputStream)fileAttachement) : null;
            if (body != null) {
                if (log.isDebugEnabled()) {
                    log.debug("sending binary body (e.g. file) of length " + body.length);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("no binary body (e.g. file) parameter provided!");
            }
            if (domain != null) {
                taskResult = LegacyCoreBackend.getInstance().getService().executeTask(cidsUser, actionKey, domain, (Object)body, LegacyCoreBackend.getInstance().getConnectionContext(), cidsSAPs.toArray(new ServerActionParameter[0]));
                return new GenericResourceWithContentType(STREAMTYPE_APPOCTETSTREAM, taskResult);
            }
            taskResult = LegacyCoreBackend.getInstance().getService().executeTask(cidsUser, actionKey, cidsUser.getDomain(), (Object)body, LegacyCoreBackend.getInstance().getConnectionContext(), cidsSAPs.toArray(new ServerActionParameter[0]));
            return new GenericResourceWithContentType(STREAMTYPE_APPOCTETSTREAM, taskResult);
        }
        catch (Exception ex) {
            String message = "error while executing action task with actionKey '" + actionKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public JsonNode createNewActionTask(final User user, final String actionKey, ActionTask actionTask, final String role, boolean requestResultingInstance, final InputStream fileAttachement) {
        if (log.isDebugEnabled()) {
            log.debug("createNewActionTask with actionKey '" + actionKey + "'");
        }
        if (actionTask == null) {
            actionTask = new ActionTask();
        }
        try {
            actionTask.setStatus(ActionTask.Status.STARTING);
            actionTask.setActionKey(actionKey);
            ExecutorService es = actionExecutorServices.get(actionKey);
            if (es == null) {
                actionExecutorServices.putIfAbsent(actionKey, CismetExecutors.newFixedThreadPool((int)5));
                es = actionExecutorServices.get(actionKey);
            }
            ArrayList<ServerActionParameter> cidsSAPs = new ArrayList<ServerActionParameter>();
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            Map actionParameters = actionTask.getParameters();
            if (actionParameters != null) {
                for (String parameterKey : actionParameters.keySet()) {
                    Object parameterValue = actionParameters.get(parameterKey);
                    ServerActionParameter cidsSAP = new ServerActionParameter(parameterKey, parameterValue);
                    cidsSAPs.add(cidsSAP);
                }
            }
            final ActionTask finalTask = actionTask;
            Runnable actionRunner = new Runnable(){

                @Override
                public void run() {
                    try {
                        finalTask.setStatus(ActionTask.Status.RUNNING);
                        GenericResourceWithContentType grwct = LegacyActionCore.this.executeNewAction(user, actionKey, finalTask, role, user.getDomain(), fileAttachement);
                        LegacyActionCore.this.resultMap.put(finalTask.getKey(), grwct);
                        finalTask.setStatus(ActionTask.Status.FINISHED);
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                        finalTask.setStatus(ActionTask.Status.ERROR);
                    }
                    finally {
                        LegacyActionCore.this.taskMap.remove(finalTask.getKey());
                    }
                }
            };
            if (actionTask.getKey() == null) {
                actionTask.setKey(actionKey + ":" + String.valueOf(System.currentTimeMillis()));
            }
            es.execute(actionRunner);
            this.taskMap.put(actionTask.getKey(), finalTask);
        }
        catch (Exception ex) {
            String message = "error while creating new action task with actionKey '" + actionKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
        try {
            return (JsonNode)MAPPER.convertValue((Object)actionTask, JsonNode.class);
        }
        catch (Exception ex) {
            String message = "error while creating new action task with actionKey '" + actionKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public JsonNode getTask(User user, String actionKey, String taskKey, String role) {
        ActionTask actionTask;
        if (log.isDebugEnabled()) {
            log.debug("getTask with actionKey '" + actionKey + "' and taskKey '" + taskKey + "'");
        }
        if ((actionTask = this.taskMap.get(taskKey)) != null) {
            JsonNode on = (JsonNode)MAPPER.convertValue((Object)actionTask, JsonNode.class);
            return on;
        }
        log.warn("no taks for actionKey '" + actionKey + "' and taskKey '" + taskKey + "' found, returning null!");
        return null;
    }

    public List<ActionResultInfo> getResults(User user, String actionKey, String taskKey, String role) {
        if (log.isDebugEnabled()) {
            log.debug("getResults with actionKey '" + actionKey + "' and taskKey '" + taskKey + "'");
        }
        GenericResourceWithContentType result = this.resultMap.get(taskKey);
        ActionTask actionTask = this.taskMap.get(taskKey);
        LinkedList<ActionResultInfo> ariList = new LinkedList<ActionResultInfo>();
        if (result != null) {
            ActionResultInfo ari = new ActionResultInfo(actionTask.getKey(), actionTask.getActionKey(), actionTask.getDescription(), STREAMTYPE_APPOCTETSTREAM, actionTask.getParameters());
            ariList.add(ari);
        } else {
            log.warn("no results for actionKey '" + actionKey + "' and taskKey '" + taskKey + "' found, returning null!");
        }
        return ariList;
    }

    public void deleteTask(User user, String actionKey, String taskKey, String role) {
        if (log.isDebugEnabled()) {
            log.debug("deleteTask with actionKey '" + actionKey + "' and taskKey '" + taskKey + "'");
        }
        if (this.taskMap.containsKey(taskKey)) {
            this.taskMap.remove(taskKey);
            this.resultMap.remove(taskKey);
        } else {
            log.warn("could not delete task with '" + actionKey + "' and taskKey '" + taskKey + "': task not found");
        }
    }

    public GenericResourceWithContentType getResult(User user, String actionKey, String taskKey, String resultKey, String role) {
        if (log.isDebugEnabled()) {
            log.debug("getResult with actionKey '" + actionKey + "', taskKey '" + taskKey + "' and resultKey '" + resultKey + "'");
        }
        if (!this.resultMap.containsKey(taskKey)) {
            log.warn("could not get result for task with '" + actionKey + ", taskKey '" + taskKey + "' and resultKey '" + resultKey + "': task not found");
            return null;
        }
        GenericResourceWithContentType result = this.resultMap.get(taskKey);
        return result;
    }

    public String getCoreKey() {
        return "core.legacy.action";
    }
}

