/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy;

import Sirius.server.newuser.UserGroup;
import de.cismet.cidsx.server.api.types.User;
import de.cismet.cidsx.server.backend.legacy.LegacyCoreBackend;
import de.cismet.cidsx.server.cores.ConfigAttributesCore;
import de.cismet.cidsx.server.exceptions.CidsServerException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyConfigAttributesCore
implements ConfigAttributesCore {
    private static final Logger log = LoggerFactory.getLogger(LegacyConfigAttributesCore.class);

    public String getConfigattribute(User user, String configattribute) {
        try {
            Sirius.server.newuser.User legacyUser = LegacyCoreBackend.getInstance().getCidsUser(user, null);
            if (legacyUser == null) {
                legacyUser = new Sirius.server.newuser.User(3000, user.getUser(), user.getDomain(), user.getJwt());
                ArrayList<UserGroup> groups = new ArrayList<UserGroup>();
                for (String grString : user.getUserGroups()) {
                    UserGroup gr = new UserGroup(-1, grString, user.getDomain());
                    groups.add(gr);
                }
                legacyUser.setPotentialUserGroups(groups);
            }
            String configAttr = LegacyCoreBackend.getInstance().getService().getConfigAttr(legacyUser, configattribute, LegacyCoreBackend.getInstance().getConnectionContext());
            return configAttr;
        }
        catch (Exception ex) {
            String message = "error while getting configuration attributes for user '" + user.getUser() + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public String getCoreKey() {
        return "core.legacy.configAttr";
    }
}

