/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy;

import Sirius.server.middleware.types.LightweightMetaObject;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.fge.jsonpatch.JsonPatchException;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.jsonpatch.CidsBeanPatch;
import de.cismet.cids.jsonpatch.CidsBeanPatchUtils;
import de.cismet.cidsx.server.api.types.SimpleObjectQuery;
import de.cismet.cidsx.server.api.types.User;
import de.cismet.cidsx.server.backend.legacy.LegacyCoreBackend;
import de.cismet.cidsx.server.cores.EntityCore;
import de.cismet.cidsx.server.data.RuntimeContainer;
import de.cismet.cidsx.server.exceptions.CidsServerException;
import de.cismet.cidsx.server.exceptions.EntityInfoNotFoundException;
import de.cismet.cidsx.server.exceptions.EntityNotFoundException;
import de.cismet.cidsx.server.exceptions.InvalidClassKeyException;
import de.cismet.cidsx.server.exceptions.InvalidEntityException;
import de.cismet.cidsx.server.exceptions.InvalidParameterException;
import de.cismet.cidsx.server.exceptions.InvalidRoleException;
import de.cismet.cidsx.server.exceptions.InvalidUserException;
import de.cismet.cidsx.server.exceptions.PatchFailedException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyEntityCore
implements EntityCore {
    private static final Logger log = LoggerFactory.getLogger(LegacyEntityCore.class);
    protected static final ObjectMapper MAPPER = new ObjectMapper(new JsonFactory());
    protected static final Pattern CLASSKEY_PATTERN = Pattern.compile("^/([^/]*)/");
    protected static final Pattern OBJECTID_PATTERN = Pattern.compile("([^/?]+)(?=/?(?:$|\\?))");
    protected static final ObjectReader PATCH_READER = CidsBeanPatchUtils.getInstance().getCidsBeanPatchReader();

    public List<JsonNode> getAllObjects(@NonNull User user, @NonNull String classKey, @NonNull String role, int limit, int offset, String expand, String level, String fields, String profile, String filter, boolean omitNullValues, boolean deduplicate) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (classKey == null) {
            throw new NullPointerException("classKey");
        }
        if (role == null) {
            throw new NullPointerException("role");
        }
        if (log.isDebugEnabled()) {
            log.debug("getAllObjects with classKey '" + classKey + "'.");
        }
        if (!user.isValidated()) {
            String message = "error while getting all objects with classKey '" + classKey + "': user '" + user.getUser() + "' is not validated!";
            log.error(message);
            throw new InvalidUserException(message);
        }
        if (classKey.isEmpty()) {
            String message = "error while getting all objects with classKey '" + classKey + "': classKey is empty!";
            log.error(message);
            throw new InvalidClassKeyException(message);
        }
        if (role.isEmpty()) {
            String message = "error while getting all objects with classKey '" + classKey + "': role is empty!";
            log.error(message);
            throw new InvalidRoleException(message);
        }
        try {
            ArrayList<JsonNode> all = new ArrayList<JsonNode>();
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            String domain = RuntimeContainer.getServer().getDomainName();
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, cidsUser);
            if (metaClass == null) {
                String message = "classKey " + classKey + " not found";
                log.warn(message);
                throw new EntityInfoNotFoundException(message, classKey);
            }
            String query = "SELECT " + metaClass.getID() + ", " + metaClass.getTableName() + "." + metaClass.getPrimaryKey() + " FROM " + metaClass.getTableName() + " ORDER BY " + metaClass.getTableName() + "." + metaClass.getPrimaryKey() + " ASC LIMIT " + limit + " OFFSET " + offset;
            if ("0".equals(level)) {
                LightweightMetaObject[] lwmos;
                if (log.isDebugEnabled()) {
                    log.debug("getAllObjects: level is 0, requesting creating LightweightMetaObjects without any attributes");
                }
                if (fields != null || expand != null) {
                    log.warn("getAllObjects: level is 0, ignoring fields '" + fields + "' and expand '" + expand + "' parameters!");
                }
                for (LightweightMetaObject lwmo : lwmos = LegacyCoreBackend.getInstance().getService().getLightweightMetaObjectsByQuery(metaClass.getId(), cidsUser, query, new String[0], LegacyCoreBackend.getInstance().getConnectionContext())) {
                    String selfString = "{\"$self\":\"/" + metaClass.getDomain() + "." + metaClass.getTableName() + "/" + lwmo.getId() + "\"}";
                    JsonNode node = MAPPER.reader().readTree(selfString);
                    all.add(node);
                }
            } else {
                MetaObject[] metaObjects = LegacyCoreBackend.getInstance().getService().getMetaObject(cidsUser, query, domain, LegacyCoreBackend.getInstance().getConnectionContext());
                if (metaObjects != null) {
                    for (MetaObject metaObject : metaObjects) {
                        metaObject.setAllClasses();
                        int intLevel = -1;
                        try {
                            intLevel = Integer.parseInt(level);
                        }
                        catch (Exception node) {
                            // empty catch block
                        }
                        List<String> fieldsList = fields != null ? Arrays.asList(fields.split(",")) : null;
                        List<String> expandList = expand != null ? Arrays.asList(expand.split(",")) : null;
                        JsonNode node = MAPPER.reader().readTree(metaObject.getBean().toJSONString(deduplicate, omitNullValues, intLevel, fieldsList, expandList));
                        all.add(node);
                    }
                }
            }
            return all;
        }
        catch (Exception ex) {
            String message = "error while getting all objects with classKey '" + classKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public static CidsBean deepcopyAllProperties(CidsBean sourceBean, CidsBean targetBean) throws Exception {
        return LegacyEntityCore.deepcopyAllProperties(sourceBean, targetBean, true);
    }

    public static CidsBean deepcopyAllProperties(CidsBean sourceBean, CidsBean targetBean, boolean cloneDeep) throws Exception {
        if (sourceBean == null || targetBean == null) {
            return null;
        }
        String primaryKeyFieldName = sourceBean.getPrimaryKeyFieldname().toLowerCase();
        for (String propName : sourceBean.getPropertyNames()) {
            Object o = sourceBean.getProperty(propName);
            if (!sourceBean.getMetaObject().getAttributeByFieldName(propName).isChanged()) continue;
            if (propName.toLowerCase().equals(primaryKeyFieldName)) {
                int id = (Integer)sourceBean.getProperty(primaryKeyFieldName);
                targetBean.setProperty(primaryKeyFieldName, (Object)id);
                targetBean.getMetaObject().setID(id);
                continue;
            }
            if (o instanceof CidsBean) {
                CidsBean sourceChild = (CidsBean)o;
                CidsBean targetChild = cloneDeep ? LegacyEntityCore.deepcloneCidsBean(sourceChild) : (targetBean.getProperty(propName) == null ? LegacyEntityCore.deepcopyAllProperties(sourceChild, sourceChild.getMetaObject().getMetaClass().getEmptyInstance().getBean(), cloneDeep) : LegacyEntityCore.deepcopyAllProperties(sourceChild, (CidsBean)targetBean.getProperty(propName), cloneDeep));
                targetBean.setProperty(propName, (Object)targetChild);
                continue;
            }
            if (o instanceof Collection) {
                List list = (List)o;
                ArrayList<CidsBean> newList = new ArrayList<CidsBean>();
                for (CidsBean tmpBean : list) {
                    newList.add(LegacyEntityCore.deepcloneCidsBean(tmpBean));
                }
                targetBean.setProperty(propName, newList);
                continue;
            }
            if (o instanceof Geometry) {
                targetBean.setProperty(propName, ((Geometry)o).clone());
                continue;
            }
            if (o instanceof Float) {
                targetBean.setProperty(propName, (Object)new Float(o.toString()));
                continue;
            }
            if (o instanceof Boolean) {
                targetBean.setProperty(propName, (Object)new Boolean(o.toString()));
                continue;
            }
            if (o instanceof Long) {
                targetBean.setProperty(propName, (Object)new Long(o.toString()));
                continue;
            }
            if (o instanceof Double) {
                targetBean.setProperty(propName, (Object)new Double(o.toString()));
                continue;
            }
            if (o instanceof Integer) {
                targetBean.setProperty(propName, (Object)new Integer(o.toString()));
                continue;
            }
            if (o instanceof Date) {
                targetBean.setProperty(propName, ((Date)o).clone());
                continue;
            }
            if (o instanceof String) {
                targetBean.setProperty(propName, o);
                continue;
            }
            if (o != null) {
                log.error("unknown property type: " + o.getClass().getName());
            }
            targetBean.setProperty(propName, o);
        }
        return targetBean;
    }

    public static CidsBean deepcloneCidsBean(CidsBean cidsBean) throws Exception {
        if (cidsBean == null) {
            return null;
        }
        CidsBean cloneBean = cidsBean.getMetaObject().getMetaClass().getEmptyInstance().getBean();
        return LegacyEntityCore.deepcopyAllProperties(cidsBean, cloneBean);
    }

    public JsonNode updateObject(User user, String classKey, String objectId, JsonNode jsonObject, String role, boolean requestResultingInstance) {
        long current = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.info("updateObject with classKey '" + classKey + "' and objectId '" + objectId + "'.");
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, cidsUser);
            if (metaClass == null) {
                String message = "classKey " + classKey + " no found";
                log.warn(message);
                throw new EntityInfoNotFoundException(message, classKey);
            }
            CidsBean beanToUpdate = CidsBean.createNewCidsBeanFromJSON((boolean)true, (String)jsonObject.toString());
            LegacyCoreBackend.getInstance().applyCidsBeanUpdateStatus(beanToUpdate, true);
            CidsBean updatedBean = beanToUpdate.persist();
            if (requestResultingInstance) {
                JsonNode node = MAPPER.reader().readTree(updatedBean.toJSONString(true));
                if (log.isDebugEnabled()) {
                    log.debug("updateObject with classKey '" + classKey + "' and objectId '" + objectId + "' completed in " + (System.currentTimeMillis() - current) + "ms.");
                }
                return node;
            }
            if (log.isDebugEnabled()) {
                log.debug("updateObject with classKey '" + classKey + "' and objectId '" + objectId + "' completed in " + (System.currentTimeMillis() - current) + "ms.");
            }
            return null;
        }
        catch (Exception ex) {
            String message = "error while updating entity with classKey '" + classKey + "' and objectId '" + objectId + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new InvalidEntityException(message, (Throwable)ex, jsonObject);
        }
    }

    public JsonNode patchObject(User user, String classKey, String objectId, JsonNode jsonObject, String role, boolean requestResultingInstance) {
        String message;
        CidsBean cidsBean;
        CidsBeanPatch patch;
        long current = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("patchObject with classKey '" + classKey + "' and objectId '" + objectId + "'.");
        }
        if (!user.isValidated()) {
            String message2 = "error while patching an object with classKey '" + classKey + "' and objectId '" + objectId + "': user '" + user.getUser() + "' is not validated!";
            log.error(message2);
            throw new InvalidUserException(message2);
        }
        if (classKey.isEmpty()) {
            String message3 = "error while patching an object with classKey '" + classKey + "' and objectId '" + objectId + "': class key is empty!";
            log.error(message3);
            throw new InvalidClassKeyException(message3);
        }
        if (objectId.isEmpty()) {
            String message4 = "error while patching an object with classKey '" + classKey + "' and objectId '" + objectId + "': objectId is empty!";
            log.error(message4);
            throw new InvalidParameterException(message4, "objectId", (Object)"null");
        }
        if (role.isEmpty()) {
            String message5 = "error while patching an object with classKey '" + classKey + "' and objectId '" + objectId + "': role is empty!";
            log.error(message5);
            throw new InvalidRoleException(message5);
        }
        try {
            patch = (CidsBeanPatch)PATCH_READER.readValue(jsonObject);
        }
        catch (Exception ex) {
            String message6 = "invalid json patch format: " + ex.getMessage();
            log.error(message6, (Throwable)ex);
            throw new InvalidParameterException(message6, (Throwable)ex, "patch", (Object)jsonObject);
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            String domain = RuntimeContainer.getServer().getDomainName();
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, cidsUser);
            if (metaClass == null) {
                String message7 = "error while patching an object with classKey '" + classKey + "' and objectId '" + objectId + "': class for class key not found!";
                log.warn(message7);
                throw new EntityInfoNotFoundException(message7, classKey);
            }
            MetaObject metaObject = LegacyCoreBackend.getInstance().getService().getMetaObject(cidsUser, Integer.parseInt(objectId), metaClass.getId(), domain, LegacyCoreBackend.getInstance().getConnectionContext());
            if (metaObject == null) {
                String message8 = "error while patching an entity with classKey '" + classKey + "' and objectId '" + objectId + "': entity to be patched not found";
                log.warn(message8);
                throw new EntityNotFoundException(message8, objectId);
            }
            cidsBean = metaObject.getBean();
        }
        catch (EntityInfoNotFoundException ei) {
            throw ei;
        }
        catch (Exception ex) {
            String message9 = "error while loading an entity to be patched with classKey '" + classKey + "' and objectId '" + objectId + "': " + ex.getMessage();
            log.error(message9, (Throwable)ex);
            throw new InvalidEntityException(message9, (Throwable)ex, jsonObject);
        }
        try {
            cidsBean = patch.apply(cidsBean);
            if (log.isDebugEnabled()) {
                log.debug(cidsBean.getMOString());
            }
        }
        catch (JsonPatchException jpe) {
            message = "error while patching an entity with classKey '" + classKey + "' and objectId '" + objectId + "': patch failed with '" + jpe.getMessage() + "'";
            throw new PatchFailedException(message, (Throwable)jpe);
        }
        catch (Throwable t) {
            message = "unhandled error while patching an entity with classKey '" + classKey + "' and objectId '" + objectId + "': patch failed with unexpected error '" + t.getMessage() + "'";
            throw new PatchFailedException(message, t);
        }
        try {
            CidsBean updatedBean = cidsBean.persist();
            if (log.isDebugEnabled()) {
                log.debug("patchObject with classKey '" + classKey + "' and objectId '" + objectId + "' completed in " + (System.currentTimeMillis() - current) + "ms.");
            }
            if (requestResultingInstance) {
                JsonNode node = MAPPER.reader().readTree(updatedBean.toJSONString(true));
                return node;
            }
            return null;
        }
        catch (Exception ex) {
            JsonNode cidsBeanNode;
            try {
                cidsBeanNode = MAPPER.readTree(cidsBean.toJSONString(true));
            }
            catch (IOException ioex) {
                log.error(ioex.getMessage(), (Throwable)ioex);
                cidsBeanNode = JsonNodeFactory.instance.textNode(ioex.getMessage());
            }
            String message10 = "error while storing a patched entity with classKey '" + classKey + "' and objectId '" + objectId + "': " + ex.getMessage();
            log.error(message10, (Throwable)ex);
            throw new InvalidEntityException(message10, (Throwable)ex, cidsBeanNode);
        }
    }

    public JsonNode createObject(@NonNull User user, @NonNull String classKey, @NonNull JsonNode jsonObject, @NonNull String role, boolean requestResultingInstance) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (classKey == null) {
            throw new NullPointerException("classKey");
        }
        if (jsonObject == null) {
            throw new NullPointerException("jsonObject");
        }
        if (role == null) {
            throw new NullPointerException("role");
        }
        long current = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.info("createObject with classKey '" + classKey + "'.");
        }
        if (!user.isValidated()) {
            String message = "error while creating an object with classKey '" + classKey + "': user '" + user.getUser() + "' is not validated!";
            log.error(message);
            throw new InvalidUserException(message);
        }
        if (classKey.isEmpty()) {
            String message = "error while creating an object: class key is empty!";
            log.error("error while creating an object: class key is empty!");
            throw new InvalidClassKeyException("error while creating an object: class key is empty!");
        }
        if (role.isEmpty()) {
            String message = "error while creating an object with classKey '" + classKey + "': role is empty!";
            log.error(message);
            throw new InvalidRoleException(message);
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, cidsUser);
            if (metaClass == null) {
                String message = "error while deleting an object with classKey '" + classKey + "': class for classKey not found!";
                log.warn(message);
                throw new EntityInfoNotFoundException(message, classKey);
            }
            CidsBean beanNew = CidsBean.createNewCidsBeanFromJSON((boolean)false, (String)jsonObject.toString());
            LegacyCoreBackend.getInstance().applyCidsBeanUpdateStatus(beanNew, false);
            CidsBean updatedBean = beanNew.persist();
            if (requestResultingInstance) {
                JsonNode node = MAPPER.reader().readTree(updatedBean.toJSONString(true));
                if (log.isDebugEnabled()) {
                    log.debug("createObject with classKey '" + classKey + "' completed in " + (System.currentTimeMillis() - current) + "ms.");
                }
                return node;
            }
            if (log.isDebugEnabled()) {
                log.debug("createObject with classKey '" + classKey + "' completed in " + (System.currentTimeMillis() - current) + "ms.");
            }
            return null;
        }
        catch (EntityInfoNotFoundException ifx) {
            throw ifx;
        }
        catch (Exception ex) {
            String message = "error while creating an object with classKey '" + classKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new InvalidEntityException(message, (Throwable)ex, jsonObject);
        }
    }

    public JsonNode getObjectsByQuery(User user, SimpleObjectQuery query, String role, int limit, int offset) {
        if (log.isDebugEnabled()) {
            log.warn("getObjectsByQuery with query '" + query + "'.");
        }
        String message = "The operation getObjectsByQuery is currently not supported";
        log.error("The operation getObjectsByQuery is currently not supported");
        throw new UnsupportedOperationException("The operation getObjectsByQuery is currently not supported");
    }

    public JsonNode getObject(@NonNull User user, @NonNull String classKey, @NonNull String objectId, String version, String expand, String level, String fields, String profile, @NonNull String role, boolean omitNullValues, boolean deduplicate) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (classKey == null) {
            throw new NullPointerException("classKey");
        }
        if (objectId == null) {
            throw new NullPointerException("objectId");
        }
        if (role == null) {
            throw new NullPointerException("role");
        }
        if (log.isDebugEnabled()) {
            log.debug("getObject with classKey '" + classKey + "' and objectId '" + objectId + "'");
        }
        if (!user.isValidated()) {
            String message = "error while getting an object with classKey '" + classKey + "' and objectId '" + objectId + "': user '" + user.getUser() + "' is not validated!";
            log.error(message);
            throw new InvalidUserException(message);
        }
        if (classKey.isEmpty()) {
            String message = "error while getting an object with classKey '" + classKey + "' and objectId '" + objectId + "': class key is empty!";
            log.error(message);
            throw new InvalidClassKeyException(message);
        }
        if (objectId.isEmpty()) {
            String message = "error while getting an object with classKey '" + classKey + "' and objectId '" + objectId + "': objectId is empty!";
            log.error(message);
            throw new InvalidParameterException(message, "objectId", (Object)"null");
        }
        if (role.isEmpty()) {
            String message = "error while getting an object with classKey '" + classKey + "' and objectId '" + objectId + "': role is empty!";
            log.error(message);
            throw new InvalidRoleException(message);
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            String domain = RuntimeContainer.getServer().getDomainName();
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, cidsUser);
            if (metaClass == null) {
                String message = "error while getting an object with classKey '" + classKey + "' and objectId '" + objectId + "': class for class key not found!";
                log.warn(message);
                throw new EntityInfoNotFoundException(message, classKey);
            }
            int cid = metaClass.getId();
            MetaObject metaObject = LegacyCoreBackend.getInstance().getService().getMetaObject(cidsUser, Integer.parseInt(objectId), cid, domain, LegacyCoreBackend.getInstance().getConnectionContext());
            if (metaObject != null) {
                metaObject.setAllClasses();
                int intLevel = -1;
                try {
                    intLevel = Integer.parseInt(level);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                List<String> fieldsList = fields != null ? Arrays.asList(fields.split(",")) : null;
                List<String> expandList = expand != null ? Arrays.asList(expand.split(",")) : null;
                JsonNode node = MAPPER.reader().readTree(metaObject.getBean().toJSONString(deduplicate, omitNullValues, intLevel, fieldsList, expandList));
                return node;
            }
            return null;
        }
        catch (Exception ex) {
            String message = "error while getting an object with classKey '" + classKey + "' and objectId '" + objectId + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 400, (Throwable)ex);
        }
    }

    public boolean deleteObject(@NonNull User user, @NonNull String classKey, @NonNull String objectId, @NonNull String role) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (classKey == null) {
            throw new NullPointerException("classKey");
        }
        if (objectId == null) {
            throw new NullPointerException("objectId");
        }
        if (role == null) {
            throw new NullPointerException("role");
        }
        if (log.isDebugEnabled()) {
            log.debug("deleteObject with classKey '" + classKey + "' and objectId '" + objectId + "'");
        }
        if (!user.isValidated()) {
            String message = "error while deleting an object with classKey '" + classKey + "' and objectId '" + objectId + "': user '" + user.getUser() + "' is not validated!";
            log.error(message);
            throw new InvalidUserException(message);
        }
        if (classKey.isEmpty()) {
            String message = "error while deleting an object with classKey '" + classKey + "' and objectId '" + objectId + "': classKey is empty!";
            log.error(message);
            throw new InvalidClassKeyException(message);
        }
        if (objectId.isEmpty()) {
            String message = "error while deleting an object with classKey '" + classKey + "' and objectId '" + objectId + "': objectId is empty!";
            log.error(message);
            throw new InvalidParameterException(message, "objectId", (Object)"null");
        }
        if (role.isEmpty()) {
            String message = "error while deleting an object with classKey '" + classKey + "' and objectId '" + objectId + "': role is empty!";
            log.error(message);
            throw new InvalidRoleException(message);
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            String domain = RuntimeContainer.getServer().getDomainName();
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, cidsUser);
            if (metaClass == null) {
                String message = "error while deleting an object with classKey '" + classKey + "' and objectId '" + objectId + "': class for classKey not found!";
                log.warn(message);
                throw new EntityInfoNotFoundException(message, classKey);
            }
            int cid = metaClass.getId();
            MetaObject metaObject = LegacyCoreBackend.getInstance().getService().getMetaObject(cidsUser, Integer.parseInt(objectId), cid, domain, LegacyCoreBackend.getInstance().getConnectionContext());
            int ret = LegacyCoreBackend.getInstance().getService().deleteMetaObject(cidsUser, metaObject, domain, LegacyCoreBackend.getInstance().getConnectionContext());
            return ret > 100;
        }
        catch (Exception ex) {
            String message = "error while deleting an object with classKey '" + classKey + "' and objectId '" + objectId + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            return false;
        }
    }

    public String getClassKey(JsonNode jsonObject) {
        if (jsonObject.hasNonNull("$self")) {
            Matcher matcher = CLASSKEY_PATTERN.matcher(jsonObject.get("$self").asText());
            if (matcher.find()) {
                return matcher.group(1);
            }
            String message = "Object with malformed $self reference: " + jsonObject.get("$self");
            log.error(message);
            throw new Error(message);
        }
        if (jsonObject.hasNonNull("$ref")) {
            Matcher matcher = CLASSKEY_PATTERN.matcher(jsonObject.get("$ref").asText());
            if (matcher.find()) {
                return matcher.group(1);
            }
            String message = "Object with malformed $ref reference: " + jsonObject.get("$ref");
            log.error(message);
            throw new Error(message);
        }
        String message = "Object without ($self or $ref) reference is invalid!";
        log.error("Object without ($self or $ref) reference is invalid!");
        throw new Error("Object without ($self or $ref) reference is invalid!");
    }

    public String getObjectId(JsonNode jsonObject) {
        if (jsonObject.hasNonNull("id")) {
            return jsonObject.get("id").asText();
        }
        if (jsonObject.hasNonNull("$self")) {
            Matcher matcher = OBJECTID_PATTERN.matcher(jsonObject.get("$self").asText());
            if (matcher.find()) {
                return matcher.group(1);
            }
            String message = "Object with malformed $self reference: " + jsonObject.get("$self");
            log.error(message);
            throw new Error(message);
        }
        if (jsonObject.hasNonNull("$ref")) {
            Matcher matcher = OBJECTID_PATTERN.matcher(jsonObject.get("$ref").asText());
            if (matcher.find()) {
                return matcher.group(1);
            }
            String message = "Object with malformed $ref reference: " + jsonObject.get("$ref");
            log.error(message);
            throw new Error(message);
        }
        log.warn("Object without id, $self or $ref! returning -1 as id");
        return "-1";
    }

    public String getCoreKey() {
        return "core.legacy.entity";
    }

    public byte[] getObjectIcon(User user, String classKey, String objectId, String role) {
        if (log.isDebugEnabled()) {
            log.warn("getObjectIcon with classKey '" + classKey + "' and object id '" + objectId + "' returns only the default object icon of the class!");
        }
        if (LegacyCoreBackend.getInstance().getObjectIconCache().containsKey(classKey)) {
            return LegacyCoreBackend.getInstance().getObjectIconCache().get(classKey);
        }
        try {
            Sirius.server.newuser.User legacyUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, legacyUser);
            if (metaClass == null) {
                String message = "error while getting class with classKey '" + classKey + "': class not found!";
                log.warn(message);
                throw new EntityInfoNotFoundException(message, classKey);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] iconData = metaClass.getObjectIconData();
            Image image = new ImageIcon(iconData).getImage();
            BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics2D bGr = bimage.createGraphics();
            bGr.drawImage(image, 0, 0, null);
            bGr.dispose();
            ImageIO.write((RenderedImage)bimage, "png", bos);
            bos.flush();
            bos.close();
            byte[] icon = bos.toByteArray();
            LegacyCoreBackend.getInstance().getObjectIconCache().put(classKey, icon);
            return icon;
        }
        catch (Exception ex) {
            String message = "error while getting object icon for object '" + objectId + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }
}

