/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy;

import Sirius.server.middleware.types.MetaClass;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cidsx.server.api.types.CidsAttribute;
import de.cismet.cidsx.server.api.types.CidsClass;
import de.cismet.cidsx.server.api.types.User;
import de.cismet.cidsx.server.api.types.legacy.CidsClassFactory;
import de.cismet.cidsx.server.backend.legacy.LegacyCoreBackend;
import de.cismet.cidsx.server.cores.EntityInfoCore;
import de.cismet.cidsx.server.exceptions.CidsServerException;
import de.cismet.cidsx.server.exceptions.EntityInfoNotFoundException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyEntityInfoCore
implements EntityInfoCore {
    private static final Logger log = LoggerFactory.getLogger(LegacyEntityInfoCore.class);
    protected static final ObjectMapper MAPPER = new ObjectMapper(new JsonFactory());

    public List<JsonNode> getAllClasses(User user, String role) {
        if (log.isDebugEnabled()) {
            log.debug("getAllClasses");
        }
        try {
            ArrayList<JsonNode> all = new ArrayList<JsonNode>();
            Sirius.server.newuser.User legacyUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            MetaClass[] metaClasses = LegacyCoreBackend.getInstance().getService().getClasses(legacyUser, legacyUser.getDomain(), LegacyCoreBackend.getInstance().getConnectionContext());
            if (metaClasses != null) {
                for (MetaClass metaClass : metaClasses) {
                    CidsClass cidsClass = CidsClassFactory.getFactory().restCidsClassFromLegacyCidsClass(metaClass);
                    JsonNode node = (JsonNode)MAPPER.convertValue((Object)cidsClass, JsonNode.class);
                    all.add(node);
                }
                if (!LegacyCoreBackend.getInstance().getClassNameCache().isDomainCached(role)) {
                    LegacyCoreBackend.getInstance().getClassNameCache().fillCache(role, metaClasses);
                }
            }
            return all;
        }
        catch (Exception ex) {
            String message = "error while getting all classes: " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public JsonNode getClass(User user, String classKey, String role) {
        if (log.isDebugEnabled()) {
            log.debug("getClass with classKey '" + classKey + "'.");
        }
        try {
            if (LegacyCoreBackend.getInstance().getClassCache().containsKey(classKey)) {
                if (log.isDebugEnabled()) {
                    log.debug("loading class with classKey '" + classKey + "' from class cache");
                }
                return LegacyCoreBackend.getInstance().getClassCache().get(classKey);
            }
            Sirius.server.newuser.User legacyUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, legacyUser);
            if (metaClass == null) {
                String message = "error while getting class with classKey '" + classKey + "': class not found!";
                log.warn(message);
                throw new EntityInfoNotFoundException(message, classKey);
            }
            CidsClass cidsClass = CidsClassFactory.getFactory().restCidsClassFromLegacyCidsClass(metaClass);
            JsonNode node = (JsonNode)MAPPER.convertValue((Object)cidsClass, JsonNode.class);
            if (log.isDebugEnabled()) {
                log.debug("adding class with classKey '" + classKey + "' to class cache");
            }
            LegacyCoreBackend.getInstance().getClassCache().put(classKey, node);
            return node;
        }
        catch (Exception ex) {
            String message = "error while getting class with classKey '" + classKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public JsonNode getAttribute(User user, String classKey, String attributeKey, String role) {
        if (log.isDebugEnabled()) {
            log.debug("getAttribute with classKey '" + classKey + "' and attributeKey '" + attributeKey + "'.");
        }
        try {
            Sirius.server.newuser.User legacyUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, legacyUser);
            if (metaClass == null) {
                String message = "error while getting attribute with classKey '" + classKey + "' and attributeKey '" + attributeKey + "': class not found!";
                log.warn(message);
                throw new EntityInfoNotFoundException(message, classKey);
            }
            CidsClass cidsClass = CidsClassFactory.getFactory().restCidsClassFromLegacyCidsClass(metaClass);
            CidsAttribute cidsAttribute = cidsClass.getAttribute(attributeKey);
            JsonNode node = (JsonNode)MAPPER.convertValue((Object)cidsAttribute, JsonNode.class);
            return node;
        }
        catch (Exception ex) {
            String message = "error while getting attribute with classKey '" + classKey + "' and attributeKey '" + attributeKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public JsonNode emptyInstance(User user, String classKey, String role) {
        if (log.isDebugEnabled()) {
            log.debug("emptyInstance with classKey '" + classKey + "'.");
        }
        try {
            Sirius.server.newuser.User legacyUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, legacyUser);
            if (metaClass == null) {
                String message = "error while getting empty instance with classKey '" + classKey + "': class not found!";
                log.error(message);
                throw new CidsServerException(message, message, 302);
            }
            CidsBean beanNew = metaClass.getEmptyInstance().getBean();
            JsonNode node = MAPPER.reader().readTree(beanNew.toJSONString(true));
            return node;
        }
        catch (Exception ex) {
            String message = "error while getting empty instance with classKey '" + classKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public String getCoreKey() {
        return "core.legacy.entityInfo";
    }

    public byte[] getClassIcon(User user, String classKey, String role) {
        if (log.isDebugEnabled()) {
            log.debug("getClassIcon with classKey '" + classKey + "'");
        }
        if (LegacyCoreBackend.getInstance().getClassIconCache().containsKey(classKey)) {
            return LegacyCoreBackend.getInstance().getClassIconCache().get(classKey);
        }
        try {
            Sirius.server.newuser.User legacyUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, legacyUser);
            if (metaClass == null) {
                String message = "error while getting class with classKey '" + classKey + "': class not found!";
                log.warn(message);
                throw new EntityInfoNotFoundException(message, classKey);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] iconData = metaClass.getIconData();
            Image image = new ImageIcon(iconData).getImage();
            BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics2D bGr = bimage.createGraphics();
            bGr.drawImage(image, 0, 0, null);
            bGr.dispose();
            ImageIO.write((RenderedImage)bimage, "png", bos);
            bos.flush();
            bos.close();
            byte[] icon = bos.toByteArray();
            LegacyCoreBackend.getInstance().getClassIconCache().put(classKey, icon);
            return icon;
        }
        catch (Exception ex) {
            String message = "error while getting class icon for class '" + classKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public byte[] getObjectIcon(User user, String classKey, String role) {
        if (log.isDebugEnabled()) {
            log.debug("getObjectIcon with classKey '" + classKey + "'");
        }
        if (LegacyCoreBackend.getInstance().getObjectIconCache().containsKey(classKey)) {
            return LegacyCoreBackend.getInstance().getObjectIconCache().get(classKey);
        }
        try {
            Sirius.server.newuser.User legacyUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, legacyUser);
            if (metaClass == null) {
                String message = "error while getting class with classKey '" + classKey + "': class not found!";
                log.warn(message);
                throw new EntityInfoNotFoundException(message, classKey);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] iconData = metaClass.getObjectIconData();
            Image image = new ImageIcon(iconData).getImage();
            BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics2D bGr = bimage.createGraphics();
            bGr.drawImage(image, 0, 0, null);
            bGr.dispose();
            ImageIO.write((RenderedImage)bimage, "png", bos);
            bos.flush();
            bos.close();
            byte[] icon = bos.toByteArray();
            LegacyCoreBackend.getInstance().getObjectIconCache().put(classKey, icon);
            return icon;
        }
        catch (Exception ex) {
            String message = "error while getting object icon for class '" + classKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }
}

