/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.graphql.GraphqlAction;
import de.cismet.cidsx.server.api.types.User;
import de.cismet.cidsx.server.backend.legacy.LegacyCoreBackend;
import de.cismet.cidsx.server.cores.GraphQlCore;
import de.cismet.cidsx.server.exceptions.CidsServerException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyGraphQlCore
implements GraphQlCore {
    private static final Logger log = LoggerFactory.getLogger(LegacyGraphQlCore.class);

    public String getCoreKey() {
        return "core.legacy.graphQl";
    }

    public Object executeQuery(User user, String role, String request, String contentType) {
        ArrayList<ServerActionParameter> cidsSAPs = new ArrayList<ServerActionParameter>();
        Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role, true);
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        Query query = new Query();
        boolean chunked = false;
        try {
            JsonNode node = mapper.readTree(request);
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry n = (Map.Entry)it.next();
                if (((String)n.getKey()).equalsIgnoreCase("query")) {
                    query.setQuery(((JsonNode)n.getValue()).asText());
                    continue;
                }
                if (((String)n.getKey()).equalsIgnoreCase("OperationName")) {
                    query.setOperationName(((JsonNode)n.getValue()).asText());
                    continue;
                }
                if (((String)n.getKey()).equalsIgnoreCase("variables")) {
                    JsonNode subNode = (JsonNode)n.getValue();
                    Iterator subs = subNode.fields();
                    ArrayList<VariableEntry> variableList = new ArrayList<VariableEntry>();
                    while (subs.hasNext()) {
                        Map.Entry subEntry = (Map.Entry)subs.next();
                        variableList.add(new VariableEntry((String)subEntry.getKey(), ((JsonNode)subEntry.getValue()).toString()));
                    }
                    query.setVariables(variableList.toArray(new VariableEntry[variableList.size()]));
                    continue;
                }
                if (!((String)n.getKey()).equalsIgnoreCase("chunked") || !((JsonNode)n.getValue()).asText().equalsIgnoreCase("true")) continue;
                chunked = true;
            }
        }
        catch (Exception e) {
            log.error("Error while parsing parameter: " + request, (Throwable)e);
        }
        ServerActionParameter cidsSAP = new ServerActionParameter("QUERY", (Object)query.getQuery());
        cidsSAPs.add(cidsSAP);
        cidsSAP = new ServerActionParameter("VARIABLES", (Object)query.getVariablesAsText());
        cidsSAPs.add(cidsSAP);
        if (chunked) {
            cidsSAP = new ServerActionParameter(GraphqlAction.PARAMETER_TYPE.CHUNKED.toString(), (Object)"true");
            cidsSAPs.add(cidsSAP);
        }
        boolean shouldBeZipped = false;
        if (contentType != null && (contentType.toLowerCase().contains("gzip") || contentType.toLowerCase().contains("octet-stream"))) {
            cidsSAP = new ServerActionParameter("ZIPPED", (Object)"true");
            log.warn("cidsSAPs " + String.valueOf(cidsSAPs) + " cidsSAP: " + String.valueOf(cidsSAP));
            cidsSAPs.add(cidsSAP);
            shouldBeZipped = true;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("send graphql request (expect gzip: %s): %s", shouldBeZipped, query.getQuery()));
        }
        try {
            Object taskResult = LegacyCoreBackend.getInstance().getService().executeTask(cidsUser, "graphQl", role, null, LegacyCoreBackend.getInstance().getConnectionContext(), cidsSAPs.toArray(new ServerActionParameter[0]));
            return taskResult;
        }
        catch (Exception ex) {
            String message = "error while executing queryQl task with request '" + request + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    private static class VariableEntry {
        private String name;
        private String value;

        public VariableEntry() {
        }

        public VariableEntry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    private static class Query {
        private String query;
        private VariableEntry[] variables;
        private String operationName;

        public Query() {
        }

        public Query(String query, VariableEntry[] variables) {
            this.query = query;
            this.variables = variables;
        }

        public Query(String query, VariableEntry[] variables, String operationName) {
            this.query = query;
            this.variables = variables;
            this.operationName = operationName;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public VariableEntry[] getVariables() {
            return this.variables;
        }

        public void setVariables(VariableEntry[] variables) {
            this.variables = variables;
        }

        public String getVariablesAsText() {
            StringBuffer sb = new StringBuffer("{");
            boolean first = true;
            if (this.variables != null) {
                for (VariableEntry variable : this.variables) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append("\"").append(variable.name).append("\":");
                    sb.append(variable.value);
                }
            }
            sb.append("}");
            return sb.toString();
        }

        public String getOperationName() {
            return this.operationName;
        }

        public void setOperationName(String operationName) {
            this.operationName = operationName;
        }
    }
}

