/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy;

import Sirius.server.middleware.types.Node;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cidsx.server.api.types.CidsNode;
import de.cismet.cidsx.server.api.types.User;
import de.cismet.cidsx.server.api.types.legacy.CidsNodeFactory;
import de.cismet.cidsx.server.backend.legacy.LegacyCoreBackend;
import de.cismet.cidsx.server.cores.NodeCore;
import de.cismet.cidsx.server.exceptions.CidsServerException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyNodeCore
implements NodeCore {
    private static final Logger log = LoggerFactory.getLogger(LegacyNodeCore.class);
    private static final ObjectMapper MAPPER = new ObjectMapper(new JsonFactory());

    public List<JsonNode> getRootNodes(User user, String role) {
        LegacyCoreBackend.getInstance().ensureDomainCached(user.getDomain(), user);
        if (log.isDebugEnabled()) {
            log.debug("getRootNodes");
        }
        try {
            Sirius.server.newuser.User legacyUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            Node[] legacyNodes = LegacyCoreBackend.getInstance().getService().getRoots(legacyUser, LegacyCoreBackend.getInstance().getConnectionContext());
            ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
            for (Node legacyNode : legacyNodes) {
                String className = LegacyCoreBackend.getInstance().getClassNameCache().getClassNameForClassId(user.getDomain(), legacyNode.getClassId());
                CidsNode node = CidsNodeFactory.getFactory().restCidsNodeFromLegacyCidsNode(legacyNode, className);
                nodes.add((JsonNode)MAPPER.convertValue((Object)node, JsonNode.class));
            }
            return nodes;
        }
        catch (Exception ex) {
            String message = "error while getting root nodes: " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public JsonNode getNode(User user, String nodeKey, String role) {
        if (log.isDebugEnabled()) {
            log.debug("getNode with nodeKey '" + nodeKey + "'.");
        }
        LegacyCoreBackend.getInstance().ensureDomainCached(user.getDomain(), user);
        try {
            Sirius.server.newuser.User legacyUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            Node legacyNode = LegacyCoreBackend.getInstance().getService().getMetaObjectNode(legacyUser, Integer.parseInt(nodeKey), user.getDomain(), LegacyCoreBackend.getInstance().getConnectionContext());
            if (legacyNode != null) {
                String className = LegacyCoreBackend.getInstance().getClassNameCache().getClassNameForClassId(user.getDomain(), legacyNode.getClassId());
                CidsNode restNode = CidsNodeFactory.getFactory().restCidsNodeFromLegacyCidsNode(legacyNode, className);
                return (JsonNode)MAPPER.convertValue((Object)restNode, JsonNode.class);
            }
            return null;
        }
        catch (Exception ex) {
            String message = "error while getting a node with nodeKey '" + nodeKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public List<JsonNode> getChildren(User user, String nodeKey, String role) {
        if (log.isDebugEnabled()) {
            log.debug("getChildren with nodeKey '" + nodeKey + "'.");
        }
        LegacyCoreBackend.getInstance().ensureDomainCached(user.getDomain(), user);
        try {
            Sirius.server.newuser.User legacyUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            Node legacyNode = LegacyCoreBackend.getInstance().getService().getMetaObjectNode(legacyUser, Integer.parseInt(nodeKey), user.getDomain(), LegacyCoreBackend.getInstance().getConnectionContext());
            Node[] legacyChildrenNodes = LegacyCoreBackend.getInstance().getService().getChildren(legacyNode, legacyUser, LegacyCoreBackend.getInstance().getConnectionContext());
            ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
            for (Node legacyChildrenNode : legacyChildrenNodes) {
                String className = LegacyCoreBackend.getInstance().getClassNameCache().getClassNameForClassId(user.getDomain(), legacyChildrenNode.getClassId());
                CidsNode childrenNode = CidsNodeFactory.getFactory().restCidsNodeFromLegacyCidsNode(legacyChildrenNode, className);
                nodes.add((JsonNode)MAPPER.convertValue((Object)childrenNode, JsonNode.class));
            }
            return nodes;
        }
        catch (Exception ex) {
            String message = "error while getting children of node '" + nodeKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public List<JsonNode> getChildrenByQuery(User user, String nodeQuery, String role) {
        if (log.isDebugEnabled()) {
            log.debug("getChildrenByQuery with nodeQuery '" + nodeQuery + "'.");
        }
        LegacyCoreBackend.getInstance().ensureDomainCached(user.getDomain(), user);
        try {
            Sirius.server.newuser.User legacyUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            Node legacyNode = CidsNodeFactory.getFactory().createLegacyQueryNode(user.getDomain(), nodeQuery);
            Node[] legacyChildrenNodes = LegacyCoreBackend.getInstance().getService().getChildren(legacyNode, legacyUser, LegacyCoreBackend.getInstance().getConnectionContext());
            ArrayList<JsonNode> children = new ArrayList<JsonNode>();
            for (Node legacyChildrenNode : legacyChildrenNodes) {
                String className = LegacyCoreBackend.getInstance().getClassNameCache().getClassNameForClassId(user.getDomain(), legacyChildrenNode.getClassId());
                CidsNode childrenNode = CidsNodeFactory.getFactory().restCidsNodeFromLegacyCidsNode(legacyChildrenNode, className);
                children.add((JsonNode)MAPPER.convertValue((Object)childrenNode, JsonNode.class));
            }
            return children;
        }
        catch (Exception ex) {
            String message = "error while getting children by query '" + nodeQuery + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public String getCoreKey() {
        return "core.legacy.node";
    }

    public byte[] getLeafIcon(User user, String nodeKey, String role) {
        JsonNode iconString;
        JsonNode node = this.getNode(user, nodeKey, role);
        if (node != null && (iconString = node.get("icon")) != null) {
            return LegacyCoreBackend.getInstance().getNodeIcon(iconString.textValue(), CidsNode.IconType.LEAF_ICON);
        }
        return null;
    }

    public byte[] getOpenIcon(User user, String nodeKey, String role) {
        JsonNode iconString;
        JsonNode node = this.getNode(user, nodeKey, role);
        if (node != null && (iconString = node.get("icon")) != null) {
            return LegacyCoreBackend.getInstance().getNodeIcon(iconString.textValue(), CidsNode.IconType.OPEN_ICON);
        }
        return null;
    }

    public byte[] getClosedIcon(User user, String nodeKey, String role) {
        JsonNode iconString;
        JsonNode node = this.getNode(user, nodeKey, role);
        if (node != null && (iconString = node.get("icon")) != null) {
            return LegacyCoreBackend.getInstance().getNodeIcon(iconString.textValue(), CidsNode.IconType.CLOSED_ICON);
        }
        return null;
    }
}

