/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy;

import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.utils.serverresources.GeneralServerResources;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.cidsx.server.api.tools.Tools;
import de.cismet.cidsx.server.api.types.User;
import de.cismet.cidsx.server.backend.legacy.LegacyCoreBackend;
import de.cismet.cidsx.server.cores.InitialisableCore;
import de.cismet.cidsx.server.cores.OfflineActionCore;
import de.cismet.cidsx.server.cores.legacy.utils.OfflineActionExecutioner;
import de.cismet.cidsx.server.cores.legacy.utils.OfflineActionMessageHandler;
import de.cismet.cidsx.server.cores.legacy.utils.WebsocketClientEndpoint;
import de.cismet.cidsx.server.cores.legacy.utils.json.ActionExecutionServiceConfiguration;
import de.cismet.commons.concurrency.CismetConcurrency;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyOfflineActionCore
implements OfflineActionCore,
InitialisableCore,
Runnable,
OfflineActionMessageHandler.ConnectionStatusListener {
    private static final Logger log = LoggerFactory.getLogger(LegacyOfflineActionCore.class);
    private static final ConnectionContext CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.OTHER, (String)"ActionExecutionService");
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int MIN_DURATION_BETWEEN_LOGGING = 300000;
    private ExecutorService executor;
    private int maxParallelThreads = 10;
    private volatile boolean connectionOpen = false;
    private String pathServerResources;
    private long lastServerErrorLogging = 0L;

    @Override
    public void run() {
        Thread.currentThread().setName("ActionExecutionService");
        ActionExecutionServiceConfiguration config = this.readConfig();
        if (config == null) {
            return;
        }
        if (this.executor == null) {
            if (config.getMaxParallelThreads() != null) {
                this.maxParallelThreads = config.getMaxParallelThreads();
            }
            this.executor = CismetExecutors.newFixedThreadPool((int)this.maxParallelThreads, (ThreadFactory)CismetConcurrency.getInstance((String)"CacheRefreshService").createThreadFactory("CacheRefreshService"));
        }
        while (true) {
            try {
                while (true) {
                    OfflineActionMessageHandler handler = new OfflineActionMessageHandler(this.executor, config.getServiceUrl(), config.getHasuraSecret());
                    handler.addConnectionStatusListener(this);
                    WebsocketClientEndpoint clientEndPoint = new WebsocketClientEndpoint(handler);
                    handler.addWebsocketClientEndpoint(clientEndPoint);
                    clientEndPoint.openConnection(new URI(config.getWebSocketUrl()));
                    this.connectionOpen = true;
                    this.lastServerErrorLogging = 0L;
                    while (this.connectionOpen) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    handler.dispose();
                }
            }
            catch (Exception e) {
                if (System.currentTimeMillis() - this.lastServerErrorLogging > 300000L) {
                    log.error("WebSocketException. Retry to connect", (Throwable)e);
                    this.lastServerErrorLogging = System.currentTimeMillis();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private ActionExecutionServiceConfiguration readConfig() {
        ActionExecutionServiceConfiguration config = new ActionExecutionServiceConfiguration();
        try {
            ServerResourcesLoader.getInstance().setResourcesBasePath(this.pathServerResources);
            config = (ActionExecutionServiceConfiguration)ServerResourcesLoader.getInstance().loadJson(GeneralServerResources.OFFLINE_ACTION_JSON.getValue(), ActionExecutionServiceConfiguration.class);
        }
        catch (Exception e) {
            log.info("Cannot load the configuration for the LegacyOflineActionCore. So this core is deactivated", (Throwable)e);
            return null;
        }
        return config;
    }

    public String getCoreKey() {
        return "core.legacy.offlineAction";
    }

    public void init(String pathServerResources) {
        this.pathServerResources = pathServerResources;
        new Thread(this).start();
    }

    @Override
    public void connectionClosed() {
        this.connectionOpen = false;
    }

    @Override
    public void connectionOpened() {
    }

    public static void startTest(String[] args) {
        String jwt = "";
        User user = Tools.validationHelper((String)"Bearer ");
        Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, null);
        String bodyString = null;
        String parameters = "{\"actionname\":\"protokollStatusAenderung\",\"protokoll_id\":92184,\"status\":2,\"material\":null,\"bemerkung\":null,\"monteur\":null,\"objekt_typ\":\"arbeitsprotokoll\",\"object_name\":\"# 2 - Mast - 14 (A00014218)\",\"ccnonce\":3326849253}";
        boolean bodyUsedAsParameter = false;
        List<ServerActionParameter> parameterList = OfflineActionExecutioner.convertParameters("{\"actionname\":\"protokollStatusAenderung\",\"protokoll_id\":92184,\"status\":2,\"material\":null,\"bemerkung\":null,\"monteur\":null,\"objekt_typ\":\"arbeitsprotokoll\",\"object_name\":\"# 2 - Mast - 14 (A00014218)\",\"ccnonce\":3326849253}");
        byte[] body = null;
        String action = "protokollStatusAenderung";
        if (bodyString != null) {
            body = Base64.getDecoder().decode(bodyString);
        }
        if (log.isDebugEnabled()) {
            log.debug("execute action protokollStatusAenderung");
        }
        Object actionResult = null;
        try {
            actionResult = LegacyCoreBackend.getInstance().getService().executeTask(cidsUser, "protokollStatusAenderung", cidsUser.getDomain(), (Object)body, LegacyCoreBackend.getInstance().getConnectionContext(), parameterList.toArray(new ServerActionParameter[0]));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        System.out.println("res: " + String.valueOf(actionResult));
    }
}

