/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy;

import Sirius.server.localserver.attribute.Attribute;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.Node;
import de.cismet.cidsx.server.api.types.User;
import de.cismet.cidsx.server.backend.legacy.LegacyCoreBackend;
import de.cismet.cidsx.server.cores.PermissionCore;
import de.cismet.cidsx.server.data.RuntimeContainer;
import de.cismet.cidsx.server.exceptions.CidsServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyPermissionCore
implements PermissionCore {
    private static final Logger log = LoggerFactory.getLogger(LegacyPermissionCore.class);

    public boolean hasClassReadPermission(User user, String role, String classKey) {
        if (log.isDebugEnabled()) {
            log.debug("hasClassReadPermission with classKey '" + classKey + "'.");
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, cidsUser);
            if (metaClass == null) {
                String message = "classKey " + classKey + " not found";
                log.error(message);
                throw new CidsServerException(message, message, 404);
            }
            return metaClass.getPermissions().hasReadPermission(cidsUser);
        }
        catch (Exception ex) {
            String message = "Error reading read permissions of class '" + classKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public boolean hasClassWritePermission(User user, String role, String classKey) {
        if (log.isDebugEnabled()) {
            log.debug("hasClassWritePermission with classKey '" + classKey + "'.");
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, cidsUser);
            if (metaClass == null) {
                String message = "classKey " + classKey + " not found";
                log.error(message);
                throw new CidsServerException(message, message, 404);
            }
            return metaClass.getPermissions().hasWritePermission(cidsUser);
        }
        catch (Exception ex) {
            String message = "Error reading write permissions of class '" + classKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public boolean isCustomObjectPermissionEnabled(String classKey) {
        if (log.isDebugEnabled()) {
            log.debug("isCustomObjectPermissionEnabled with classKey '" + classKey + "'.");
        }
        return true;
    }

    public boolean hasObjectReadPermission(User user, String role, String classKey, String objectKey) {
        if (log.isDebugEnabled()) {
            log.debug("hasObjectReadPermission with classKey '" + classKey + "' and objectKey '" + objectKey + "'.");
        }
        return false;
    }

    public boolean hasObjectWritePermission(User user, String role, String classKey, String objectKey) {
        if (log.isDebugEnabled()) {
            log.debug("hasObjectWritePermission with classKey '" + classKey + "' and objectKey '" + objectKey + "'.");
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            String domain = RuntimeContainer.getServer().getDomainName();
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, cidsUser);
            if (metaClass == null) {
                String message = "classKey " + classKey + " not found";
                log.error(message);
                throw new CidsServerException(message, message, 404);
            }
            int cid = metaClass.getId();
            int oid = Integer.parseInt(objectKey);
            MetaObject metaObject = LegacyCoreBackend.getInstance().getService().getMetaObject(cidsUser, oid, cid, domain, LegacyCoreBackend.getInstance().getConnectionContext());
            return metaObject.hasObjectWritePermission(cidsUser);
        }
        catch (Exception ex) {
            String message = "Error reading write permissions of object with classKey '" + classKey + "' and objectKey '" + objectKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public boolean hasAttributeReadPermission(User user, String role, String classKey, String attributeKey) {
        if (log.isDebugEnabled()) {
            log.debug("hasAttributeReadPermission with classKey '" + classKey + "' and attributte key '" + attributeKey + "'.");
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, cidsUser);
            if (metaClass == null) {
                String message = "classKey " + classKey + " not found";
                log.error(message);
                throw new CidsServerException(message, message, 404);
            }
            return ((Attribute)metaClass.getAttributeByName(attributeKey)).getPermissions().hasReadPermission(cidsUser);
        }
        catch (Exception ex) {
            String message = "Error reading read permissions of attribute with classKey '" + classKey + "' and attributte '" + attributeKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public boolean hasAttributeWritePermission(User user, String role, String classKey, String attributeKey) {
        if (log.isDebugEnabled()) {
            log.debug("hasAttributeWritePermission with classKey '" + classKey + "' and attributte key '" + attributeKey + "'.");
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            MetaClass metaClass = LegacyCoreBackend.getInstance().getMetaClassForClassname(classKey, cidsUser);
            if (metaClass == null) {
                String message = "classKey " + classKey + " not found";
                log.error(message);
                throw new CidsServerException(message, message, 404);
            }
            return ((Attribute)metaClass.getAttributeByName(attributeKey)).getPermissions().hasWritePermission(cidsUser);
        }
        catch (Exception ex) {
            String message = "Error reading write permissions of attribute with classKey '" + classKey + "' and attributte '" + attributeKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public boolean hasNodeReadPermission(User user, String role, String nodeKey) {
        if (log.isDebugEnabled()) {
            log.debug("hasNodeReadPermission with nodeKey '" + nodeKey + "'.");
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            Node cidsNode = LegacyCoreBackend.getInstance().getService().getMetaObjectNode(cidsUser, Integer.parseInt(nodeKey), user.getDomain(), LegacyCoreBackend.getInstance().getConnectionContext());
            return cidsNode.getPermissions().hasReadPermission(cidsUser);
        }
        catch (Exception ex) {
            String message = "Error reading read permissions of node with nodeKey '" + nodeKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public boolean hasNodeWritePermission(User user, String role, String nodeKey) {
        if (log.isDebugEnabled()) {
            log.debug("hasNodeWritePermission with nodeKey '" + nodeKey + "'.");
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role);
            Node cidsNode = LegacyCoreBackend.getInstance().getService().getMetaObjectNode(cidsUser, Integer.parseInt(nodeKey), user.getDomain(), LegacyCoreBackend.getInstance().getConnectionContext());
            return cidsNode.getPermissions().hasWritePermission(cidsUser);
        }
        catch (Exception ex) {
            String message = "Error reading write permissions of node with nodeKey '" + nodeKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public String getCoreKey() {
        return "core.legacy.permission";
    }
}

