/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy;

import Sirius.server.middleware.types.LightweightMetaObject;
import com.fasterxml.jackson.databind.JsonNode;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameter;
import de.cismet.cidsx.server.api.types.User;
import de.cismet.cidsx.server.api.types.legacy.CidsBeanFactory;
import de.cismet.cidsx.server.api.types.legacy.ServerSearchFactory;
import de.cismet.cidsx.server.backend.legacy.LegacyCoreBackend;
import de.cismet.cidsx.server.cores.SearchCore;
import de.cismet.cidsx.server.exceptions.CidsServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacySearchCore
implements SearchCore {
    private static final Logger log = LoggerFactory.getLogger(LegacySearchCore.class);

    public List<SearchInfo> getAllSearches(User user, String role) {
        if (log.isDebugEnabled()) {
            log.debug("getAllSearches");
        }
        return ServerSearchFactory.getFactory().getServerSearchInfos();
    }

    public SearchInfo getSearch(User user, String searchKey, String role) {
        SearchInfo searchInfo;
        if (log.isDebugEnabled()) {
            log.debug("getSearch with searchKey '" + searchKey + "'.");
        }
        if ((searchInfo = ServerSearchFactory.getFactory().getServerSearchInfo(searchKey)) == null) {
            String message = "searchKey " + searchKey + " not found";
            log.error(message);
            throw new CidsServerException(message, message, 404);
        }
        return searchInfo;
    }

    public List<JsonNode> executeSearch(User user, String searchKey, List<SearchParameter> searchParameters, int limit, int offset, String role) {
        if (log.isDebugEnabled()) {
            log.debug("executing cids server search '" + searchKey + "' with " + searchParameters.size() + " search parameters.");
        }
        String domain = user.getDomain();
        LegacyCoreBackend.getInstance().ensureDomainCached(domain, user);
        Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, role, true);
        SearchInfo searchInfo = ServerSearchFactory.getFactory().getServerSearchInfo(searchKey);
        Class serverSearchClass = ServerSearchFactory.getFactory().getServerSearchClass(searchKey);
        if (searchInfo == null || serverSearchClass == null) {
            String message = "could not find cids server search  '" + searchKey + "'";
            log.error(message);
            throw new CidsServerException(message, message, 404);
        }
        try {
            ArrayList<JsonNode> jsonNodes;
            CidsServerSearch cidsServerSearch = ServerSearchFactory.getFactory().serverSearchInstanceFromSearchParameters(searchInfo, searchParameters);
            Collection searchResults = LegacyCoreBackend.getInstance().getService().customServerSearch(cidsUser, cidsServerSearch, LegacyCoreBackend.getInstance().getConnectionContext());
            if (searchInfo.getResultDescription().getType() == Type.ENTITY_REFERENCE) {
                if (log.isDebugEnabled()) {
                    log.debug("search result of cids server search '" + searchKey + "' is a LightweightMetaObject, need to perform custom conversion");
                }
                jsonNodes = new ArrayList();
                int i = 0;
                String className = null;
                for (Object searchResult : searchResults) {
                    if (LightweightMetaObject.class.isAssignableFrom(searchResult.getClass())) {
                        LightweightMetaObject lightweightMetaObject = (LightweightMetaObject)searchResult;
                        if (className == null) {
                            className = LegacyCoreBackend.getInstance().getClassNameCache().getClassNameForClassId(user.getDomain(), lightweightMetaObject.getClassID());
                            if (log.isDebugEnabled()) {
                                log.debug("assuming that the result collection contains only LightweightMetaObjects of type '" + className + "'");
                            }
                        }
                        JsonNode objectNode = CidsBeanFactory.getFactory().jsonNodeFromLightweightMetaObject(lightweightMetaObject, className, domain);
                        jsonNodes.add(objectNode);
                        ++i;
                        continue;
                    }
                    String message = "cannot convert search result item #" + i + " to LightweightMetaObject, wrong result type:'" + searchResult.getClass().getSimpleName() + "' ";
                    log.error(message);
                    throw new CidsServerException(message, message, 500);
                }
                if (log.isDebugEnabled()) {
                    log.debug(i + " LightWightMetaObjects returned by cids server search '" + searchKey + "' and converted to entity references!");
                }
            } else {
                jsonNodes = ServerSearchFactory.getFactory().jsonNodesFromResultCollection(searchResults, searchInfo, LegacyCoreBackend.getInstance().getClassNameCache());
            }
            return jsonNodes;
        }
        catch (Exception ex) {
            String message = "error while executing search '" + searchKey + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    public String getCoreKey() {
        return "core.legacy.search";
    }
}

