/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.server.actions.HttpTunnelAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cidsx.server.api.types.User;
import de.cismet.cidsx.server.backend.legacy.LegacyCoreBackend;
import de.cismet.cidsx.server.cores.SecresCore;
import de.cismet.cidsx.server.exceptions.CidsServerException;
import de.cismet.commons.security.AccessHandler;
import de.cismet.commons.security.WebDavClient;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacySecresCore
implements SecresCore {
    private static final Logger log = LoggerFactory.getLogger(LegacySecresCore.class);
    private static final ConnectionContext CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.ACTION, (String)"LegacyWebdavCore");
    private static final String CONF_ATTR_PREFIX = "secres://";
    private static final Set<String> missingConfigurations = new TreeSet<String>();

    public String getCoreKey() {
        return "core.legacy.secres";
    }

    public Response.ResponseBuilder executeQuery(User user, String type, String url, MultivaluedMap<String, String> queryParams, String authString) {
        Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, null, true);
        String contentType = "";
        InputStream contentStream = null;
        Response.Status responseStatus = Response.Status.INTERNAL_SERVER_ERROR;
        HashMap respHeaderList = new HashMap();
        try {
            String configAttr = LegacyCoreBackend.getInstance().getService().getConfigAttr(cidsUser, CONF_ATTR_PREFIX + type, CC);
            ObjectMapper mapper = new ObjectMapper(new JsonFactory());
            Class<ConfigurationJson> clazz = ConfigurationJson.class;
            ConfigurationJson config = null;
            try {
                config = (ConfigurationJson)mapper.readValue(configAttr, clazz);
            }
            catch (Exception e) {
                if (!missingConfigurations.contains(type)) {
                    log.error("cannot read configuration for " + type, (Throwable)e);
                    missingConfigurations.add(type);
                }
                throw new CidsServerException("Cannot read configuration", "Cannot read configuration", 500, (Throwable)e);
            }
            Map<String, List<String>> removedParameters = this.removeReservedParamsFromUrl(queryParams, config);
            Mode mode = this.parseMode(config.getMode());
            switch (mode) {
                case INTERN: {
                    ArrayList<ServerActionParameter> params = new ArrayList<ServerActionParameter>();
                    if (config.getUser() != null && config.getPassword() != null) {
                        HashMap<String, String> credentials = new HashMap<String, String>();
                        credentials.put(HttpTunnelAction.CREDENTIALS_USERNAME_KEY, config.getUser());
                        credentials.put(HttpTunnelAction.CREDENTIALS_PASSWORD_KEY, config.getPassword());
                        params.add(new ServerActionParameter(HttpTunnelAction.PARAMETER_TYPE.CREDENTIALS.toString(), credentials));
                    }
                    params.add(new ServerActionParameter(HttpTunnelAction.PARAMETER_TYPE.METHOD.toString(), (Object)AccessHandler.ACCESS_METHODS.GET_REQUEST));
                    params.add(new ServerActionParameter(HttpTunnelAction.PARAMETER_TYPE.URL.toString(), (Object)new URL(config.getBaseUrl() + url)));
                    if (this.getParamString(queryParams) != null) {
                        params.add(new ServerActionParameter(HttpTunnelAction.PARAMETER_TYPE.REQUEST.toString(), (Object)this.getParamString(queryParams)));
                    }
                    params.add(new ServerActionParameter(HttpTunnelAction.PARAMETER_TYPE.WITH_CONTENT_TYPE.toString(), (Object)Boolean.TRUE));
                    Object httpResponse = LegacyCoreBackend.getInstance().getService().executeTask(cidsUser, "httpTunnelAction", cidsUser.getDomain(), null, LegacyCoreBackend.getInstance().getConnectionContext(), params.toArray(new ServerActionParameter[0]));
                    if (!(httpResponse instanceof byte[])) break;
                    byte[] response = (byte[])httpResponse;
                    int index = 0;
                    byte separator = "\n".getBytes("utf-8")[0];
                    while (response[index] != separator) {
                        ++index;
                    }
                    responseStatus = Response.Status.OK;
                    if (index > 0) {
                        contentType = new String(Arrays.copyOf(response, index));
                    }
                    contentStream = new ByteArrayInputStream(response, ++index, response.length);
                    break;
                }
                case LOCAL: {
                    String baseUrl = config.getBaseUrl() == null ? "" : config.getBaseUrl();
                    File file = new File(baseUrl + url);
                    if (file.exists()) {
                        FileInputStream is;
                        contentStream = is = new FileInputStream(file);
                        contentType = Files.probeContentType(file.toPath());
                        responseStatus = Response.Status.OK;
                        break;
                    }
                    responseStatus = Response.Status.NOT_FOUND;
                    break;
                }
                default: {
                    WebDavClient webDav;
                    if (authString != null) {
                        String decodedAuthString = new String(Base64.getDecoder().decode(authString.substring("Basic ".length())));
                        if (decodedAuthString.contains(":")) {
                            String userFromAuthString = decodedAuthString.substring(0, decodedAuthString.indexOf(":"));
                            String passwdFromAuthString = decodedAuthString.substring(decodedAuthString.indexOf(":") + 1);
                            webDav = new WebDavClient(null, userFromAuthString, passwdFromAuthString);
                        } else {
                            webDav = new WebDavClient(null, config.getUser(), config.getPassword());
                        }
                    } else {
                        webDav = new WebDavClient(null, config.getUser(), config.getPassword());
                    }
                    String baseUrl = config.getBaseUrl() == null ? "" : config.getBaseUrl();
                    HashMap headerList = new HashMap();
                    HashMap statusList = new HashMap();
                    String paramString = this.getParamString(queryParams);
                    String targetUrl = baseUrl + url + (paramString != null ? "?" + paramString : "");
                    InputStream is = null;
                    try {
                        is = webDav.getInputStream(targetUrl, headerList, statusList);
                    }
                    catch (IllegalArgumentException e) {
                        targetUrl = baseUrl + url + (paramString != null ? "?" + URLEncoder.encode(paramString, "UTF-8") : "");
                        is = webDav.getInputStream(targetUrl, headerList, statusList);
                    }
                    contentStream = is;
                    for (String headerName : headerList.keySet()) {
                        if (headerName.equalsIgnoreCase("Content-Type")) {
                            contentType = (String)headerList.get(headerName);
                            continue;
                        }
                        respHeaderList.put(headerName, headerList.get(headerName));
                    }
                    if (Response.Status.fromStatusCode((int)((Integer)statusList.get("code"))) == null) break;
                    responseStatus = Response.Status.fromStatusCode((int)((Integer)statusList.get("code")));
                }
            }
            Response.ResponseBuilder rb = Response.status((Response.Status)responseStatus).header("Content-Type", (Object)contentType);
            if (config.getForwardResponseHeaders() != null && config.getForwardResponseHeaders().equalsIgnoreCase("true")) {
                for (String headerName : respHeaderList.keySet()) {
                    rb.header(headerName, respHeaderList.get(headerName));
                }
            }
            rb = this.addConfiguredHeader(rb, config, removedParameters);
            return rb.entity((Object)contentStream);
        }
        catch (CidsServerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String message = "error while executing secres task with url '" + url + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new CidsServerException(message, message, 500, (Throwable)ex);
        }
    }

    private Map<String, List<String>> removeReservedParamsFromUrl(MultivaluedMap<String, String> queryParams, ConfigurationJson config) {
        HashMap<String, List<String>> removedParameters = new HashMap<String, List<String>>();
        if (config.getParams() != null) {
            for (ConfigurationJson.Params param : config.getParams()) {
                if (!queryParams.containsKey((Object)param.getKey())) continue;
                removedParameters.put(param.getKey(), (List<String>)queryParams.get((Object)param.getKey()));
            }
        }
        for (String key : removedParameters.keySet()) {
            queryParams.remove((Object)key);
        }
        return removedParameters;
    }

    private Response.ResponseBuilder addConfiguredHeader(Response.ResponseBuilder builder, ConfigurationJson config, Map<String, List<String>> removedParameters) {
        Response.ResponseBuilder builderWithHeader = builder;
        if (config.getResponseHeader() != null) {
            for (ConfigurationJson.ResponseHeader responseHeader : config.getResponseHeader()) {
                builderWithHeader = builder.header(responseHeader.key, (Object)responseHeader.value);
            }
        }
        if (config.getOverwritableHeader() != null) {
            for (ConfigurationJson.OverwritableHeader overwritableHeader : config.getOverwritableHeader()) {
                builderWithHeader = builder.header(overwritableHeader.key, (Object)this.getFirstValueOrDefault(removedParameters.get(overwritableHeader.value), this.getDefaultValue(overwritableHeader.value, config)));
            }
        }
        return builderWithHeader;
    }

    private String getFirstValueOrDefault(List<String> listValue, String defaultValue) {
        if (listValue != null && listValue.size() > 0) {
            return listValue.get(0);
        }
        return defaultValue;
    }

    private String getDefaultValue(String key, ConfigurationJson config) {
        if (config.getParams() != null) {
            for (ConfigurationJson.Params param : config.getParams()) {
                if (!param.getKey().equals(key)) continue;
                return param.getDefaultValue();
            }
        }
        return null;
    }

    private String getParamString(MultivaluedMap<String, String> queryParams) {
        String paramString = null;
        if (queryParams != null && queryParams.size() > 0) {
            StringBuilder sb = new StringBuilder();
            boolean firstValue = true;
            for (String key : queryParams.keySet()) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    sb.append("&");
                }
                sb.append(key).append("=").append(this.getParamValuesAsString((List)queryParams.get((Object)key)));
            }
            paramString = sb.toString();
        }
        return paramString;
    }

    private String getParamValuesAsString(List<String> values) {
        String valueString = "";
        if (values != null && values.size() > 0) {
            StringBuilder sb = new StringBuilder();
            boolean firstValue = true;
            for (String value : values) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    sb.append(",");
                }
                sb.append(value);
            }
            valueString = sb.toString();
        }
        return valueString;
    }

    private Mode parseMode(String mode) {
        if (Mode.INTERN.toString().equalsIgnoreCase(mode)) {
            return Mode.INTERN;
        }
        if (Mode.LOCAL.toString().equalsIgnoreCase(mode)) {
            return Mode.LOCAL;
        }
        if (Mode.DEFAULT.toString().equalsIgnoreCase(mode)) {
            return Mode.DEFAULT;
        }
        log.warn("Unknown secres mode " + mode + " found. Default mode will be used");
        return Mode.DEFAULT;
    }

    public static class ConfigurationJson {
        private String user;
        private String password;
        private String baseUrl;
        private String mode;
        private String forwardResponseHeaders;
        private ResponseHeader[] responseHeader;
        private Params[] params;
        private OverwritableHeader[] overwritableHeader;

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String getMode() {
            return this.mode;
        }

        public String getForwardResponseHeaders() {
            return this.forwardResponseHeaders;
        }

        public ResponseHeader[] getResponseHeader() {
            return this.responseHeader;
        }

        public Params[] getParams() {
            return this.params;
        }

        public OverwritableHeader[] getOverwritableHeader() {
            return this.overwritableHeader;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public void setForwardResponseHeaders(String forwardResponseHeaders) {
            this.forwardResponseHeaders = forwardResponseHeaders;
        }

        public void setResponseHeader(ResponseHeader[] responseHeader) {
            this.responseHeader = responseHeader;
        }

        public void setParams(Params[] params) {
            this.params = params;
        }

        public void setOverwritableHeader(OverwritableHeader[] overwritableHeader) {
            this.overwritableHeader = overwritableHeader;
        }

        public static class OverwritableHeader {
            private String key;
            private String value;

            public String getKey() {
                return this.key;
            }

            public String getValue() {
                return this.value;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }

        public static class Params {
            private String key;
            private String defaultValue;

            public String getKey() {
                return this.key;
            }

            public String getDefaultValue() {
                return this.defaultValue;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public void setDefaultValue(String defaultValue) {
                this.defaultValue = defaultValue;
            }
        }

        public static class ResponseHeader {
            private String key;
            private String value;

            public String getKey() {
                return this.key;
            }

            public String getValue() {
                return this.value;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }

    private static enum Mode {
        DEFAULT,
        INTERN,
        LOCAL;

    }
}

