/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy;

import Sirius.server.newuser.UserGroup;
import de.cismet.cidsx.server.api.types.User;
import de.cismet.cidsx.server.backend.legacy.LegacyCoreBackend;
import de.cismet.cidsx.server.cores.UserCore;
import java.security.Key;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyUserCore
implements UserCore {
    private static final Logger log = LoggerFactory.getLogger(LegacyUserCore.class);

    public boolean isNoneUserAllowed() {
        return false;
    }

    public User validate(User user) {
        String domain;
        String password;
        String username;
        if (log.isDebugEnabled()) {
            log.debug("validate with user '" + user.getUser() + "'.");
        }
        System.setProperty("sun.rmi.transport.connectionTimeout", "15");
        if (user.getJwt() != null) {
            username = "jwt";
            password = user.getJwt();
            domain = user.getDomain();
        } else {
            username = user.getUser();
            password = user.getPass();
            domain = user.getDomain();
        }
        try {
            Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getService().getUser(null, null, domain, username, password, LegacyCoreBackend.getInstance().getConnectionContext());
            ArrayList<String> userGroupNames = new ArrayList<String>();
            if (cidsUser.getPotentialUserGroups() != null) {
                for (UserGroup cidsUserGroup : cidsUser.getPotentialUserGroups()) {
                    userGroupNames.add(cidsUserGroup.getName());
                }
            }
            if (userGroupNames.isEmpty() && cidsUser.getUserGroup() != null) {
                userGroupNames.add(cidsUser.getUserGroup().getName());
            }
            user.setUserGroups(userGroupNames);
            LegacyCoreBackend.getInstance().registerUser(cidsUser, user);
            user.setValidated(true);
            user.setJwt(cidsUser.getJwsToken());
        }
        catch (Exception ex) {
            log.error("Could not validate user '" + user.getUser() + "': " + ex.getMessage(), (Throwable)ex);
            user.setValidated(false);
        }
        return user;
    }

    public Key getPublicJwtKey(String domain) {
        try {
            return LegacyCoreBackend.getInstance().getService().getPublicJwtKey(domain);
        }
        catch (Exception e) {
            log.error("Cannot retrieve public jwt key", (Throwable)e);
            return null;
        }
    }

    public String getCoreKey() {
        return "core.legacy.user";
    }
}

