/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy.custom;

import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cidsx.server.cores.legacy.custom.CustomOfflineActionGrouper;
import de.cismet.cidsx.server.cores.legacy.utils.OfflineActionExecutioner;
import de.cismet.cidsx.server.cores.legacy.utils.json.SubscriptionResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BelisOfflineActionGrouper
implements CustomOfflineActionGrouper {
    private static final Logger log = LoggerFactory.getLogger(BelisOfflineActionGrouper.class);
    private static final String[] TASKNAMES = new String[]{"addDocument", "BelisWebDavTunnelAction", "LockEntities", "addIncident", "uploadDocument", "protokollFortfuehrungsantrag", "protokollLeuchteLeuchtenerneuerung", "protokollLeuchteLeuchtmittelwechselElekpruefung", "protokollLeuchteLeuchtmittelwechsel", "protokollLeuchteRundsteuerempfaengerwechsel", "protokollLeuchteSonderturnus", "protokollLeuchteVorschaltgeraetwechsel", "protokollMauerlaschePruefung", "protokollSchaltstelleRevision", "protokollStandortAnstricharbeiten", "protokollStandortElektrischePruefung", "protokollStandortMasterneuerung", "protokollStandortRevision", "protokollStandortStandsicherheitspruefung", "protokollStatusAenderung"};

    @Override
    public List<List<SubscriptionResponse.Payload.Data.Action>> groupActions(List<SubscriptionResponse.Payload.Data.Action> actionList) {
        ArrayList<List<SubscriptionResponse.Payload.Data.Action>> groupedActions = new ArrayList<List<SubscriptionResponse.Payload.Data.Action>>();
        HashMap<String, ArrayList<SubscriptionResponse.Payload.Data.Action>> actionsByProtocol = new HashMap<String, ArrayList<SubscriptionResponse.Payload.Data.Action>>();
        for (SubscriptionResponse.Payload.Data.Action a : actionList) {
            List<SubscriptionResponse.Payload.Data.Action> list;
            String key;
            String parameter = a.getParameter();
            List<ServerActionParameter> parameterList = OfflineActionExecutioner.convertParameters(parameter);
            String protocollId = null;
            String objectType = null;
            String objectId = null;
            for (ServerActionParameter para : parameterList) {
                if (para.getKey().equalsIgnoreCase("PROTOKOLL_ID")) {
                    protocollId = String.valueOf(para.getValue());
                    break;
                }
                if (para.getKey().equalsIgnoreCase("objekt_id")) {
                    objectId = String.valueOf(para.getValue());
                    break;
                }
                if (!para.getKey().equalsIgnoreCase("objekt_typ")) continue;
                objectType = String.valueOf(para.getValue());
                break;
            }
            if (protocollId != null || objectType == null || objectId == null) {
                key = "prot_" + protocollId;
                list = (ArrayList<SubscriptionResponse.Payload.Data.Action>)actionsByProtocol.get(key);
                if (list == null) {
                    list = new ArrayList<SubscriptionResponse.Payload.Data.Action>();
                    actionsByProtocol.put(key, (ArrayList<SubscriptionResponse.Payload.Data.Action>)list);
                }
                list.add(a);
                continue;
            }
            key = objectType + "_" + objectId;
            list = (List)actionsByProtocol.get(key);
            if (list == null) {
                list = new ArrayList();
                actionsByProtocol.put(key, (ArrayList<SubscriptionResponse.Payload.Data.Action>)list);
            }
            list.add(a);
        }
        for (String key : actionsByProtocol.keySet()) {
            if (key == null) {
                for (SubscriptionResponse.Payload.Data.Action tmp : (List)actionsByProtocol.get(key)) {
                    ArrayList<SubscriptionResponse.Payload.Data.Action> tmpList = new ArrayList<SubscriptionResponse.Payload.Data.Action>();
                    tmpList.add(tmp);
                    groupedActions.add(tmpList);
                }
                continue;
            }
            List tmpList = (List)actionsByProtocol.get(key);
            Collections.sort(actionList, new Comparator<SubscriptionResponse.Payload.Data.Action>(){

                @Override
                public int compare(SubscriptionResponse.Payload.Data.Action o1, SubscriptionResponse.Payload.Data.Action o2) {
                    return this.toDate(o1.getCreatedAt()).compareTo(this.toDate(o2.getCreatedAt()));
                }

                private Date toDate(String dateString) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'H:m:s.SSSX");
                    try {
                        return formatter.parse(dateString);
                    }
                    catch (ParseException e) {
                        log.warn("Cannot parse date: " + dateString);
                        return new Date();
                    }
                }
            });
            groupedActions.add(tmpList);
        }
        return groupedActions;
    }

    @Override
    public boolean canHandleAction(SubscriptionResponse.Payload.Data.Action action) {
        for (String taskname : TASKNAMES) {
            if (!taskname.equals(action.getAction())) continue;
            return true;
        }
        return false;
    }
}

