/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy.custom;

import de.cismet.cidsx.server.cores.legacy.custom.CustomOfflineActionGrouper;
import de.cismet.cidsx.server.cores.legacy.utils.json.SubscriptionResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VzkOfflineActionGrouper
implements CustomOfflineActionGrouper {
    private static final Logger log = LoggerFactory.getLogger(VzkOfflineActionGrouper.class);
    private static String[] TASKNAMES = new String[]{"saveObject"};

    @Override
    public List<List<SubscriptionResponse.Payload.Data.Action>> groupActions(List<SubscriptionResponse.Payload.Data.Action> actionList) {
        ArrayList<List<SubscriptionResponse.Payload.Data.Action>> groupedActions = new ArrayList<List<SubscriptionResponse.Payload.Data.Action>>();
        groupedActions.add(actionList);
        Collections.sort(actionList, new Comparator<SubscriptionResponse.Payload.Data.Action>(){

            @Override
            public int compare(SubscriptionResponse.Payload.Data.Action o1, SubscriptionResponse.Payload.Data.Action o2) {
                return this.toDate(o1.getCreatedAt()).compareTo(this.toDate(o2.getCreatedAt()));
            }

            private Date toDate(String dateString) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'H:m:s.SSSX");
                try {
                    return formatter.parse(dateString);
                }
                catch (ParseException e) {
                    log.warn("Cannot parse date: " + dateString);
                    return new Date();
                }
            }
        });
        return groupedActions;
    }

    @Override
    public boolean canHandleAction(SubscriptionResponse.Payload.Data.Action action) {
        for (String taskname : TASKNAMES) {
            if (!taskname.equals(action.getAction())) continue;
            return true;
        }
        return false;
    }
}

