/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cidsx.server.cores.legacy.utils.json.GraphQlQuery;
import de.cismet.cidsx.server.cores.legacy.utils.json.SubscriptionResponse;
import de.cismet.cidsx.server.cores.legacy.utils.json.UpdateResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasuraHelper {
    private static final Logger log = LoggerFactory.getLogger(HasuraHelper.class);
    private static final String UPDATE_QUERY = "mutation UpdateActionResult {update_action(where: {id: {_eq: \"%1s\"}}, _set: {result: \"%2s\", updatedAt: \"now()\"}){affected_rows}}";
    private static final String STATUS_UPDATE_QUERY = "mutation UpdateActionStatus {update_action(where: {id: {_eq: \"%1s\"}}, _set: {status: %2s, updatedAt: \"now()\"}){affected_rows}}";
    private static final String STATUS_RESULT_UPDATE_QUERY = "mutation UpdateActionStatus {update_action(where: {id: {_eq: \"%1s\"}}, _set: {result: \"%2s\", status: %3s, updatedAt: \"now()\"}){affected_rows}}";
    private static final String STATUS_RESULT_PARAMETER_UPDATE_QUERY = "mutation UpdateActionStatus {update_action(where: {id: {_eq: \"%1s\"}}, _set: {result: \"%2s\", status: %3s, updatedAt: \"now()\", parameter: \"%4s\"}){affected_rows}}";
    private static final String STATUS_PARAMETER_UPDATE_QUERY = "mutation UpdateActionStatus {update_action(where: {id: {_eq: \"%1s\"}}, _set: {status: %3s, updatedAt: \"now()\", parameter: \"%4s\"}){affected_rows}}";
    private static final String GET_PARAMETER_QUERY = "query GetParameter {action(where: {_and: {id: {_eq: \"%1s\"}}}) {id parameter}}";
    private static final String GET_BODY_QUERY = "query GetBody {action(where: {_and: {id: {_eq: \"%1s\"}}}) {id body}}";
    private static final String BODY_MARKER = "$$_body_$$";
    private final String hasuraUrlString;
    private final String hasuraSecret;

    public HasuraHelper(String hasuraUrlString, String hasuraSecret) {
        this.hasuraUrlString = hasuraUrlString;
        this.hasuraSecret = hasuraSecret;
    }

    public String sendHasuraRequest(GraphQlQuery queryObject) throws Exception {
        String tmp;
        URL hasuraUrl = new URL(this.hasuraUrlString);
        HttpURLConnection con = (HttpURLConnection)hasuraUrl.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        con.setRequestProperty("x-hasura-admin-secret", this.hasuraSecret);
        con.setDoOutput(true);
        con.setDoInput(true);
        con.connect();
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(con.getOutputStream()));
        w.write(new ObjectMapper().writeValueAsString((Object)queryObject));
        w.close();
        if (log.isDebugEnabled()) {
            log.debug("send request: " + new ObjectMapper().writeValueAsString((Object)queryObject));
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer requestResult = new StringBuffer();
        while ((tmp = r.readLine()) != null) {
            requestResult.append(tmp);
        }
        r.close();
        return requestResult.toString();
    }

    public String buildParametersString(String json, String body) {
        String extendedJson;
        String string = extendedJson = body != null && this.isBodyUsedAsParameter(json) ? json.replace(BODY_MARKER, body) : json;
        if (body == null && this.isBodyUsedAsParameter(json)) {
            log.warn("The body placeholder is set in parameter field, but the body field is null. Do not replace body placeholder");
        }
        return extendedJson;
    }

    public boolean isBodyUsedAsParameter(String parameters) {
        return parameters != null && parameters.contains(BODY_MARKER);
    }

    public String getBody(String id) throws Exception {
        String query = String.format(GET_BODY_QUERY, id);
        GraphQlQuery queryObject = new GraphQlQuery();
        queryObject.setOperationName("GetBody");
        queryObject.setQuery(query);
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        String res = this.sendHasuraRequest(queryObject);
        SubscriptionResponse.Payload result = (SubscriptionResponse.Payload)mapper.readValue(res, SubscriptionResponse.Payload.class);
        if (!result.getData().getAction()[0].getId().equals(id)) {
            log.error("Unexpected response when retrieving parameters:\n" + res);
        }
        return result.getData().getAction()[0].getBody();
    }

    public String getParameters(String id) throws Exception {
        String query = String.format(GET_PARAMETER_QUERY, id);
        GraphQlQuery queryObject = new GraphQlQuery();
        queryObject.setOperationName("GetParameter");
        queryObject.setQuery(query);
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        String res = this.sendHasuraRequest(queryObject);
        SubscriptionResponse.Payload result = (SubscriptionResponse.Payload)mapper.readValue(res, SubscriptionResponse.Payload.class);
        if (!result.getData().getAction()[0].getId().equals(id)) {
            log.error("Unexpected response when retrieving parameters:\n" + res);
        }
        return result.getData().getAction()[0].getParameter();
    }

    public void sendResultUpdate(SubscriptionResponse.Payload.Data.Action a, String result) throws Exception {
        a.setResult(result);
        String query = String.format(UPDATE_QUERY, a.getId(), a.getResult().replace("\"", "\\\""));
        GraphQlQuery queryObject = new GraphQlQuery();
        queryObject.setOperationName("UpdateActionResult");
        queryObject.setQuery(query);
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        String updateResult = this.sendHasuraRequest(queryObject);
        UpdateResult uResult = (UpdateResult)mapper.readValue(updateResult, UpdateResult.class);
        if (uResult.getData().getUpdate_action().getAffected_rows() == null || !uResult.getData().getUpdate_action().getAffected_rows().equals(1)) {
            log.error("Unexpected response when updating action result:\n" + updateResult);
        }
    }

    public void sendStatusUpdate(SubscriptionResponse.Payload.Data.Action a, Integer status) throws Exception {
        a.setStatus(status);
        String query = String.format(STATUS_UPDATE_QUERY, a.getId(), a.getStatus());
        GraphQlQuery queryObject = new GraphQlQuery();
        queryObject.setOperationName("UpdateActionStatus");
        queryObject.setQuery(query);
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        String updateResult = this.sendHasuraRequest(queryObject);
        UpdateResult uResult = (UpdateResult)mapper.readValue(updateResult, UpdateResult.class);
        if (uResult.getData().getUpdate_action().getAffected_rows() == null || !uResult.getData().getUpdate_action().getAffected_rows().equals(1)) {
            log.error("Unexpected response when updating action result:\n" + updateResult);
        }
    }

    public void sendStatusResultUpdate(SubscriptionResponse.Payload.Data.Action a, String res, Integer status) throws Exception {
        String result = res;
        boolean noEscape = false;
        try {
            result = new ObjectMapper().writeValueAsString((Object)result);
            if (result.startsWith("\"") && result.endsWith("\"")) {
                result = result.substring(1, result.length() - 1);
            }
            noEscape = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        a.setResult(result);
        a.setStatus(status);
        String query = String.format(STATUS_RESULT_UPDATE_QUERY, a.getId(), noEscape ? a.getResult() : a.getResult().replace("\"", "\\\""), a.getStatus());
        GraphQlQuery queryObject = new GraphQlQuery();
        queryObject.setOperationName("UpdateActionStatus");
        queryObject.setQuery(query);
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        String updateResult = this.sendHasuraRequest(queryObject);
        UpdateResult uResult = (UpdateResult)mapper.readValue(updateResult, UpdateResult.class);
        if (uResult.getData().getUpdate_action().getAffected_rows() == null || !uResult.getData().getUpdate_action().getAffected_rows().equals(1)) {
            log.error("Unexpected response when updating action result:\n" + updateResult);
        }
    }

    public void sendUpdate(SubscriptionResponse.Payload.Data.Action a, String result, String parameter, Integer status) throws Exception {
        a.setResult(result);
        a.setStatus(status);
        a.setParameter(parameter);
        String query = String.format(STATUS_RESULT_PARAMETER_UPDATE_QUERY, a.getId(), a.getResult().replace("\"", "\\\""), a.getStatus(), a.getParameter().replace("\"", "\\\""));
        GraphQlQuery queryObject = new GraphQlQuery();
        queryObject.setOperationName("UpdateActionStatus");
        queryObject.setQuery(query);
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        String updateResult = this.sendHasuraRequest(queryObject);
        UpdateResult uResult = (UpdateResult)mapper.readValue(updateResult, UpdateResult.class);
        if (uResult.getData().getUpdate_action().getAffected_rows() == null || !uResult.getData().getUpdate_action().getAffected_rows().equals(1)) {
            log.error("Unexpected response when updating action result:\n" + updateResult);
        }
    }

    public void sendUpdate(SubscriptionResponse.Payload.Data.Action a, String parameter, Integer status) throws Exception {
        a.setStatus(status);
        a.setParameter(parameter);
        String query = String.format(STATUS_PARAMETER_UPDATE_QUERY, a.getId(), a.getStatus(), a.getParameter());
        GraphQlQuery queryObject = new GraphQlQuery();
        queryObject.setOperationName("UpdateActionStatus");
        queryObject.setQuery(query);
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        String updateResult = this.sendHasuraRequest(queryObject);
        UpdateResult uResult = (UpdateResult)mapper.readValue(updateResult, UpdateResult.class);
        if (uResult.getData().getUpdate_action().getAffected_rows() == null || !uResult.getData().getUpdate_action().getAffected_rows().equals(1)) {
            log.error("Unexpected response when updating action result:\n" + updateResult);
        }
    }
}

