/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cidsx.server.api.tools.Tools;
import de.cismet.cidsx.server.api.types.User;
import de.cismet.cidsx.server.backend.legacy.LegacyCoreBackend;
import de.cismet.cidsx.server.cores.legacy.custom.CustomOfflineActionParameterModifier;
import de.cismet.cidsx.server.cores.legacy.utils.HasuraHelper;
import de.cismet.cidsx.server.cores.legacy.utils.json.SubscriptionResponse;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openide.util.Lookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflineActionExecutioner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(OfflineActionExecutioner.class);
    private final List<SubscriptionResponse.Payload.Data.Action> action;
    private final List<SubscriptionResponse.Payload.Data.Action> waitingAction = new ArrayList<SubscriptionResponse.Payload.Data.Action>();
    private final String hasuraUrlString;
    private final String hasuraSecret;

    public OfflineActionExecutioner(List<SubscriptionResponse.Payload.Data.Action> action, String hasuraUrlString, String hasuraSecret) {
        this.action = action;
        this.hasuraUrlString = hasuraUrlString;
        this.hasuraSecret = hasuraSecret;
    }

    @Override
    public void run() {
        HasuraHelper helper = new HasuraHelper(this.hasuraUrlString, this.hasuraSecret);
        this.waitingAction.addAll(this.action);
        int attempt = 0;
        Collection modifier = Lookup.getDefault().lookupAll(CustomOfflineActionParameterModifier.class);
        while (!this.waitingAction.isEmpty() && attempt <= 10) {
            Collections.sort(this.waitingAction, new Comparator<SubscriptionResponse.Payload.Data.Action>(){

                @Override
                public int compare(SubscriptionResponse.Payload.Data.Action o1, SubscriptionResponse.Payload.Data.Action o2) {
                    Integer index1 = OfflineActionExecutioner.this.action.indexOf(o1);
                    Integer index2 = OfflineActionExecutioner.this.action.indexOf(o2);
                    return index1.compareTo(index2);
                }
            });
            ++attempt;
            ArrayList<SubscriptionResponse.Payload.Data.Action> tmpList = new ArrayList<SubscriptionResponse.Payload.Data.Action>();
            tmpList.addAll(this.waitingAction);
            this.waitingAction.clear();
            for (SubscriptionResponse.Payload.Data.Action a : tmpList) {
                try {
                    CustomOfflineActionParameterModifier m;
                    User user = Tools.validationHelper((String)("Bearer " + a.getJwt()));
                    if (Tools.canHazUserProblems((User)user)) {
                        helper.sendStatusUpdate(a, 401);
                        continue;
                    }
                    helper.sendStatusUpdate(a, 202);
                    Sirius.server.newuser.User cidsUser = LegacyCoreBackend.getInstance().getCidsUser(user, null);
                    String bodyString = a.getBody();
                    String parameters = a.getParameter();
                    boolean bodyUsedAsParameter = helper.isBodyUsedAsParameter(parameters);
                    List<ServerActionParameter> parameterList = OfflineActionExecutioner.convertParameters(parameters);
                    byte[] body = null;
                    if (!bodyUsedAsParameter && bodyString != null) {
                        body = Base64.getDecoder().decode(bodyString);
                    }
                    if (log.isInfoEnabled()) {
                        log.info("execute action " + a.getAction());
                    }
                    Object actionResult = null;
                    ServerActionParameter[] saps = parameterList.toArray(new ServerActionParameter[0]);
                    try {
                        actionResult = LegacyCoreBackend.getInstance().getService().executeTask(cidsUser, a.getAction(), cidsUser.getDomain(), (Object)body, LegacyCoreBackend.getInstance().getConnectionContext(), saps);
                    }
                    catch (RemoteException e) {
                        helper.sendStatusResultUpdate(a, "{\"Exception\": \"" + e.getMessage() + "\"}", 500);
                        continue;
                    }
                    if (actionResult instanceof Exception && ((Exception)actionResult).getMessage() != null && ((Exception)actionResult).getMessage().equals("A lock for the desired object is already existing")) {
                        this.waitingAction.add(a);
                        helper.sendStatusResultUpdate(a, "{\"Exception\": \"" + ((Exception)actionResult).getMessage() + "\"}", 210 + attempt);
                        continue;
                    }
                    if (actionResult instanceof Exception) {
                        log.warn("Exception returned from action " + a.getAction(), (Throwable)((Exception)actionResult));
                        if (((Exception)actionResult).getMessage() != null && ((Exception)actionResult).getMessage().equals("missing id as param")) {
                            log.error("missing id as param");
                        }
                        helper.sendStatusResultUpdate(a, "{\"Exception\": \"" + ((Exception)actionResult).getMessage() + "\"}", 500);
                        continue;
                    }
                    if (actionResult != null) {
                        m = this.getModifier(modifier, a);
                        if (m != null) {
                            helper.sendUpdate(a, actionResult.toString(), m.modifyParameter(a), 200);
                            continue;
                        }
                        helper.sendStatusResultUpdate(a, actionResult.toString(), 200);
                        continue;
                    }
                    m = this.getModifier(modifier, a);
                    if (m != null) {
                        helper.sendUpdate(a, null, m.modifyParameter(a), 200);
                        continue;
                    }
                    helper.sendStatusUpdate(a, 200);
                }
                catch (Exception e) {
                    log.error("Error while executing action", (Throwable)e);
                }
            }
            if (this.waitingAction.isEmpty()) continue;
            try {
                Thread.sleep((long)Math.pow(2.0, attempt));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private CustomOfflineActionParameterModifier getModifier(Collection<? extends CustomOfflineActionParameterModifier> modifier, SubscriptionResponse.Payload.Data.Action a) {
        if (modifier != null) {
            for (CustomOfflineActionParameterModifier customOfflineActionParameterModifier : modifier) {
                if (!customOfflineActionParameterModifier.canHandleAction(a)) continue;
                return customOfflineActionParameterModifier;
            }
        }
        return null;
    }

    public static List<ServerActionParameter> convertParameters(String json) {
        ArrayList<ServerActionParameter> cidsSAPs = new ArrayList<ServerActionParameter>();
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        try {
            JsonNode node = mapper.readTree(json);
            Iterator it = node.fields();
            while (it.hasNext()) {
                ServerActionParameter cidsSAP;
                Map.Entry n = (Map.Entry)it.next();
                if (n.getValue() instanceof ArrayNode) {
                    ArrayNode array = (ArrayNode)n.getValue();
                    ArrayList list = new ArrayList();
                    for (int i = 0; i < array.size(); ++i) {
                        if (!(array.get(i) instanceof ObjectNode)) continue;
                        HashMap<String, String> map = new HashMap<String, String>();
                        ObjectNode oNode = (ObjectNode)array.get(i);
                        Iterator fields = oNode.fieldNames();
                        while (fields.hasNext()) {
                            String field = (String)fields.next();
                            JsonNode subNode = oNode.get(field);
                            map.put(field, subNode.asText());
                        }
                        list.add(map);
                    }
                    ServerActionParameter cidsSAP2 = new ServerActionParameter((String)n.getKey(), list);
                    cidsSAPs.add(cidsSAP2);
                    continue;
                }
                if (n.getValue() instanceof NullNode) continue;
                if (((JsonNode)n.getValue()).asText().equals("") && !((JsonNode)n.getValue()).toString().equals("") && n.getValue() instanceof ObjectNode) {
                    cidsSAP = new ServerActionParameter((String)n.getKey(), OfflineActionExecutioner.toLinkedHashMap((ObjectNode)n.getValue()));
                    cidsSAPs.add(cidsSAP);
                    continue;
                }
                cidsSAP = new ServerActionParameter((String)n.getKey(), (Object)((JsonNode)n.getValue()).asText());
                cidsSAPs.add(cidsSAP);
            }
        }
        catch (Exception e) {
            log.error("Error while parsing parameter: " + json, (Throwable)e);
        }
        return cidsSAPs;
    }

    public static Map<String, Object> toLinkedHashMap(ObjectNode objectNode) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Iterator fields = objectNode.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            if (entry.getValue() instanceof NullNode) continue;
            if (((JsonNode)entry.getValue()).asText().equals("") && !((JsonNode)entry.getValue()).toString().equals("") && entry.getValue() instanceof ObjectNode) {
                map.put((String)entry.getKey(), OfflineActionExecutioner.toLinkedHashMap((ObjectNode)entry.getValue()));
                continue;
            }
            map.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
        }
        return map;
    }
}

