/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cidsx.server.cores.legacy.custom.CustomOfflineActionGrouper;
import de.cismet.cidsx.server.cores.legacy.utils.HasuraHelper;
import de.cismet.cidsx.server.cores.legacy.utils.OfflineActionExecutioner;
import de.cismet.cidsx.server.cores.legacy.utils.WebsocketClientEndpoint;
import de.cismet.cidsx.server.cores.legacy.utils.json.SubscriptionResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.openide.util.Lookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflineActionMessageHandler
implements WebsocketClientEndpoint.MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(OfflineActionMessageHandler.class);
    private static final int MILLIS_PER_SECOND = 1000;
    private static final String INIT_WEBSOCKET_QUERY = "{\"type\":\"connection_init\",\"payload\":{\"headers\":{\"X-Hasura-Admin-Secret\":\"%1s\"}}}";
    private static final String INIT_SUBSCRIPTION_QUERY = "{\"id\":\"1\",\"type\":\"start\",\"payload\":{\"query\":\"subscription onActionChanged {action(where: { _and: {isCompleted: {_eq: false}, result: {_is_null: true}, _or: [{ status: {_is_null: true}}, {status: {_eq: 401}}]} }) {id jwt isCompleted applicationId createdAt updatedAt status action, result} }\"}}";
    private WebsocketClientEndpoint websocketClient = null;
    private ExecutorService executor;
    private final String hasuraUrlString;
    private final String hasuraSecret;
    private final Map<String, SubscriptionResponse.Payload.Data.Action> lastActions = new HashMap<String, SubscriptionResponse.Payload.Data.Action>();
    private final List<ConnectionStatusListener> statusListener = new ArrayList<ConnectionStatusListener>();

    public OfflineActionMessageHandler(ExecutorService executor, String hasuraUrlString, String hasuraSecret) {
        this.executor = executor;
        this.hasuraUrlString = hasuraUrlString;
        this.hasuraSecret = hasuraSecret;
    }

    public void addConnectionStatusListener(ConnectionStatusListener listener) {
        this.statusListener.add(listener);
    }

    public void addWebsocketClientEndpoint(WebsocketClientEndpoint websocketClient) {
        this.websocketClient = websocketClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void handleMessage(String message) {
        if (log.isDebugEnabled() && !message.equalsIgnoreCase("{\"type\":\"ka\"}")) {
            log.debug("retrieve message: " + message);
        }
        Map<String, SubscriptionResponse.Payload.Data.Action> map = this.lastActions;
        synchronized (map) {
            block20: {
                try {
                    ObjectMapper mapper = new ObjectMapper(new JsonFactory());
                    HasuraHelper helper = new HasuraHelper(this.hasuraUrlString, this.hasuraSecret);
                    SubscriptionResponse response = (SubscriptionResponse)mapper.readValue(message, SubscriptionResponse.class);
                    if (response.getType().equals("data")) {
                        void var9_12;
                        HashMap<CustomOfflineActionGrouper, ArrayList<Object>> groupedActions = new HashMap<CustomOfflineActionGrouper, ArrayList<Object>>();
                        SubscriptionResponse.Payload.Data.Action[] actionArray = response.getPayload().getData().getAction();
                        int n = actionArray.length;
                        boolean bl = false;
                        while (var9_12 < n) {
                            SubscriptionResponse.Payload.Data.Action action = actionArray[var9_12];
                            SubscriptionResponse.Payload.Data.Action lastState = this.lastActions.get(action.getId());
                            if (lastState == null || !lastState.equals(action)) {
                                this.lastActions.put(action.getId(), action);
                                if (action.getStatus() == null || action.getStatus() != 200 && action.getStatus() != 202 && (action.getStatus() < 210 || action.getStatus() > 231)) {
                                    Collection actionGrouper = Lookup.getDefault().lookupAll(CustomOfflineActionGrouper.class);
                                    boolean grouperFound = false;
                                    String bodyString = helper.getBody(action.getId());
                                    String parameters = helper.getParameters(action.getId());
                                    action.setParameter(helper.buildParametersString(parameters, bodyString));
                                    action.setBody(bodyString);
                                    for (CustomOfflineActionGrouper grouper : actionGrouper) {
                                        if (!grouper.canHandleAction(action)) continue;
                                        ArrayList<Object> actionList = (ArrayList<Object>)groupedActions.get(grouper);
                                        if (actionList == null) {
                                            actionList = new ArrayList<Object>();
                                            groupedActions.put(grouper, actionList);
                                        }
                                        actionList.add(action);
                                        grouperFound = true;
                                        break;
                                    }
                                    if (!grouperFound) {
                                        ArrayList<Object> actionList = (ArrayList<Object>)groupedActions.get(null);
                                        if (actionList == null) {
                                            actionList = new ArrayList<Object>();
                                            groupedActions.put(null, actionList);
                                        }
                                        actionList.add(action);
                                    }
                                }
                            }
                            ++var9_12;
                        }
                        ArrayList<List<SubscriptionResponse.Payload.Data.Action>> actionList = new ArrayList<List<SubscriptionResponse.Payload.Data.Action>>();
                        for (CustomOfflineActionGrouper customOfflineActionGrouper : groupedActions.keySet()) {
                            if (customOfflineActionGrouper == null) {
                                for (SubscriptionResponse.Payload.Data.Action action : (List)groupedActions.get(null)) {
                                    actionList.add(Arrays.asList(action));
                                }
                                continue;
                            }
                            List<List<SubscriptionResponse.Payload.Data.Action>> grouperResult = customOfflineActionGrouper.groupActions((List)groupedActions.get(customOfflineActionGrouper));
                            for (List<SubscriptionResponse.Payload.Data.Action> list : grouperResult) {
                                actionList.add(list);
                            }
                        }
                        Collections.sort(actionList, new Comparator<List<SubscriptionResponse.Payload.Data.Action>>(){

                            @Override
                            public int compare(List<SubscriptionResponse.Payload.Data.Action> o1, List<SubscriptionResponse.Payload.Data.Action> o2) {
                                SubscriptionResponse.Payload.Data.Action a1 = o1.get(0);
                                SubscriptionResponse.Payload.Data.Action a2 = o2.get(0);
                                return this.toDate(a1.getCreatedAt()).compareTo(this.toDate(a2.getCreatedAt()));
                            }

                            private Date toDate(String dateString) {
                                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'H:m:s.SSSX");
                                try {
                                    return formatter.parse(dateString);
                                }
                                catch (ParseException e) {
                                    log.warn("Cannot parse date: " + dateString);
                                    return new Date();
                                }
                            }
                        });
                        for (List list : actionList) {
                            OfflineActionExecutioner ae = new OfflineActionExecutioner(list, this.hasuraUrlString, this.hasuraSecret);
                            this.executor.submit(ae);
                        }
                        break block20;
                    }
                    if (response.getType().equals("error")) {
                        log.error("An error message was send:\n" + message);
                    }
                }
                catch (Exception e) {
                    log.error("Cannot handle hasura message", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void connectionOpened() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug("connection is open");
        }
        this.websocketClient.sendMessage(String.format(INIT_WEBSOCKET_QUERY, this.hasuraSecret));
        this.websocketClient.sendMessage(INIT_SUBSCRIPTION_QUERY);
    }

    @Override
    public void connectionClosed() {
        for (ConnectionStatusListener listener : this.statusListener) {
            listener.connectionClosed();
        }
    }

    public void dispose() {
        this.statusListener.clear();
    }

    public static interface ConnectionStatusListener {
        public void connectionOpened();

        public void connectionClosed();
    }
}

