/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.server.cores.legacy.utils;

import java.net.URI;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

@ClientEndpoint
public class WebsocketClientEndpoint {
    private Session userSession = null;
    private MessageHandler messageHandler;

    public WebsocketClientEndpoint(MessageHandler msgHandler) {
        this.messageHandler = msgHandler;
    }

    public void openConnection(URI endpointURI) throws Exception {
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        container.connectToServer((Object)this, endpointURI);
    }

    @OnOpen
    public void onOpen(Session userSession) {
        this.userSession = userSession;
        if (this.messageHandler != null) {
            this.messageHandler.connectionOpened();
        }
    }

    @OnClose
    public void onClose(Session userSession, CloseReason reason) {
        this.userSession = null;
        if (this.messageHandler != null) {
            this.messageHandler.connectionClosed();
        }
    }

    @OnMessage
    public void onMessage(String message) {
        if (this.messageHandler != null) {
            this.messageHandler.handleMessage(message);
        }
    }

    public void addMessageHandler(MessageHandler msgHandler) {
        this.messageHandler = msgHandler;
    }

    public void sendMessage(String message) {
        this.userSession.getAsyncRemote().sendText(message);
    }

    public static interface MessageHandler {
        public void handleMessage(String var1);

        public void connectionOpened();

        public void connectionClosed();
    }
}

