/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cidsx.client.connector.test;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.github.fge.jackson.JsonLoader;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import com.sun.jersey.core.util.Base64;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanInfo;
import de.cismet.cids.jsonpatch.CidsBeanPatch;
import de.cismet.cids.jsonpatch.CidsBeanPatchUtils;
import de.cismet.cidsx.client.connector.RESTfulInterfaceConnector;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.PropertyResourceBundle;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@RunWith(value=DataProviderRunner.class)
@Ignore
public class RESTfulInterfaceTest
extends RESTfulInterfaceConnector {
    private static String HOST;
    private static String BASIC_AUTH_STRING;
    private static CidsBean DEFAULT_CIDS_BEAN;
    private static RESTfulInterfaceTest INSTANCE;
    private static final ObjectMapper OBJECT_MAPPER;
    private static final ObjectReader OBJECT_READER;
    private static final Logger LOGGER;

    public RESTfulInterfaceTest() throws IOException, Exception {
        super(HOST);
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        PropertyResourceBundle bundle;
        LOGGER.debug((Object)"setUpClass()");
        try {
            bundle = new PropertyResourceBundle(RESTfulInterfaceTest.class.getResourceAsStream("service.properties"));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("could not find local properties file 'service.properties': " + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        Assert.assertNotNull((Object)bundle.getString("host"));
        Assert.assertNotNull((Object)bundle.getString("username"));
        Assert.assertNotNull((Object)bundle.getString("usergroup"));
        Assert.assertNotNull((Object)bundle.getString("domain"));
        Assert.assertNotNull((Object)bundle.getString("password"));
        HOST = bundle.getString("host");
        BASIC_AUTH_STRING = "Basic " + new String(Base64.encode((String)(bundle.getString("username") + "@" + bundle.getString("domain") + ":" + bundle.getString("password"))));
        DevelopmentTools.initSessionManagerFromRestfulConnectionOnLocalhost((String)bundle.getString("domain"), (String)bundle.getString("usergroup"), (String)bundle.getString("username"), (String)bundle.getString("password"), (boolean)true);
        if (INSTANCE == null) {
            INSTANCE = new RESTfulInterfaceTest();
        }
        JsonNode node = JsonLoader.fromURL((URL)RESTfulInterfaceTest.class.getResource("metadata.json"));
        DEFAULT_CIDS_BEAN = RESTfulInterfaceTest.insertDefaultCidsBean(node);
        CidsBean originalBidsBean = CidsBean.createNewCidsBeanFromJSON((boolean)false, (String)node.toString());
        originalBidsBean.setProperty("id", (Object)DEFAULT_CIDS_BEAN.getPrimaryKeyValue());
        try {
            Assert.assertEquals((Object)originalBidsBean.toJSONString(true), (Object)DEFAULT_CIDS_BEAN.toJSONString(true));
        }
        catch (AssertionError ae) {
            LOGGER.error((Object)((Throwable)((Object)ae)).getMessage(), (Throwable)((Object)ae));
            throw ae;
        }
        LOGGER.info((Object)"RESTfulInterfaceTest successfully initialized");
    }

    private WebResource.Builder createAuthorisationHeader(WebResource webResource) throws RemoteException {
        WebResource.Builder builder = webResource.header("Authorization", (Object)BASIC_AUTH_STRING);
        return builder;
    }

    private void deleteDefaultCidsBean() throws RemoteException {
        int objectId = DEFAULT_CIDS_BEAN.getPrimaryKeyValue();
        String className = DEFAULT_CIDS_BEAN.getCidsBeanInfo().getClassKey();
        String domain = DEFAULT_CIDS_BEAN.getCidsBeanInfo().getDomainKey();
        MultivaluedMapImpl queryParameters = new MultivaluedMapImpl();
        WebResource webResource = this.createWebResource("").path(domain + "." + className + "/" + objectId).queryParams((MultivaluedMap)queryParameters);
        WebResource.Builder builder = this.createAuthorisationHeader(webResource);
        builder = this.createMediaTypeHeaders(builder);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("deleteMetaObject '" + objectId + "@" + className + "@" + domain + "' :" + webResource.toString()));
        }
        try {
            builder.delete(ObjectNode.class);
        }
        catch (UniformInterfaceException ue) {
            ClientResponse.Status status = ue.getResponse().getClientResponseStatus();
            String message = "could not delete meta object '" + objectId + "@" + className + "@" + domain + "': " + status.getReasonPhrase();
            LOGGER.error((Object)message, (Throwable)ue);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(ue.getResponse().getEntity(String.class));
            }
            throw new RemoteException(message, ue);
        }
    }

    private CidsBean patchCidsBean(CidsBean cidsBean, CidsBeanPatch patch) throws RemoteException {
        CidsBeanInfo beanInfo = cidsBean.getCidsBeanInfo();
        MultivaluedMapImpl queryParameters = new MultivaluedMapImpl();
        queryParameters.add((Object)"requestResultingInstance", (Object)"true");
        WebResource webResource = INSTANCE.createWebResource("").path(beanInfo.getDomainKey() + "." + beanInfo.getClassKey() + "/" + cidsBean.getPrimaryKeyValue()).queryParams((MultivaluedMap)queryParameters);
        WebResource.Builder builder = INSTANCE.createAuthorisationHeader(webResource);
        builder = INSTANCE.createMediaTypeHeaders(builder);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("patch cids bean for class '" + beanInfo.getDomainKey() + "." + beanInfo.getClassKey() + "': " + webResource.toString()));
        }
        try {
            CidsBean patchedCidsBean;
            JsonNode objectNode = (JsonNode)builder.method("PATCH", ObjectNode.class, (Object)patch);
            if (objectNode == null || objectNode.size() == 0) {
                LOGGER.error((Object)("could not patch cids bean for class '" + beanInfo.getDomainKey() + "." + beanInfo.getClassKey() + "': patched cids bean could not be found"));
                return null;
            }
            try {
                patchedCidsBean = CidsBean.createNewCidsBeanFromJSON((boolean)false, (String)objectNode.toString());
            }
            catch (Exception ex) {
                String message = "could not deserialize cids bean from object node for class '" + beanInfo.getClassKey() + "': " + ex.getMessage();
                LOGGER.error((Object)message, (Throwable)ex);
                throw new RemoteException(message, ex);
            }
            if (patchedCidsBean != null) {
                LOGGER.info((Object)("cids bean with id " + cidsBean.getPrimaryKeyValue() + " patched"));
                return patchedCidsBean;
            }
            LOGGER.error((Object)("could not patch cids bean for class '" + beanInfo.getClassKey() + "@" + beanInfo.getDomainKey() + "': patched cids bean could not be found"));
            return null;
        }
        catch (UniformInterfaceException ue) {
            ClientResponse.Status status = ue.getResponse().getClientResponseStatus();
            String message = "could not patch meta object for class  '" + beanInfo.getClassKey() + "@" + beanInfo.getDomainKey() + "': " + status.getReasonPhrase();
            LOGGER.error((Object)message, (Throwable)ue);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(ue.getResponse().getEntity(String.class));
            }
            throw new RemoteException(message, ue);
        }
    }

    private static CidsBean insertDefaultCidsBean(JsonNode defaultCidsBeanNode) throws RemoteException {
        CidsBeanInfo beanInfo = new CidsBeanInfo(defaultCidsBeanNode.get("$self").textValue());
        MultivaluedMapImpl queryParameters = new MultivaluedMapImpl();
        queryParameters.add((Object)"requestResultingInstance", (Object)"true");
        WebResource webResource = INSTANCE.createWebResource("").path(beanInfo.getDomainKey() + "." + beanInfo.getClassKey()).queryParams((MultivaluedMap)queryParameters);
        WebResource.Builder builder = INSTANCE.createAuthorisationHeader(webResource);
        builder = INSTANCE.createMediaTypeHeaders(builder);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("insertMetaObject for class '" + beanInfo.getDomainKey() + "." + beanInfo.getClassKey() + "': " + webResource.toString()));
        }
        try {
            CidsBean cidsBean;
            JsonNode objectNode = (JsonNode)builder.method("POST", ObjectNode.class, (Object)defaultCidsBeanNode);
            if (objectNode == null || objectNode.size() == 0) {
                LOGGER.error((Object)("could not insert meta object for class '" + beanInfo.getDomainKey() + "." + beanInfo.getClassKey() + "': newly inserted meta object could not be found"));
                return null;
            }
            try {
                cidsBean = CidsBean.createNewCidsBeanFromJSON((boolean)false, (String)objectNode.toString());
            }
            catch (Exception ex) {
                String message = "could not deserialize cids bean from object node for class '" + beanInfo.getClassKey() + "': " + ex.getMessage();
                LOGGER.error((Object)message, (Throwable)ex);
                throw new RemoteException(message, ex);
            }
            if (cidsBean != null) {
                LOGGER.info((Object)("default cids bean with id " + cidsBean.getPrimaryKeyValue() + " created"));
                return cidsBean;
            }
            LOGGER.error((Object)("could not insert meta object for class '" + beanInfo.getClassKey() + "@" + beanInfo.getDomainKey() + "': newly inserted meta object could not be found"));
            return null;
        }
        catch (UniformInterfaceException ue) {
            ClientResponse.Status status = ue.getResponse().getClientResponseStatus();
            String message = "could not insert meta object for class  '" + beanInfo.getClassKey() + "@" + beanInfo.getDomainKey() + "': " + status.getReasonPhrase();
            LOGGER.error((Object)message, (Throwable)ue);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(ue.getResponse().getEntity(String.class));
            }
            throw new RemoteException(message, ue);
        }
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        LOGGER.debug((Object)"tearDownClass()");
        if (DEFAULT_CIDS_BEAN != null) {
            LOGGER.info((Object)("removing cids bean with id " + DEFAULT_CIDS_BEAN.getPrimaryKeyValue() + " created"));
            INSTANCE.deleteDefaultCidsBean();
        } else {
            LOGGER.warn((Object)"defaultCidsBean not found!");
        }
    }

    @Before
    public void setUp() {
        LOGGER.debug((Object)"setUp()");
    }

    @After
    public void tearDown() {
        LOGGER.debug((Object)"tearDown()");
    }

    @Test
    @UseDataProvider(value="getPatches")
    public void testPatches(String comment, CidsBeanPatch patch, CidsBean expected) throws Exception {
        LOGGER.info((Object)("testing patch '" + comment + "'"));
        try {
            expected.setProperty("id", (Object)DEFAULT_CIDS_BEAN.getPrimaryKeyValue());
            DEFAULT_CIDS_BEAN = this.patchCidsBean(DEFAULT_CIDS_BEAN, patch);
            String actualString = DEFAULT_CIDS_BEAN.toJSONString(false);
            String expectedString = expected.toJSONString(false);
            Assert.assertEquals((Object)expectedString, (Object)actualString);
            LOGGER.debug((Object)("patch '" + comment + "' test passed!"));
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (AssertionError ae) {
            LOGGER.error((Object)("patch '" + comment + " test assertion failed: " + ((Throwable)((Object)ae)).getMessage()));
            throw ae;
        }
    }

    @DataProvider
    public static final Object[][] getPatches() throws Exception {
        JsonNode operations = JsonLoader.fromURL((URL)RESTfulInterfaceTest.class.getResource("patches.json"));
        LOGGER.debug((Object)("loading " + operations.size() + " patch operations"));
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Iterator nodeIterator = operations.iterator();
        while (nodeIterator.hasNext()) {
            try {
                JsonNode node = (JsonNode)nodeIterator.next();
                list.add(new Object[]{node.get("comment").asText(), OBJECT_READER.readValue(node.get("patch")), OBJECT_MAPPER.treeToValue((TreeNode)node.get("expected"), CidsBean.class)});
            }
            catch (Exception ex) {
                LOGGER.error((Object)("cannot deserialize beans for patch operations:" + ex.getMessage()), (Throwable)ex);
                throw ex;
            }
        }
        LOGGER.info((Object)(list.size() + " patch operation loaded"));
        return (Object[][])list.toArray((T[])new Object[list.size()][3]);
    }

    protected WebResource createWebResource(String path) {
        String resource = path == null || path.isEmpty() ? this.getRootResource() : ('/' == path.charAt(0) ? this.getRootResource() + path.substring(1, path.length() - 1) : this.getRootResource() + path);
        DefaultApacheHttpClientConfig clientConfig = new DefaultApacheHttpClientConfig();
        clientConfig.getClasses().add(JacksonJsonProvider.class);
        clientConfig.getProperties().put("com.sun.jersey.client.property.httpUrlConnectionSetMethodWorkaround", true);
        ApacheHttpClient client = ApacheHttpClient.create((ClientConfig)clientConfig);
        UriBuilder uriBuilder = UriBuilder.fromPath((String)resource);
        WebResource webResource = client.resource(uriBuilder.build(new Object[0]));
        return webResource;
    }

    static {
        OBJECT_MAPPER = CidsBeanPatchUtils.getInstance().getCidsBeanMapper();
        OBJECT_READER = CidsBeanPatchUtils.getInstance().getCidsBeanMapper().reader().withType(CidsBeanPatch.class);
        LOGGER = Logger.getLogger(RESTfulInterfaceTest.class);
    }
}

