/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.jsonpatch;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonpatch.JsonPatchException;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.jsonpatch.CidsBeanPatch;
import de.cismet.cids.jsonpatch.CidsBeanPatchUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.testng.log4testng.Logger;

@Test
public class CidsBeanPatchTestSuite {
    protected final JsonNode testNode = JsonLoader.fromResource((String)"/de/cismet/cids/jsonpatch/testsuite.json");
    protected final ObjectReader reader = CidsBeanPatchUtils.getInstance().getCidsBeanPatchReader();
    protected static final Logger LOGGER = Logger.getLogger(CidsBeanPatchTestSuite.class);
    protected static final ObjectMapper OBJECT_MAPPER = CidsBeanPatchUtils.getInstance().getCidsBeanMapper();
    protected static final ResourceBundle RESOURCE_BUNDLE = CidsBeanPatchUtils.getInstance().getResourceBundle();

    public CidsBeanPatchTestSuite() throws IOException {
        LOGGER.info((Object)("loading test suite with " + this.testNode.size() + " tests"));
    }

    @DataProvider
    public Iterator<Object[]> getTests() throws Exception {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        String comment = null;
        int i = 0;
        for (JsonNode element : this.testNode) {
            try {
                CidsBean expected;
                if (!element.has("patch")) continue;
                comment = element.hasNonNull("comment") ? element.get("comment").textValue() : (element.hasNonNull("error") ? element.get("error").textValue() : "patch #" + i);
                CidsBeanPatch patch = (CidsBeanPatch)this.reader.readValue(element.get("patch"));
                CidsBean bean = (CidsBean)OBJECT_MAPPER.treeToValue((TreeNode)element.get("bean"), CidsBean.class);
                CidsBean cidsBean = expected = element.hasNonNull("expected") ? (CidsBean)OBJECT_MAPPER.treeToValue((TreeNode)element.get("expected"), CidsBean.class) : null;
                if (expected == null) {
                    expected = bean;
                }
                boolean valid = !element.has("error");
                list.add(new Object[]{comment, bean, patch, expected, valid});
            }
            catch (Exception ex) {
                LOGGER.error((Object)("cannot deserialize beans for patch #" + i + " (" + comment + "): " + ex.getMessage()), (Throwable)ex);
                throw ex;
            }
            finally {
                ++i;
            }
        }
        return list.iterator();
    }

    @Test(dataProvider="getTests")
    public void testsFromTestSuitePass(String comment, CidsBean bean, CidsBeanPatch patch, CidsBean expected, boolean valid) {
        try {
            CidsBean actual = patch.apply(bean);
            if (!valid) {
                Assert.fail((String)(comment + " Test was expected to fail!!"));
                LOGGER.error((Object)(comment + " Test was expected to fail!!"));
            }
            String actualString = actual.toJSONString(true);
            String expectedString = expected.toJSONString(true);
            Assert.assertEquals((String)actualString, (String)expectedString);
        }
        catch (AssertionError ae) {
            LOGGER.error((Object)(comment + "test failed with: " + ((Throwable)((Object)ae)).getMessage()));
            throw ae;
        }
        catch (JsonPatchException ignored) {
            if (valid) {
                LOGGER.error((Object)(comment + " Test was expected to succeed!!"), (Throwable)ignored);
                Assert.fail((String)(comment + " Test was expected to succeed!!"));
            } else {
                LOGGER.debug((Object)(comment + " Test failed as expected: " + ignored.getMessage()));
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)(comment + " Test faild with unexpected exception!!"), (Throwable)ex);
            Assert.fail((String)(comment + " Test faild with unexpected exception!!"));
        }
    }
}

