/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.jsonpatch;

import Sirius.server.middleware.types.MetaClass;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.utils.MetaClassCacheService;
import de.cismet.cidsx.server.api.types.CidsClass;
import de.cismet.cidsx.server.api.types.legacy.CidsClassFactory;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.HashMap;
import java.util.Scanner;
import org.testng.log4testng.Logger;

public class OfflineMetaClassCacheService
implements MetaClassCacheService {
    protected static final HashMap<Integer, MetaClass> allClassesById = new HashMap();
    protected static final HashMap<String, MetaClass> allClassesByTableName = new HashMap();
    protected static final Logger LOGGER = Logger.getLogger(OfflineMetaClassCacheService.class);
    protected static final ObjectMapper MAPPER = new ObjectMapper(new JsonFactory());

    public OfflineMetaClassCacheService() throws Exception {
        if (allClassesById.isEmpty() && allClassesByTableName.isEmpty()) {
            URL resources;
            LOGGER.info((Object)"loading meta classes");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                resources = classLoader.getResource("de/cismet/cids/jsonpatch/classes/");
            }
            catch (Exception ex) {
                LOGGER.error((Object)("could not locate meta class json files: " + ex.getMessage()), (Throwable)ex);
                throw ex;
            }
            Scanner scanner = new Scanner((InputStream)resources.getContent()).useDelimiter("\\n");
            while (scanner.hasNext()) {
                String jsonFile = "de/cismet/cids/jsonpatch/classes/" + scanner.next();
                LOGGER.info((Object)("loading cids class from json file " + jsonFile));
                try {
                    CidsClass cidsClass = (CidsClass)MAPPER.readValue((Reader)new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(jsonFile))), CidsClass.class);
                    LOGGER.debug((Object)(cidsClass.getKey() + " deserialized"));
                    MetaClass metaClass = CidsClassFactory.getFactory().legacyCidsClassFromRestCidsClass(cidsClass);
                    allClassesById.put(metaClass.getId(), metaClass);
                    allClassesByTableName.put(metaClass.getTableName(), metaClass);
                }
                catch (Exception ex) {
                    LOGGER.error((Object)("could not deserialize cids class from url " + jsonFile), (Throwable)ex);
                    throw ex;
                }
            }
        } else {
            LOGGER.info((Object)"meta classes already loaded");
        }
    }

    public MetaClass getMetaClass(String domain, String tableName) {
        return this.getMetaClass(domain, tableName, ConnectionContext.createDeprecated());
    }

    public MetaClass getMetaClass(String domain, int classId) {
        return this.getMetaClass(domain, classId, ConnectionContext.createDeprecated());
    }

    public HashMap<String, MetaClass> getAllClasses(String domain) {
        return this.getAllClasses(domain, ConnectionContext.createDeprecated());
    }

    public MetaClass getMetaClass(String domain, String tableName, ConnectionContext connectionContext) {
        return allClassesByTableName.get(tableName);
    }

    public MetaClass getMetaClass(String domain, int classId, ConnectionContext connectionContext) {
        return allClassesById.get(classId);
    }

    public HashMap getAllClasses(String domain, ConnectionContext connectionContext) {
        HashMap<CallSite, MetaClass> allClasses = new HashMap<CallSite, MetaClass>();
        for (Integer classId : allClassesById.keySet()) {
            String classKey = domain + classId;
            allClasses.put((CallSite)((Object)classKey), allClassesById.get(classId));
        }
        return allClasses;
    }
}

