/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.jsonpatch.operation;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonpatch.JsonPatchException;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.jsonpatch.CidsBeanPatchUtils;
import de.cismet.cids.jsonpatch.operation.CidsBeanPatchOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.testng.log4testng.Logger;

public abstract class CidsBeanPatchOperationTest {
    protected final JsonNode errors;
    protected final JsonNode ops;
    protected final ObjectReader reader;
    protected static final Logger LOGGER = Logger.getLogger(CidsBeanPatchOperationTest.class);
    protected final String operationName;
    protected static final ObjectMapper OBJECT_MAPPER = CidsBeanPatchUtils.getInstance().getCidsBeanMapper();
    protected static final ResourceBundle RESOURCE_BUNDLE = CidsBeanPatchUtils.getInstance().getResourceBundle();

    protected CidsBeanPatchOperationTest(String operationName) throws IOException {
        try {
            this.operationName = operationName;
            String resource = "/de/cismet/cids/jsonpatch/operation/" + operationName + ".json";
            JsonNode node = JsonLoader.fromResource((String)resource);
            this.errors = node.get("errors");
            this.ops = node.get("ops");
            this.reader = CidsBeanPatchUtils.getInstance().getCidsBeanMapper().reader().withType(CidsBeanPatchOperation.class);
            LOGGER.info((Object)(this.errors.size() + " error tests and " + this.ops.size() + " operation tests available for operation '" + operationName + "'"));
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex.getMessage());
            throw ex;
        }
    }

    @DataProvider
    public final Iterator<Object[]> getErrors() throws Exception {
        LOGGER.debug((Object)("loading " + this.errors.size() + " '" + this.operationName + "' error tests"));
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (JsonNode node : this.errors) {
            try {
                list.add(new Object[]{node.get("op"), OBJECT_MAPPER.treeToValue((TreeNode)node.get("bean"), CidsBean.class), RESOURCE_BUNDLE.getString(node.get("message").textValue())});
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        LOGGER.info((Object)(list.size() + " '" + this.operationName + "' operation error tests loaded"));
        return list.iterator();
    }

    @Test(dataProvider="getErrors")
    public final void errorsAreCorrectlyReported(JsonNode patch, CidsBean cidsBean, String message) throws IOException, JsonPatchException {
        try {
            CidsBeanPatchOperation op = (CidsBeanPatchOperation)this.reader.readValue(patch);
            LOGGER.info((Object)("testing '" + this.operationName + "' operation error: " + op.toString()));
            op.apply(cidsBean);
            LOGGER.error((Object)("No exception thrown for operation " + op.toString()));
            Assert.fail((String)("No exception thrown for operation " + op.toString()));
        }
        catch (JsonPatchException e) {
            LOGGER.debug((Object)("JsonPatchException thrown: " + e.getMessage()));
            Assert.assertEquals((String)e.getMessage(), (String)message);
        }
        catch (Throwable t) {
            LOGGER.error((Object)("testing '" + this.operationName + " failed: " + t.getMessage()), t);
            throw t;
        }
    }

    @DataProvider
    public final Iterator<Object[]> getOps() throws Exception {
        LOGGER.debug((Object)("loading " + this.ops.size() + " '" + this.operationName + "' success tests"));
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (JsonNode node : this.ops) {
            try {
                list.add(new Object[]{this.reader.readValue(node.get("op")), OBJECT_MAPPER.treeToValue((TreeNode)node.get("bean"), CidsBean.class), OBJECT_MAPPER.treeToValue((TreeNode)node.get("expected"), CidsBean.class)});
            }
            catch (Exception ex) {
                LOGGER.error((Object)("cannot deserialize beans for operation '" + this.operationName + "':" + ex.getMessage()), (Throwable)ex);
                throw ex;
            }
        }
        LOGGER.info((Object)(list.size() + " '" + this.operationName + "' operation success tests loaded"));
        return list.iterator();
    }

    @Test(dataProvider="getOps")
    public final void operationsYieldExpectedResults(CidsBeanPatchOperation op, CidsBean cidsBean, CidsBean expected) throws Exception {
        LOGGER.info((Object)("testing '" + this.operationName + "' operation: " + op.toString()));
        try {
            CidsBean actual = op.apply(cidsBean);
            String actualString = actual.toJSONString(true);
            String expectedString = expected.toJSONString(true);
            Assert.assertEquals((String)actualString, (String)expectedString);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (AssertionError ae) {
            LOGGER.error((Object)(op.toString() + " failed"));
            throw ae;
        }
    }
}

