/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.operation.JsonPatchOperation;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.jsonpatch.operation.CidsBeanPatchOperation;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class CidsBeanPatch
implements JsonSerializable {
    protected final List<CidsBeanPatchOperation> operations;

    @JsonCreator
    public CidsBeanPatch(List<CidsBeanPatchOperation> operations) {
        this.operations = Collections.unmodifiableList(operations);
    }

    public CidsBean apply(CidsBean cidsBean) throws JsonPatchException {
        CidsBean ret = cidsBean;
        for (CidsBeanPatchOperation operation : this.operations) {
            ret = operation.apply(cidsBean);
        }
        return ret;
    }

    public String toString() {
        return this.operations.toString();
    }

    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartArray();
        for (JsonPatchOperation jsonPatchOperation : this.operations) {
            jsonPatchOperation.serialize(jgen, provider);
        }
        jgen.writeEndArray();
    }

    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(jgen, provider);
    }

    public List<CidsBeanPatchOperation> getOperations() {
        return this.operations;
    }
}

