/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.jsonpatch;

import Sirius.server.localserver.attribute.ObjectAttribute;
import Sirius.server.middleware.types.MetaObject;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonpatch.JsonPatchException;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.WKTReader;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanInfo;
import de.cismet.cids.dynamics.CidsBeanJsonDeserializer;
import de.cismet.cids.dynamics.CidsBeanJsonSerializer;
import de.cismet.cids.jsonpatch.CidsBeanPatch;
import de.cismet.cids.jsonpatch.operation.cidsbean.AddOperation;
import de.cismet.cids.jsonpatch.operation.cidsbean.CopyOperation;
import de.cismet.cids.jsonpatch.operation.cidsbean.MoveOperation;
import de.cismet.cids.jsonpatch.operation.cidsbean.RemoveOperation;
import de.cismet.cids.jsonpatch.operation.cidsbean.ReplaceOperation;
import de.cismet.cids.jsonpatch.operation.cidsbean.TestOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class CidsBeanPatchUtils {
    protected static final CidsBeanPatchUtils INSTANCE = new CidsBeanPatchUtils();
    protected final ObjectMapper cidsBeanMapper = new ObjectMapper();
    protected final ObjectReader cidsBeanPatchReader;
    protected final ResourceBundle resourceBundle = PropertyResourceBundle.getBundle("de.cismet.cids.jsonpatch.messages");

    protected CidsBeanPatchUtils() {
        this.cidsBeanMapper.enable(SerializationFeature.INDENT_OUTPUT);
        SimpleModule regularModule = new SimpleModule("NOIOC", new Version(1, 0, 0, null, null, null));
        regularModule.addSerializer((JsonSerializer)new CidsBeanJsonSerializer());
        regularModule.addDeserializer(CidsBean.class, (JsonDeserializer)new CidsBeanJsonDeserializer());
        this.cidsBeanMapper.registerModule((Module)regularModule);
        this.cidsBeanMapper.registerSubtypes(new NamedType[]{new NamedType(AddOperation.class, "add"), new NamedType(CopyOperation.class, "copy"), new NamedType(MoveOperation.class, "move"), new NamedType(RemoveOperation.class, "remove"), new NamedType(ReplaceOperation.class, "replace"), new NamedType(TestOperation.class, "test")});
        this.cidsBeanPatchReader = this.cidsBeanMapper.reader().withType(CidsBeanPatch.class);
    }

    public static CidsBeanPatchUtils getInstance() {
        return INSTANCE;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public String jsonPointerToCidsBeanPointer(JsonPointer jsonPointer) {
        StringBuilder pathBuilder = new StringBuilder();
        Iterator iterator = jsonPointer.iterator();
        while (iterator.hasNext()) {
            TokenResolver resolver = (TokenResolver)iterator.next();
            int arrayIndex = CidsBeanPatchUtils.arrayIndexFor(resolver.getToken().getRaw());
            if (arrayIndex != -1) {
                if (pathBuilder.length() > 0 && pathBuilder.charAt(pathBuilder.length() - 1) == '.') {
                    pathBuilder.deleteCharAt(pathBuilder.length() - 1);
                }
                pathBuilder.append('[').append(arrayIndex).append(']');
            } else {
                pathBuilder.append(resolver.getToken().getRaw());
            }
            if (!iterator.hasNext()) continue;
            pathBuilder.append('.');
        }
        return pathBuilder.toString();
    }

    public ObjectMapper getCidsBeanMapper() {
        return this.cidsBeanMapper;
    }

    public ObjectReader getCidsBeanPatchReader() {
        return this.cidsBeanPatchReader;
    }

    protected static int arrayIndexFor(String raw) {
        if (raw.isEmpty()) {
            return -1;
        }
        if (raw.charAt(0) == '0') {
            return raw.length() == 1 ? 0 : -1;
        }
        try {
            return Integer.parseInt(raw);
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }

    public CidsBean jsonNodeToCidsBean(JsonNode node) throws JsonPatchException {
        try {
            CidsBean cidsBean = CidsBean.createNewCidsBeanFromJSON((boolean)false, (String)node.toString());
            return cidsBean;
        }
        catch (Exception ex) {
            throw new JsonPatchException(this.resourceBundle.getString("jsonPatch.deserBeanFailed"), (Throwable)ex);
        }
    }

    public List<CidsBean> jsonNodeArrayToCidsBeanArray(JsonNode node) throws JsonPatchException {
        if (this.isCidsBeanArray(node)) {
            ArrayList<CidsBean> beanList = new ArrayList<CidsBean>();
            Iterator nodeIterator = ((ArrayNode)node).elements();
            while (nodeIterator.hasNext()) {
                JsonNode arrayElementNode = (JsonNode)nodeIterator.next();
                beanList.add(this.jsonNodeToCidsBean(arrayElementNode));
            }
            return beanList;
        }
        throw new JsonPatchException(this.resourceBundle.getString("jsonPatch.valueNoArray"));
    }

    public JsonNode cidsBeanToJsonNode(CidsBean cidsBean) throws JsonPatchException {
        String json = cidsBean.toJSONString(false);
        try {
            JsonNode node = CidsBeanPatchUtils.getInstance().getCidsBeanMapper().readTree(json);
            return node;
        }
        catch (IOException ex) {
            throw new JsonPatchException(this.resourceBundle.getString("jsonPatch.serBeanFailed"), (Throwable)ex);
        }
    }

    protected JsonNode cidsBeanToJsonNodeOrReference(CidsBean cidsBean) throws JsonPatchException {
        if (cidsBean.hasArtificialChangeFlag() || cidsBean.getMetaObject().getStatus() != 0) {
            return this.cidsBeanToJsonNode(cidsBean);
        }
        return this.cidsBeanToJsonNodeReference(cidsBean);
    }

    protected JsonNode cidsBeanToJsonNodeReference(CidsBean cidsBean) throws JsonPatchException {
        CidsBeanInfo cidsBeanInfo = cidsBean.getCidsBeanInfo();
        if (cidsBeanInfo.getObjectKey().equals("-1")) {
            throw new JsonPatchException(this.resourceBundle.getString("jsonPatch.valueNoReferenceBean"));
        }
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        node.put("$ref", cidsBeanInfo.getJsonObjectKey());
        return node;
    }

    public boolean isCidsBean(JsonNode node) {
        return node.isObject() && (node.hasNonNull("$self") || node.hasNonNull("$ref"));
    }

    public boolean isCidsBeanArray(JsonNode node) {
        if (node.isArray()) {
            Iterator nodeIterator = ((ArrayNode)node).elements();
            while (nodeIterator.hasNext()) {
                JsonNode arrayElementNode = (JsonNode)nodeIterator.next();
                if (this.isCidsBean(arrayElementNode)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isCidsBeanReference(JsonNode node) {
        return node.isObject() && node.hasNonNull("$ref");
    }

    public Object deserializeAndVerifyCidsBean(JsonNode value) throws JsonPatchException {
        if (this.isCidsBean(value)) {
            if (this.isCidsBeanReference(value)) {
                CidsBeanInfo cidsBeanInfo = new CidsBeanInfo(value.get("$ref").textValue());
                if (cidsBeanInfo.getObjectKey().equals("-1") || value.size() != 1) {
                    throw new JsonPatchException(this.resourceBundle.getString("jsonPatch.valueNoReferenceBean"));
                }
                CidsBean cidsBean = this.jsonNodeToCidsBean(value);
                cidsBean.getMetaObject().setStatus(0);
                return cidsBean;
            }
            CidsBean cidsBean = this.jsonNodeToCidsBean(value);
            this.applyCidsBeanUpdateStatus(cidsBean, true);
            return cidsBean;
        }
        if (this.isCidsBeanArray(value)) {
            ArrayList<CidsBean> beanList = new ArrayList<CidsBean>();
            Iterator nodeIterator = ((ArrayNode)value).elements();
            while (nodeIterator.hasNext()) {
                JsonNode arrayElementNode = (JsonNode)nodeIterator.next();
                Object arrayElement = this.deserializeAndVerifyCidsBean(arrayElementNode);
                if (arrayElement != null && CidsBean.class.isAssignableFrom(arrayElement.getClass())) {
                    CidsBean cidsBean = (CidsBean)arrayElement;
                    beanList.add(cidsBean);
                    continue;
                }
                throw new JsonPatchException(this.resourceBundle.getString("jsonPatch.invalidArrayElement"));
            }
            return beanList;
        }
        if (value.isValueNode()) {
            ValueNode valueNode = (ValueNode)value;
            return valueNode;
        }
        throw new JsonPatchException(this.resourceBundle.getString("jsonPatch.invalidValue"));
    }

    public void applyCidsBeanUpdateStatus(CidsBean cidsBean, boolean setChanged) {
        this.applyMetaObjectUpdateStatus(cidsBean.getMetaObject(), setChanged);
    }

    protected void applyMetaObjectUpdateStatus(MetaObject metaObject, boolean setChanged) {
        if (metaObject.getID() == -1) {
            metaObject.setStatus(1);
        } else if (setChanged) {
            metaObject.setStatus(2);
        }
        for (ObjectAttribute objectAttribute : metaObject.getAttribs()) {
            if (!objectAttribute.referencesObject() || objectAttribute.getValue() == null) continue;
            MetaObject attributeMetaObject = (MetaObject)objectAttribute.getValue();
            attributeMetaObject.setChanged(true);
            this.applyMetaObjectUpdateStatus(attributeMetaObject, setChanged);
        }
    }

    public Geometry fromEwkt(String ewkt) throws Exception {
        int srid;
        String wkt;
        int skIndex = ewkt.indexOf(59);
        if (skIndex > 0) {
            String sridKV = ewkt.substring(0, skIndex);
            int eqIndex = sridKV.indexOf(61);
            wkt = ewkt.substring(skIndex + 1);
            srid = Integer.parseInt(sridKV.substring(eqIndex + 1));
        } else {
            wkt = ewkt;
            srid = -1;
        }
        Geometry geom = new WKTReader(new GeometryFactory()).read(wkt);
        if (srid >= 0) {
            geom.setSRID(srid);
        }
        return geom;
    }
}

