/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.jsonpatch.operation.cidsbean;

import Sirius.server.localserver.attribute.ObjectAttribute;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.operation.ReplaceOperation;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.jsonpatch.CidsBeanPatchUtils;
import de.cismet.cids.jsonpatch.operation.CidsBeanPatchOperation;
import de.cismet.commons.classloading.BlacklistClassloading;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class AddOperation
extends com.github.fge.jsonpatch.operation.AddOperation
implements CidsBeanPatchOperation {
    protected static final Logger LOGGER = Logger.getLogger(AddOperation.class);
    protected static final CidsBeanPatchUtils UTILS = CidsBeanPatchUtils.getInstance();
    protected static final ResourceBundle RESOURCE_BUNDLE = UTILS.getResourceBundle();
    @JsonIgnore
    protected final ReplaceOperation jsonPatchReplaceOperation;
    @JsonIgnore
    protected final boolean overwrite;

    @JsonCreator
    public AddOperation(@JsonProperty(value="path") JsonPointer path, @JsonProperty(value="value") JsonNode value) {
        this(path, value, false);
    }

    protected AddOperation(JsonPointer path, JsonNode value, boolean overwrite) {
        super(path, value);
        this.overwrite = overwrite;
        this.jsonPatchReplaceOperation = this.overwrite ? new ReplaceOperation(path, value) : null;
    }

    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.overwrite) {
            return this.jsonPatchReplaceOperation.apply(node);
        }
        return super.apply(node);
    }

    @Override
    public CidsBean apply(CidsBean cidsBean) throws JsonPatchException {
        if (this.value == null || this.value.isMissingNode()) {
            throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.nullValue"));
        }
        String cidsBeanPointer = UTILS.jsonPointerToCidsBeanPointer(this.path);
        if (cidsBeanPointer == null || cidsBeanPointer.isEmpty()) {
            throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.rootNodeNotPermitted"));
        }
        String cidsBeanParentPointer = UTILS.jsonPointerToCidsBeanPointer(this.path.parent());
        Object parentObject = cidsBeanParentPointer != null && !cidsBeanParentPointer.isEmpty() ? cidsBean.getProperty(cidsBeanParentPointer) : cidsBean;
        if (parentObject == null) {
            throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.noSuchParent"));
        }
        if (List.class.isAssignableFrom(parentObject.getClass())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("performing add to array " + this.path.toString()));
            }
            this.addToArray((List)parentObject);
            return cidsBean;
        }
        if (CidsBean.class.isAssignableFrom(parentObject.getClass())) {
            this.addToObject((CidsBean)parentObject);
            return cidsBean;
        }
        throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.parentNotContainer"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addToArray(List parentList) throws JsonPatchException {
        int index;
        TokenResolver token = (TokenResolver)AddOperation.getLast(this.path);
        if (token.getToken().equals((Object)LAST_ARRAY_ELEMENT)) {
            if (UTILS.isCidsBeanArray(this.value)) {
                List beanList = (List)UTILS.deserializeAndVerifyCidsBean(this.value);
                if (this.overwrite) {
                    ListIterator<CidsBean> listIterator = parentList.listIterator();
                    while (listIterator.hasNext()) {
                        CidsBean listCidsBean = (CidsBean)listIterator.next();
                        for (CidsBean replacmentBean : beanList) {
                            if (!replacmentBean.getCidsBeanInfo().getJsonObjectKey().equals(listCidsBean.getCidsBeanInfo().getJsonObjectKey())) continue;
                            listIterator.set(replacmentBean);
                        }
                    }
                    return;
                } else {
                    parentList.addAll(beanList);
                }
                return;
            } else {
                if (!UTILS.isCidsBean(this.value)) throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.invalidValueForArray"));
                CidsBean cidsBean = (CidsBean)UTILS.deserializeAndVerifyCidsBean(this.value);
                if (this.overwrite) {
                    ListIterator<CidsBean> listIterator = parentList.listIterator();
                    while (listIterator.hasNext()) {
                        CidsBean listCidsBean = (CidsBean)listIterator.next();
                        if (!cidsBean.getCidsBeanInfo().getJsonObjectKey().equals(listCidsBean.getCidsBeanInfo().getJsonObjectKey())) continue;
                        listIterator.set(cidsBean);
                    }
                    return;
                } else {
                    parentList.add(cidsBean);
                }
            }
            return;
        }
        int size = parentList.size();
        try {
            index = Integer.parseInt(token.toString());
        }
        catch (NumberFormatException ex) {
            LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.notAnIndex") + ": " + ex.getMessage()), (Throwable)ex);
            throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.notAnIndex"), (Throwable)ex);
        }
        if (index < 0 || index > size) {
            LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.notAnIndex") + ": " + index + " (array size: " + size + ")"));
            throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.noSuchIndex"));
        }
        if (UTILS.isCidsBean(this.value)) {
            CidsBean cidsBean = (CidsBean)UTILS.deserializeAndVerifyCidsBean(this.value);
            if (this.overwrite) {
                parentList.set(index, cidsBean);
                return;
            } else {
                parentList.add(index, cidsBean);
            }
            return;
        } else {
            if (UTILS.isCidsBeanArray(this.value)) {
                LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.invalidValueForArrayIndex") + ": arrays cannot be used as value in conjunction with an array index"));
                throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.invalidValueForArrayIndex"));
            }
            LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.invalidValueForArrayIndex") + ": " + String.valueOf(this.value)));
            throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.invalidValueForArrayIndex"));
        }
    }

    public static <T> T getLast(Iterable<T> iterable) {
        if (iterable instanceof List) {
            List list = (List)iterable;
            if (list.isEmpty()) {
                throw new NoSuchElementException();
            }
            return (T)list.get(list.size() - 1);
        }
        Iterator<T> it = iterable.iterator();
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        T last = it.next();
        while (it.hasNext()) {
            last = it.next();
        }
        return last;
    }

    protected void addToObject(CidsBean parentBean) throws JsonPatchException {
        block31: {
            String property = ((TokenResolver)AddOperation.getLast(this.path)).getToken().getRaw();
            ObjectAttribute objectAttribute = parentBean.getMetaObject().getAttributeByFieldName(property);
            if (objectAttribute == null) {
                LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.noSuchProperty") + ": " + this.path.toString()));
                throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.noSuchProperty"));
            }
            Object valueObject = UTILS.deserializeAndVerifyCidsBean(this.value);
            if (CidsBean.class.isAssignableFrom(valueObject.getClass())) {
                if (!objectAttribute.getMai().isForeignKey()) {
                    LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.propertyValueMissmatch") + ": cids bean provided but not expected at " + this.path.toString()));
                    throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.propertyValueMissmatch"));
                }
                if (!this.overwrite && parentBean.getProperty(property) != null) {
                    LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.propertyNotEmpty") + ": " + property));
                    throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.propertyNotEmpty"));
                }
                try {
                    parentBean.setProperty(property, (Object)((CidsBean)valueObject));
                }
                catch (Exception ex) {
                    LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.setPropertyFailed") + ": " + property), (Throwable)ex);
                    throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.setPropertyFailed"), (Throwable)ex);
                }
            }
            if (List.class.isAssignableFrom(valueObject.getClass())) {
                List beanCollectionProperty = parentBean.getBeanCollectionProperty(property);
                if (!objectAttribute.getMai().isArray() || beanCollectionProperty == null) {
                    LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.propertyValueMissmatch") + ": cids bean array provided but not expected at " + this.path.toString()));
                    throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.propertyValueMissmatch"));
                }
                if (!this.overwrite && !beanCollectionProperty.isEmpty()) {
                    LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.propertyNotEmpty") + ": array " + property + "size: " + beanCollectionProperty.size()));
                    throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.propertyNotEmpty"));
                }
                if (this.overwrite) {
                    beanCollectionProperty.clear();
                    beanCollectionProperty.addAll((List)valueObject);
                } else {
                    beanCollectionProperty.addAll((List)valueObject);
                }
            } else if (ValueNode.class.isAssignableFrom(valueObject.getClass())) {
                if (!this.overwrite && parentBean.getProperty(property) != null) {
                    LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.propertyNotEmpty") + ": " + property));
                    throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.propertyNotEmpty"));
                }
                Class attrClass = BlacklistClassloading.forName((String)objectAttribute.getMai().getJavaclassname());
                if (attrClass == null) {
                    LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.noSuchProperty") + ": " + this.path.toString()));
                    throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.noSuchProperty"));
                }
                ValueNode valueNode = (ValueNode)valueObject;
                try {
                    if (valueNode.isNumber()) {
                        if (attrClass.equals(Integer.class)) {
                            int i = valueNode.asInt();
                            parentBean.setProperty(property, (Object)i);
                            break block31;
                        }
                        if (attrClass.equals(Long.class)) {
                            long l = valueNode.asLong();
                            parentBean.setProperty(property, (Object)l);
                            break block31;
                        }
                        if (attrClass.equals(Float.class)) {
                            float f = (float)valueNode.asDouble();
                            parentBean.setProperty(property, (Object)Float.valueOf(f));
                            break block31;
                        }
                        if (attrClass.equals(Double.class)) {
                            double d = valueNode.asDouble();
                            parentBean.setProperty(property, (Object)d);
                            break block31;
                        }
                        if (attrClass.equals(Timestamp.class)) {
                            Timestamp ts = new Timestamp(valueNode.asLong());
                            parentBean.setProperty(property, (Object)ts);
                            break block31;
                        }
                        if (attrClass.equals(BigDecimal.class)) {
                            BigDecimal bd = new BigDecimal(valueNode.asText());
                            parentBean.setProperty(property, (Object)bd);
                            break block31;
                        }
                        throw new Exception("no numeric handler available for class " + attrClass.getSimpleName());
                    }
                    if (valueNode.isBoolean()) {
                        boolean bl = valueNode.asBoolean();
                        parentBean.setProperty(property, (Object)bl);
                        break block31;
                    }
                    if (valueNode.isMissingNode() || NullNode.class.isAssignableFrom(valueNode.getClass())) {
                        parentBean.setProperty(property, null);
                        break block31;
                    }
                    if (valueNode.isTextual()) {
                        String str = valueNode.textValue();
                        if (attrClass.equals(Geometry.class)) {
                            Geometry geom = UTILS.fromEwkt(str);
                            parentBean.setProperty(property, (Object)geom);
                        } else if (attrClass.equals(String.class)) {
                            parentBean.setProperty(property, (Object)str);
                        } else {
                            LOGGER.warn((Object)("expected geometry or string property but got " + attrClass.getSimpleName()));
                            parentBean.setProperty(property, (Object)str);
                        }
                        break block31;
                    }
                    throw new Exception("no handler available for value " + valueNode.toString());
                }
                catch (Exception ex) {
                    LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.setPropertyFailed") + ": " + property), (Throwable)ex);
                    throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.setPropertyFailed"), (Throwable)ex);
                }
            }
        }
    }
}

