/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.jsonpatch.operation.cidsbean;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchException;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.jsonpatch.CidsBeanPatchUtils;
import de.cismet.cids.jsonpatch.operation.CidsBeanPatchOperation;
import de.cismet.cids.jsonpatch.operation.cidsbean.AddOperation;
import java.util.List;
import java.util.ResourceBundle;

public class CopyOperation
extends com.github.fge.jsonpatch.operation.CopyOperation
implements CidsBeanPatchOperation {
    protected static final CidsBeanPatchUtils UTILS = CidsBeanPatchUtils.getInstance();
    protected static final ResourceBundle RESOURCE_BUNDLE = UTILS.getResourceBundle();

    @JsonCreator
    public CopyOperation(@JsonProperty(value="from") JsonPointer from, @JsonProperty(value="path") JsonPointer path) {
        super(from, path);
    }

    @Override
    public CidsBean apply(CidsBean cidsBean) throws JsonPatchException {
        JsonNode value;
        String cidsBeanToPointer = UTILS.jsonPointerToCidsBeanPointer(this.path);
        String cidsBeanFromPointer = UTILS.jsonPointerToCidsBeanPointer(this.from);
        if (cidsBeanToPointer == null || cidsBeanToPointer.isEmpty() || cidsBeanFromPointer == null || cidsBeanFromPointer.isEmpty()) {
            throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.rootNodeNotPermitted"));
        }
        Object copyObject = cidsBean.getProperty(cidsBeanFromPointer);
        if (copyObject == null) {
            throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.nullValue"));
        }
        if (CidsBean.class.isAssignableFrom(copyObject.getClass())) {
            value = UTILS.cidsBeanToJsonNode((CidsBean)copyObject);
        } else if (List.class.isAssignableFrom(copyObject.getClass())) {
            value = JsonNodeFactory.instance.arrayNode();
            for (CidsBean listEntry : (List)copyObject) {
                ((ArrayNode)value).add(UTILS.cidsBeanToJsonNode(listEntry));
            }
        } else {
            value = UTILS.getCidsBeanMapper().valueToTree(copyObject);
        }
        return new AddOperation(this.path, value).apply(cidsBean);
    }
}

