/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.jsonpatch.operation.cidsbean;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchException;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.jsonpatch.CidsBeanPatchUtils;
import de.cismet.cids.jsonpatch.operation.CidsBeanPatchOperation;
import de.cismet.cids.jsonpatch.operation.cidsbean.AddOperation;
import de.cismet.cids.jsonpatch.operation.cidsbean.RemoveOperation;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class MoveOperation
extends com.github.fge.jsonpatch.operation.MoveOperation
implements CidsBeanPatchOperation {
    protected static final CidsBeanPatchUtils UTILS = CidsBeanPatchUtils.getInstance();
    protected static final ResourceBundle RESOURCE_BUNDLE = UTILS.getResourceBundle();
    protected static final Logger LOGGER = Logger.getLogger(MoveOperation.class);

    @JsonCreator
    public MoveOperation(@JsonProperty(value="from") JsonPointer from, @JsonProperty(value="path") JsonPointer path) {
        super(from, path);
    }

    @Override
    public CidsBean apply(CidsBean cidsBean) throws JsonPatchException {
        JsonNode value;
        if (this.from.equals((Object)this.path)) {
            return cidsBean;
        }
        if (this.path.toString().indexOf(this.from.toString()) == 0) {
            LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.invalidFromPath") + ": from=" + String.valueOf(this.from) + ", to=" + String.valueOf(this.path)));
            throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.invalidFromPath"));
        }
        String cidsBeanToPointer = UTILS.jsonPointerToCidsBeanPointer(this.path);
        String cidsBeanFromPointer = UTILS.jsonPointerToCidsBeanPointer(this.from);
        if (cidsBeanToPointer == null || cidsBeanToPointer.isEmpty() || cidsBeanFromPointer == null || cidsBeanFromPointer.isEmpty()) {
            throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.rootNodeNotPermitted"));
        }
        Object moveObject = cidsBean.getProperty(cidsBeanFromPointer);
        if (moveObject == null) {
            LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.nullValue") + ": " + cidsBeanFromPointer));
            throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.nullValue"));
        }
        if (CidsBean.class.isAssignableFrom(moveObject.getClass())) {
            value = UTILS.cidsBeanToJsonNode((CidsBean)moveObject);
        } else if (List.class.isAssignableFrom(moveObject.getClass())) {
            value = JsonNodeFactory.instance.arrayNode();
            for (CidsBean listEntry : (List)moveObject) {
                ((ArrayNode)value).add(UTILS.cidsBeanToJsonNode(listEntry));
            }
        } else {
            value = UTILS.getCidsBeanMapper().valueToTree(moveObject);
        }
        RemoveOperation removeOperation = new RemoveOperation(this.from);
        AddOperation addOperation = new AddOperation(this.path, value);
        return addOperation.apply(removeOperation.apply(cidsBean));
    }
}

