/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.jsonpatch.operation.cidsbean;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchException;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.jsonpatch.CidsBeanPatchUtils;
import de.cismet.cids.jsonpatch.operation.CidsBeanPatchOperation;
import de.cismet.cids.jsonpatch.operation.cidsbean.AddOperation;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class RemoveOperation
extends com.github.fge.jsonpatch.operation.RemoveOperation
implements CidsBeanPatchOperation {
    protected static final Logger LOGGER = Logger.getLogger(AddOperation.class);
    protected static final CidsBeanPatchUtils UTILS = CidsBeanPatchUtils.getInstance();
    protected static final ResourceBundle RESOURCE_BUNDLE = UTILS.getResourceBundle();

    @JsonCreator
    public RemoveOperation(@JsonProperty(value="path") JsonPointer path) {
        super(path);
    }

    @Override
    public CidsBean apply(CidsBean cidsBean) throws JsonPatchException {
        String cidsBeanPointer = UTILS.jsonPointerToCidsBeanPointer(this.path);
        if (cidsBeanPointer == null || cidsBeanPointer.isEmpty()) {
            throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.rootNodeNotPermitted"));
        }
        String cidsBeanParentPointer = UTILS.jsonPointerToCidsBeanPointer(this.path.parent());
        Object parentObject = cidsBeanParentPointer != null && !cidsBeanParentPointer.isEmpty() ? cidsBean.getProperty(cidsBeanParentPointer) : cidsBean;
        if (parentObject == null) {
            throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.noSuchParent"));
        }
        Object removeObject = cidsBean.getProperty(cidsBeanPointer);
        if (removeObject == null) {
            LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.noSuchProperty") + ": " + cidsBeanPointer));
            throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.noSuchProperty"));
        }
        if (List.class.isAssignableFrom(parentObject.getClass())) {
            boolean removed = ((List)parentObject).remove(removeObject);
            if (!removed) {
                throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.removeFromArrayFailed"));
            }
            return cidsBean;
        }
        if (CidsBean.class.isAssignableFrom(parentObject.getClass())) {
            try {
                cidsBean.setProperty(cidsBeanPointer, null);
            }
            catch (Exception ex) {
                LOGGER.error((Object)(RESOURCE_BUNDLE.getString("jsonPatch.removePropertyFailed") + ": " + cidsBeanPointer), (Throwable)ex);
                throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.removePropertyFailed"), (Throwable)ex);
            }
            return cidsBean;
        }
        throw new JsonPatchException(RESOURCE_BUNDLE.getString("jsonPatch.parentNotContainer"));
    }
}

