/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 *  Copyright (C) 2011 jweintraut
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * SetHintDialog.java
 *
 * Created on 03.03.2011, 08:40:42
 */
package de.cismet.cids.custom.actions.wrrl_db_mv;

import org.openide.util.NbBundle;

import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * This dialog accompanies the SetHintAction in this package. It will show a user dialog asking for a name, a comment
 * and a priority for the hint which is to be added for a certain PureNewFeature.
 *
 * <p>The class GEO_HINT additionally requires a username and a creation time, but those will be added by SetHintAction
 * automatically, hence there is no possibility for the user to enter those information.</p>
 *
 * @author   jweintraut
 * @version  $Revision$, $Date$
 */
public class SetHintDialog extends javax.swing.JDialog {

    //~ Enums ------------------------------------------------------------------

    /**
     * An enum representing the three entities of class PRIORITY. The chance those entities will ever change is very
     * small, so these entities are hardcoded here.
     *
     * @version  $Revision$, $Date$
     */
    public enum Priority {

        //~ Enum constants -----------------------------------------------------

        LOW, NORMAL, HIGH;

        //~ Methods ------------------------------------------------------------

        @Override
        public String toString() {
            if (LOW.equals(this)) {
                return "Niedrig";
            } else if (NORMAL.equals(this)) {
                return "Normal";
            } else {
                return "Hoch";
            }
        }
    }

    //~ Instance fields --------------------------------------------------------

    private String nameProperty;
    private String commentProperty;
    private Priority priorityProperty;
    private boolean wasCancelled;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCancel;
    private javax.swing.JButton btnOK;
    private javax.swing.JLabel lblCommentKey;
    private javax.swing.JLabel lblNameKey;
    private javax.swing.JPanel pnlButtons;
    private javax.swing.JPanel pnlPriorityValue;
    private javax.swing.JRadioButton rbPriorityHighValue;
    private javax.swing.JRadioButton rbPriorityLowValue;
    private javax.swing.JRadioButton rbPriorityNormalValue;
    private javax.swing.ButtonGroup rbgPriorityValue;
    private javax.swing.JScrollPane scpCommentValue;
    private javax.swing.JTextArea txtACommentValue;
    private javax.swing.JTextField txtNameValue;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new SetHintDialog object. Creates a modal dialog.
     *
     * @param  parent  The component the dialog should be child of.
     */
    public SetHintDialog(final JComponent parent) {
        this(StaticSwingTools.getParentFrame(parent), true);
    }

    /**
     * Creates new form SetHintDialog.
     *
     * @param  parent  The component the dialog should be child of.
     * @param  modal   Whether this dialog shall be modal or not.
     */
    public SetHintDialog(final java.awt.Frame parent, final boolean modal) {
        super(parent, NbBundle.getMessage(SetHintDialog.class, "SetHintDialog.title"), modal);
        initComponents();

        final DocumentListener listener = new CheckNotNullDocumentListener();
        txtNameValue.getDocument().addDocumentListener(listener);
        txtACommentValue.getDocument().addDocumentListener(listener);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        rbgPriorityValue = new javax.swing.ButtonGroup();
        lblNameKey = new javax.swing.JLabel();
        txtNameValue = new javax.swing.JTextField();
        lblCommentKey = new javax.swing.JLabel();
        scpCommentValue = new javax.swing.JScrollPane();
        txtACommentValue = new javax.swing.JTextArea();
        pnlPriorityValue = new javax.swing.JPanel();
        rbPriorityHighValue = new javax.swing.JRadioButton();
        rbPriorityNormalValue = new javax.swing.JRadioButton();
        rbPriorityLowValue = new javax.swing.JRadioButton();
        pnlButtons = new javax.swing.JPanel();
        btnOK = new javax.swing.JButton();
        btnCancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        lblNameKey.setText(org.openide.util.NbBundle.getMessage(SetHintDialog.class, "SetHintDialog.lblNameKey.text")); // NOI18N
        lblNameKey.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(lblNameKey, gridBagConstraints);

        txtNameValue.setText(org.openide.util.NbBundle.getMessage(
                SetHintDialog.class,
                "SetHintDialog.txtNameValue.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(txtNameValue, gridBagConstraints);

        lblCommentKey.setText(org.openide.util.NbBundle.getMessage(
                SetHintDialog.class,
                "SetHintDialog.lblCommentKey.text")); // NOI18N
        lblCommentKey.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(lblCommentKey, gridBagConstraints);

        txtACommentValue.setColumns(20);
        txtACommentValue.setLineWrap(true);
        txtACommentValue.setRows(5);
        txtACommentValue.setTabSize(2);
        txtACommentValue.setWrapStyleWord(true);
        scpCommentValue.setViewportView(txtACommentValue);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(scpCommentValue, gridBagConstraints);

        pnlPriorityValue.setBorder(javax.swing.BorderFactory.createTitledBorder(
                org.openide.util.NbBundle.getMessage(
                    SetHintDialog.class,
                    "SetHintDialog.pnlPriorityValue.border.title"))); // NOI18N
        pnlPriorityValue.setFocusable(false);

        rbgPriorityValue.add(rbPriorityHighValue);
        rbPriorityHighValue.setText(org.openide.util.NbBundle.getMessage(
                SetHintDialog.class,
                "SetHintDialog.rbPriorityHighValue.text")); // NOI18N
        rbPriorityHighValue.setBorder(null);
        rbPriorityHighValue.addItemListener(new java.awt.event.ItemListener() {

                @Override
                public void itemStateChanged(final java.awt.event.ItemEvent evt) {
                    rbPriorityHighValueItemStateChanged(evt);
                }
            });
        pnlPriorityValue.add(rbPriorityHighValue);

        rbgPriorityValue.add(rbPriorityNormalValue);
        rbPriorityNormalValue.setSelected(true);
        rbPriorityNormalValue.setText(org.openide.util.NbBundle.getMessage(
                SetHintDialog.class,
                "SetHintDialog.rbPriorityNormalValue.text")); // NOI18N
        rbPriorityNormalValue.setBorder(null);
        rbPriorityNormalValue.addItemListener(new java.awt.event.ItemListener() {

                @Override
                public void itemStateChanged(final java.awt.event.ItemEvent evt) {
                    rbPriorityNormalValueItemStateChanged(evt);
                }
            });
        pnlPriorityValue.add(rbPriorityNormalValue);

        rbgPriorityValue.add(rbPriorityLowValue);
        rbPriorityLowValue.setText(org.openide.util.NbBundle.getMessage(
                SetHintDialog.class,
                "SetHintDialog.rbPriorityLowValue.text")); // NOI18N
        rbPriorityLowValue.setBorder(null);
        rbPriorityLowValue.addItemListener(new java.awt.event.ItemListener() {

                @Override
                public void itemStateChanged(final java.awt.event.ItemEvent evt) {
                    rbPriorityLowValueItemStateChanged(evt);
                }
            });
        pnlPriorityValue.add(rbPriorityLowValue);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(pnlPriorityValue, gridBagConstraints);

        btnOK.setText(org.openide.util.NbBundle.getMessage(SetHintDialog.class, "SetHintDialog.btnOK.text")); // NOI18N
        btnOK.setEnabled(false);
        btnOK.setPreferredSize(new java.awt.Dimension(100, 25));
        btnOK.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnOKActionPerformed(evt);
                }
            });
        pnlButtons.add(btnOK);

        btnCancel.setText(org.openide.util.NbBundle.getMessage(SetHintDialog.class, "SetHintDialog.btnCancel.text")); // NOI18N
        btnCancel.setPreferredSize(new java.awt.Dimension(100, 25));
        btnCancel.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnCancelActionPerformed(evt);
                }
            });
        pnlButtons.add(btnCancel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(pnlButtons, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * The user decided to abort the specification of a hint. Reset all values and hide the dialog.
     *
     * @param  evt  The ActionEvent object.
     */
    private void btnCancelActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnCancelActionPerformed
        nameProperty = "";
        commentProperty = "";
        priorityProperty = null;
        wasCancelled = true;
        setVisible(false);
    }                                                                             //GEN-LAST:event_btnCancelActionPerformed

    /**
     * The user wants to save the entered hint. Cache all information in member attributes and hide the dialog.
     *
     * @param  evt  The ActionEvent object.
     */
    private void btnOKActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnOKActionPerformed
        nameProperty = txtNameValue.getText();
        commentProperty = txtACommentValue.getText();
        if (rbPriorityHighValue.isSelected()) {
            priorityProperty = Priority.HIGH;
        } else if (rbPriorityNormalValue.isSelected()) {
            priorityProperty = Priority.NORMAL;
        } else {
            priorityProperty = Priority.LOW;
        }
        wasCancelled = false;
        setVisible(false);
    }                                                                         //GEN-LAST:event_btnOKActionPerformed

    /**
     * The user has decided that this hint should be of low priority.
     *
     * @param  evt  The ItemEvent object.
     */
    private void rbPriorityLowValueItemStateChanged(final java.awt.event.ItemEvent evt) { //GEN-FIRST:event_rbPriorityLowValueItemStateChanged
        checkNotNull();
    }                                                                                     //GEN-LAST:event_rbPriorityLowValueItemStateChanged

    /**
     * The user has decided that this hint should be of normal priority.
     *
     * @param  evt  The ItemEvent object.
     */
    private void rbPriorityNormalValueItemStateChanged(final java.awt.event.ItemEvent evt) { //GEN-FIRST:event_rbPriorityNormalValueItemStateChanged
        checkNotNull();
    }                                                                                        //GEN-LAST:event_rbPriorityNormalValueItemStateChanged

    /**
     * The user has decided that this hint should be of high priority.
     *
     * @param  evt  The ItemEvent object.
     */
    private void rbPriorityHighValueItemStateChanged(final java.awt.event.ItemEvent evt) { //GEN-FIRST:event_rbPriorityHighValueItemStateChanged
        checkNotNull();
    }                                                                                      //GEN-LAST:event_rbPriorityHighValueItemStateChanged

    /**
     * This method validates the user input to enable or disable the OK button. In order to enable the OK button, the
     * JTextField and the JTextArea must have a non-empty input and a priority has to be selected.
     */
    private void checkNotNull() {
        boolean enableOK = true;

        final String name = txtNameValue.getText();
        if ((name == null) || (name.trim().length() <= 0)) {
            enableOK = false;
        }

        final String comment = txtACommentValue.getText();
        if ((comment == null) || (comment.trim().length() <= 0)) {
            enableOK = false;
        }

        if (!rbPriorityLowValue.isSelected() && !rbPriorityNormalValue.isSelected()
                    && !rbPriorityHighValue.isSelected()) {
            enableOK = false;
        }

        btnOK.setEnabled(enableOK);
    }

    /**
     * A getter for the specified name of the hint to add.
     *
     * @return  The name of the hint.
     */
    public String getNameProperty() {
        return nameProperty;
    }

    /**
     * A getter for the specified comment of the hint to add.
     *
     * @return  The comment of the hint.
     */
    public String getCommentProperty() {
        return commentProperty;
    }

    /**
     * A getter for the specified priority of the hint to add.
     *
     * @return  The priority of the hint.
     */
    public Priority getPriorityProperty() {
        return priorityProperty;
    }

    /**
     * A getter for the flag, if the user has aborted the specification of the hint.
     *
     * @return  A flag which tells whether the specification of the hint was aborted or not.
     */
    public boolean wasCancelled() {
        return wasCancelled;
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * A private DocumentListener which invokes checkNotNull() in order to tell the dialog class, that the JTextField
     * (name) or JTextArea (comment) has been changed.
     *
     * @version  $Revision$, $Date$
     */
    private class CheckNotNullDocumentListener implements DocumentListener {

        //~ Methods ------------------------------------------------------------

        @Override
        public void insertUpdate(final DocumentEvent e) {
            checkNotNull();
        }

        @Override
        public void removeUpdate(final DocumentEvent e) {
            checkNotNull();
        }

        @Override
        public void changedUpdate(final DocumentEvent e) {
            // NOP
        }
    }
}
