/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * ExcemptionPan.java
 *
 * Created on 10.08.2010, 11:48:00
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.server.middleware.types.MetaClass;

import java.util.Collection;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import de.cismet.cids.custom.wrrl_db_mv.commons.WRRLUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.RendererTools;
import de.cismet.cids.custom.wrrl_db_mv.util.UIUtil;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;

import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   stefan
 * @version  $Revision$, $Date$
 */
public class ExcemptionEditor extends JPanel implements DisposableCidsBeanStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final MetaClass EX_JUST_MC;
    private static final MetaClass EX_CAT_MC;
    private static final MetaClass EX_TYPE_MC;
    private static final MetaClass EX_DATE_MC;

    static {
        EX_JUST_MC = ClassCacheMultiple.getMetaClass(WRRLUtil.DOMAIN_NAME, "EX_JUSTIFICATION");
        EX_CAT_MC = ClassCacheMultiple.getMetaClass(WRRLUtil.DOMAIN_NAME, "EX_CAT");
        EX_TYPE_MC = ClassCacheMultiple.getMetaClass(WRRLUtil.DOMAIN_NAME, "EX_TYP");
        EX_DATE_MC = ClassCacheMultiple.getMetaClass(WRRLUtil.DOMAIN_NAME, "EX_DATE");
    }

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private boolean readOnly;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnJusAdd;
    private javax.swing.JButton btnJusRemove;
    private javax.swing.JButton btnJustfificationAbort;
    private javax.swing.JButton btnJustfificationOk;
    private javax.swing.JComboBox cbExCat;
    private javax.swing.JComboBox cbExDate;
    private javax.swing.JComboBox cbJustfificationCataloge;
    private javax.swing.JComboBox csExTyp;
    private javax.swing.JDialog dlgJustificationCataloge;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel lblExCat;
    private javax.swing.JLabel lblExDate;
    private javax.swing.JLabel lblExJus;
    private javax.swing.JLabel lblExTyp;
    private javax.swing.JLabel lblHeading;
    private javax.swing.JLabel lblJustfification;
    private javax.swing.JList lstExJus;
    private de.cismet.tools.gui.RoundedPanel panContent;
    private javax.swing.JPanel panControl;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo;
    private javax.swing.JPanel panMenButtonsJustfification;
    private javax.swing.JScrollPane scpExJus;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new ExcemptionEditor object.
     */
    public ExcemptionEditor() {
        this(true);
    }

    /**
     * Creates new form ExcemptionPan.
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public ExcemptionEditor(final boolean readOnly) {
        this.readOnly = readOnly;
        initComponents();
        deActivateGUIElements(false);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        dlgJustificationCataloge = new JDialog(StaticSwingTools.getParentFrame(this));
        lblJustfification = new javax.swing.JLabel();
        final DefaultBindableReferenceCombo cb = new DefaultBindableReferenceCombo(EX_JUST_MC, true, true);
        cbJustfificationCataloge = cb;
        panMenButtonsJustfification = new javax.swing.JPanel();
        btnJustfificationAbort = new javax.swing.JButton();
        btnJustfificationOk = new javax.swing.JButton();
        panContent = new de.cismet.tools.gui.RoundedPanel();
        jPanel1 = new javax.swing.JPanel();
        lblExCat = new javax.swing.JLabel();
        lblExTyp = new javax.swing.JLabel();
        lblExDate = new javax.swing.JLabel();
        lblExJus = new javax.swing.JLabel();
        cbExCat = new DefaultBindableReferenceCombo(EX_CAT_MC, true, true);
        cbExDate = new DefaultBindableReferenceCombo(EX_DATE_MC, true, false);
        csExTyp = new DefaultBindableReferenceCombo(EX_TYPE_MC, true, true);
        scpExJus = new javax.swing.JScrollPane();
        lstExJus = new javax.swing.JList();
        panControl = new javax.swing.JPanel();
        btnJusAdd = new javax.swing.JButton();
        btnJusRemove = new javax.swing.JButton();
        panHeadInfo = new de.cismet.tools.gui.SemiRoundedPanel();
        lblHeading = new javax.swing.JLabel();

        dlgJustificationCataloge.getContentPane().setLayout(new java.awt.GridBagLayout());

        lblJustfification.setText("Begründung");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        dlgJustificationCataloge.getContentPane().add(lblJustfification, gridBagConstraints);

        cbJustfificationCataloge.setMinimumSize(new java.awt.Dimension(250, 18));
        cbJustfificationCataloge.setPreferredSize(new java.awt.Dimension(250, 18));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        dlgJustificationCataloge.getContentPane().add(cbJustfificationCataloge, gridBagConstraints);

        panMenButtonsJustfification.setLayout(new java.awt.GridBagLayout());

        btnJustfificationAbort.setText("Abbrechen");
        btnJustfificationAbort.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnJustfificationAbortActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panMenButtonsJustfification.add(btnJustfificationAbort, gridBagConstraints);

        btnJustfificationOk.setText("Ok");
        btnJustfificationOk.setMaximumSize(new java.awt.Dimension(85, 23));
        btnJustfificationOk.setMinimumSize(new java.awt.Dimension(85, 23));
        btnJustfificationOk.setPreferredSize(new java.awt.Dimension(85, 23));
        btnJustfificationOk.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnJustfificationOkActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panMenButtonsJustfification.add(btnJustfificationOk, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        dlgJustificationCataloge.getContentPane().add(panMenButtonsJustfification, gridBagConstraints);

        setOpaque(false);
        setLayout(new java.awt.BorderLayout());

        panContent.setLayout(new java.awt.GridBagLayout());

        jPanel1.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        panContent.add(jPanel1, gridBagConstraints);

        lblExCat.setText("Kategorie");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 15, 5, 5);
        panContent.add(lblExCat, gridBagConstraints);

        lblExTyp.setText("Typ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        panContent.add(lblExTyp, gridBagConstraints);

        lblExDate.setText("Datum");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        panContent.add(lblExDate, gridBagConstraints);

        lblExJus.setText("Begründung");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 15, 5);
        panContent.add(lblExJus, gridBagConstraints);

        cbExCat.setMinimumSize(new java.awt.Dimension(300, 20));
        cbExCat.setPreferredSize(new java.awt.Dimension(300, 20));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.ex_cat}"),
                cbExCat,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 5);
        panContent.add(cbExCat, gridBagConstraints);

        cbExDate.setMinimumSize(new java.awt.Dimension(300, 20));
        cbExDate.setPreferredSize(new java.awt.Dimension(300, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.ex_date}"),
                cbExDate,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(cbExDate, gridBagConstraints);

        csExTyp.setMinimumSize(new java.awt.Dimension(300, 20));
        csExTyp.setPreferredSize(new java.awt.Dimension(300, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.ex_typ}"),
                csExTyp,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(csExTyp, gridBagConstraints);

        scpExJus.setMinimumSize(new java.awt.Dimension(300, 50));
        scpExJus.setPreferredSize(new java.awt.Dimension(300, 50));

        lstExJus.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);

        final org.jdesktop.beansbinding.ELProperty eLProperty = org.jdesktop.beansbinding.ELProperty.create(
                "${cidsBean.ex_jus}");
        final org.jdesktop.swingbinding.JListBinding jListBinding = org.jdesktop.swingbinding.SwingBindings
                    .createJListBinding(
                        org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                        this,
                        eLProperty,
                        lstExJus);
        bindingGroup.addBinding(jListBinding);

        scpExJus.setViewportView(lstExJus);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 107;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 15, 5);
        panContent.add(scpExJus, gridBagConstraints);

        panControl.setOpaque(false);
        panControl.setLayout(new java.awt.GridBagLayout());

        btnJusAdd.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_add_mini.png"))); // NOI18N
        btnJusAdd.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnJusAddActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        panControl.add(btnJusAdd, gridBagConstraints);

        btnJusRemove.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_remove_mini.png"))); // NOI18N
        btnJusRemove.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnJusRemoveActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        panControl.add(btnJusRemove, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 15, 15);
        panContent.add(panControl, gridBagConstraints);

        panHeadInfo.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setLayout(new java.awt.FlowLayout());

        lblHeading.setForeground(new java.awt.Color(255, 255, 255));
        lblHeading.setText("Informationen zur Ausnahme");
        panHeadInfo.add(lblHeading);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        panContent.add(panHeadInfo, gridBagConstraints);

        add(panContent, java.awt.BorderLayout.CENTER);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnJusAddActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnJusAddActionPerformed
        if (cbExCat.isEnabled()) {
            dlgJustificationCataloge.setSize(300, 150);
            StaticSwingTools.showDialog(StaticSwingTools.getParentFrame(this), dlgJustificationCataloge, true);
        }
    }                                                                             //GEN-LAST:event_btnJusAddActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnJusRemoveActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnJusRemoveActionPerformed
        if (cbExCat.isEnabled()) {
            final Object selection = lstExJus.getSelectedValue();
            if (selection != null) {
                final int answer = JOptionPane.showConfirmDialog(
                        StaticSwingTools.getParentFrame(this),
                        "Soll die Ausnahme '"
                                + selection.toString()
                                + "' wirklich gelöscht werden?",
                        "Ausnahme entfernen",
                        JOptionPane.YES_NO_OPTION);
                if (answer == JOptionPane.YES_OPTION) {
                    try {
                        final CidsBean beanToDelete = (CidsBean)selection;
                        final Object beanColl = cidsBean.getProperty("ex_jus");
                        if (beanColl instanceof Collection) {
                            ((Collection)beanColl).remove(beanToDelete);
                        }
                    } catch (Exception e) {
                        UIUtil.showExceptionToUser(e, this);
                    }
                }
            }
        }
    }                                                                                //GEN-LAST:event_btnJusRemoveActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnJustfificationAbortActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnJustfificationAbortActionPerformed
        dlgJustificationCataloge.setVisible(false);
    }                                                                                          //GEN-LAST:event_btnJustfificationAbortActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnJustfificationOkActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnJustfificationOkActionPerformed
        final Object selection = cbJustfificationCataloge.getSelectedItem();
        if (selection instanceof CidsBean) {
            final CidsBean selectedBean = (CidsBean)selection;
            final Collection<CidsBean> colToAdd = CidsBeanSupport.getBeanCollectionFromProperty(cidsBean, "ex_jus");
            if (colToAdd != null) {
                if (!colToAdd.contains(selectedBean)) {
                    colToAdd.add(selectedBean);
                }
            }
        }
        dlgJustificationCataloge.setVisible(false);
    }                                                                                       //GEN-LAST:event_btnJustfificationOkActionPerformed

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                this.cidsBean);
            bindingGroup.bind();
        }

        deActivateGUIElements((cidsBean != null) && !readOnly);
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
    }

    /**
     * DOCUMENT ME!
     *
     * @param  activate  DOCUMENT ME!
     */
    private void deActivateGUIElements(final boolean activate) {
        if (activate) {
            RendererTools.makeWritable(cbExCat);
            RendererTools.makeWritable(cbExDate);
            RendererTools.makeWritable(csExTyp);
        } else {
            RendererTools.makeReadOnly(cbExCat);
            RendererTools.makeReadOnly(cbExDate);
            RendererTools.makeReadOnly(csExTyp);
        }
        panControl.setVisible(activate);
    }
}
