/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * WkFgPanOne.java
 *
 * Created on 04.08.2010, 13:44:05
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;

import java.util.HashMap;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.NumberConverter;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;

import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   stefan
 * @version  $Revision$, $Date$
 */
public class FgskKartierabschnittQuerprofil extends javax.swing.JPanel implements DisposableCidsBeanStore,
    EditorSaveListener {

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.tools.gui.RoundedPanel glassPanel;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jpProfil;
    private javax.swing.JPanel jpQuer;
    private de.cismet.cids.custom.objecteditors.wrrl_db_mv.KartierabschnittUebersicht kartierabschnittUebersicht1;
    private javax.swing.JLabel lblBreitenerosion;
    private javax.swing.JLabel lblBreitenvarianz;
    private javax.swing.JLabel lblEinschnitttiefe;
    private javax.swing.JLabel lblHeading;
    private javax.swing.JLabel lblHeading1;
    private javax.swing.JLabel lblHeading2;
    private javax.swing.JLabel lblObereProfilbreite;
    private javax.swing.JLabel lblProfiltyp;
    private javax.swing.JLabel lblSohlenbreite;
    private javax.swing.JLabel lblWasserspiegelbreite;
    private javax.swing.JLabel lblWassertiefe;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo1;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo2;
    private de.cismet.tools.gui.RoundedPanel panInfo;
    private de.cismet.tools.gui.RoundedPanel panInfo1;
    private de.cismet.tools.gui.RoundedPanel panInfo2;
    private de.cismet.tools.gui.RoundedPanel panInfo3;
    private javax.swing.JPanel panInfoContent;
    private javax.swing.JPanel panInfoContent1;
    private javax.swing.JPanel panInfoContent2;
    private de.cismet.cids.editors.DefaultBindableRadioButtonField rdErosion;
    private de.cismet.cids.editors.DefaultBindableRadioButtonField rdProfil;
    private de.cismet.cids.editors.DefaultBindableRadioButtonField rdVarianz;
    private javax.swing.JSeparator sepMiddle;
    private javax.swing.JTextField tfEinschnitttiefe;
    private javax.swing.JTextField tfObereProfilbreite;
    private javax.swing.JTextField tfSohlenbreite;
    private javax.swing.JTextField tfWasserspiegelbreite;
    private javax.swing.JTextField tfWassertiefe;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WkFgPanOne.
     */
    public FgskKartierabschnittQuerprofil() {
        initComponents();
        setOpaque(false);
        final HashMap<Object, Icon> icons = new HashMap<Object, Icon>();
        ImageIcon icon = new ImageIcon(getClass().getResource(
                    "/de/cismet/cids/custom/objecteditors/wrrl_db_mv/BV_keine_crop.png"));
        icons.put(1, icon);
        icon = new ImageIcon(getClass().getResource(
                    "/de/cismet/cids/custom/objecteditors/wrrl_db_mv/BV_gering_crop.png"));
        icons.put(2, icon);
        icon = new ImageIcon(getClass().getResource(
                    "/de/cismet/cids/custom/objecteditors/wrrl_db_mv/BV_maessig_crop.png"));
        icons.put(3, icon);
        icon = new ImageIcon(getClass().getResource(
                    "/de/cismet/cids/custom/objecteditors/wrrl_db_mv/BV_gross_crop.png"));
        icons.put(4, icon);
        icon = new ImageIcon(getClass().getResource(
                    "/de/cismet/cids/custom/objecteditors/wrrl_db_mv/BV_sehr_gross_crop.png"));
        icons.put(5, icon);
        rdVarianz.setIcons(icons, "value");
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        glassPanel = new de.cismet.tools.gui.RoundedPanel();
        panInfo = new de.cismet.tools.gui.RoundedPanel();
        kartierabschnittUebersicht1 = new de.cismet.cids.custom.objecteditors.wrrl_db_mv.KartierabschnittUebersicht();
        jpProfil = new javax.swing.JPanel();
        panInfo1 = new de.cismet.tools.gui.RoundedPanel();
        panHeadInfo = new de.cismet.tools.gui.SemiRoundedPanel();
        lblHeading = new javax.swing.JLabel();
        panInfoContent = new javax.swing.JPanel();
        lblProfiltyp = new javax.swing.JLabel();
        rdProfil = new de.cismet.cids.editors.DefaultBindableRadioButtonField();
        jpQuer = new javax.swing.JPanel();
        panInfo2 = new de.cismet.tools.gui.RoundedPanel();
        panHeadInfo1 = new de.cismet.tools.gui.SemiRoundedPanel();
        lblHeading1 = new javax.swing.JLabel();
        panInfoContent1 = new javax.swing.JPanel();
        lblEinschnitttiefe = new javax.swing.JLabel();
        lblWassertiefe = new javax.swing.JLabel();
        lblSohlenbreite = new javax.swing.JLabel();
        lblWasserspiegelbreite = new javax.swing.JLabel();
        lblObereProfilbreite = new javax.swing.JLabel();
        tfEinschnitttiefe = new javax.swing.JTextField();
        tfWassertiefe = new javax.swing.JTextField();
        tfWasserspiegelbreite = new javax.swing.JTextField();
        tfSohlenbreite = new javax.swing.JTextField();
        tfObereProfilbreite = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        panInfo3 = new de.cismet.tools.gui.RoundedPanel();
        panHeadInfo2 = new de.cismet.tools.gui.SemiRoundedPanel();
        lblHeading2 = new javax.swing.JLabel();
        panInfoContent2 = new javax.swing.JPanel();
        sepMiddle = new javax.swing.JSeparator();
        lblBreitenvarianz = new javax.swing.JLabel();
        lblBreitenerosion = new javax.swing.JLabel();
        rdVarianz = new de.cismet.cids.editors.DefaultBindableRadioButtonField();
        rdErosion = new de.cismet.cids.editors.DefaultBindableRadioButtonField();

        setMaximumSize(new java.awt.Dimension(1100, 650));
        setMinimumSize(new java.awt.Dimension(1100, 650));
        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(1100, 650));
        setLayout(new java.awt.GridBagLayout());

        glassPanel.setAlpha(0);
        glassPanel.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(glassPanel, gridBagConstraints);

        panInfo.setLayout(new java.awt.GridBagLayout());

        kartierabschnittUebersicht1.setMinimumSize(new java.awt.Dimension(1100, 100));
        kartierabschnittUebersicht1.setPreferredSize(new java.awt.Dimension(1100, 100));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        panInfo.add(kartierabschnittUebersicht1, gridBagConstraints);

        jpProfil.setMinimumSize(new java.awt.Dimension(540, 200));
        jpProfil.setOpaque(false);
        jpProfil.setPreferredSize(new java.awt.Dimension(540, 200));
        jpProfil.setLayout(new java.awt.BorderLayout());

        panHeadInfo.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setLayout(new java.awt.FlowLayout());

        lblHeading.setForeground(new java.awt.Color(255, 255, 255));
        lblHeading.setText(org.openide.util.NbBundle.getMessage(
                FgskKartierabschnittQuerprofil.class,
                "FgskKartierabschnittQuerprofil.lblHeading.text")); // NOI18N
        panHeadInfo.add(lblHeading);

        panInfo1.add(panHeadInfo, java.awt.BorderLayout.NORTH);

        panInfoContent.setMinimumSize(new java.awt.Dimension(1057, 250));
        panInfoContent.setOpaque(false);
        panInfoContent.setLayout(new java.awt.GridBagLayout());

        lblProfiltyp.setText(org.openide.util.NbBundle.getMessage(
                FgskKartierabschnittQuerprofil.class,
                "FgskKartierabschnittQuerprofil.lblProfiltyp.text")); // NOI18N
        lblProfiltyp.setMaximumSize(new java.awt.Dimension(120, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblProfiltyp, gridBagConstraints);

        rdProfil.setMinimumSize(new java.awt.Dimension(180, 140));
        rdProfil.setOpaque(false);
        rdProfil.setPreferredSize(new java.awt.Dimension(180, 140));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.profiltyp_id}"),
                rdProfil,
                org.jdesktop.beansbinding.BeanProperty.create("selectedElements"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 10);
        panInfoContent.add(rdProfil, gridBagConstraints);

        panInfo1.add(panInfoContent, java.awt.BorderLayout.CENTER);

        jpProfil.add(panInfo1, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        panInfo.add(jpProfil, gridBagConstraints);

        jpQuer.setMinimumSize(new java.awt.Dimension(540, 200));
        jpQuer.setOpaque(false);
        jpQuer.setPreferredSize(new java.awt.Dimension(540, 200));
        jpQuer.setLayout(new java.awt.BorderLayout());

        panHeadInfo1.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo1.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo1.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo1.setLayout(new java.awt.FlowLayout());

        lblHeading1.setForeground(new java.awt.Color(255, 255, 255));
        lblHeading1.setText(org.openide.util.NbBundle.getMessage(
                FgskKartierabschnittQuerprofil.class,
                "FgskKartierabschnittQuerprofil.lblHeading1.text")); // NOI18N
        panHeadInfo1.add(lblHeading1);

        panInfo2.add(panHeadInfo1, java.awt.BorderLayout.NORTH);

        panInfoContent1.setMinimumSize(new java.awt.Dimension(1057, 250));
        panInfoContent1.setOpaque(false);
        panInfoContent1.setLayout(new java.awt.GridBagLayout());

        lblEinschnitttiefe.setText(org.openide.util.NbBundle.getMessage(
                FgskKartierabschnittQuerprofil.class,
                "FgskKartierabschnittQuerprofil.lblEinschnitttiefe.text")); // NOI18N
        lblEinschnitttiefe.setMaximumSize(new java.awt.Dimension(120, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent1.add(lblEinschnitttiefe, gridBagConstraints);

        lblWassertiefe.setText(org.openide.util.NbBundle.getMessage(
                FgskKartierabschnittQuerprofil.class,
                "FgskKartierabschnittQuerprofil.lblWassertiefe.text")); // NOI18N
        lblWassertiefe.setMaximumSize(new java.awt.Dimension(120, 17));
        lblWassertiefe.setMinimumSize(new java.awt.Dimension(130, 17));
        lblWassertiefe.setPreferredSize(new java.awt.Dimension(130, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent1.add(lblWassertiefe, gridBagConstraints);

        lblSohlenbreite.setText(org.openide.util.NbBundle.getMessage(
                FgskKartierabschnittQuerprofil.class,
                "FgskKartierabschnittQuerprofil.lblSohlenbreite.text")); // NOI18N
        lblSohlenbreite.setMaximumSize(new java.awt.Dimension(120, 17));
        lblSohlenbreite.setMinimumSize(new java.awt.Dimension(130, 17));
        lblSohlenbreite.setPreferredSize(new java.awt.Dimension(130, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent1.add(lblSohlenbreite, gridBagConstraints);

        lblWasserspiegelbreite.setText(org.openide.util.NbBundle.getMessage(
                FgskKartierabschnittQuerprofil.class,
                "FgskKartierabschnittQuerprofil.lblWasserspiegelbreite.text")); // NOI18N
        lblWasserspiegelbreite.setMaximumSize(new java.awt.Dimension(120, 17));
        lblWasserspiegelbreite.setMinimumSize(new java.awt.Dimension(130, 17));
        lblWasserspiegelbreite.setPreferredSize(new java.awt.Dimension(130, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent1.add(lblWasserspiegelbreite, gridBagConstraints);

        lblObereProfilbreite.setText(org.openide.util.NbBundle.getMessage(
                FgskKartierabschnittQuerprofil.class,
                "FgskKartierabschnittQuerprofil.lblObereProfilbreite.text")); // NOI18N
        lblObereProfilbreite.setMaximumSize(new java.awt.Dimension(120, 17));
        lblObereProfilbreite.setMinimumSize(new java.awt.Dimension(130, 17));
        lblObereProfilbreite.setPreferredSize(new java.awt.Dimension(130, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent1.add(lblObereProfilbreite, gridBagConstraints);

        tfEinschnitttiefe.setMinimumSize(new java.awt.Dimension(150, 20));
        tfEinschnitttiefe.setPreferredSize(new java.awt.Dimension(150, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.einschnitttiefe}"),
                tfEinschnitttiefe,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setSourceNullValue("0.0");
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 10);
        panInfoContent1.add(tfEinschnitttiefe, gridBagConstraints);

        tfWassertiefe.setMinimumSize(new java.awt.Dimension(150, 20));
        tfWassertiefe.setPreferredSize(new java.awt.Dimension(150, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.wassertiefe}"),
                tfWassertiefe,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setSourceNullValue("0.0");
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent1.add(tfWassertiefe, gridBagConstraints);

        tfWasserspiegelbreite.setMinimumSize(new java.awt.Dimension(150, 20));
        tfWasserspiegelbreite.setPreferredSize(new java.awt.Dimension(150, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.wasserspiegelbreite}"),
                tfWasserspiegelbreite,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setSourceNullValue("0.0");
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent1.add(tfWasserspiegelbreite, gridBagConstraints);

        tfSohlenbreite.setMinimumSize(new java.awt.Dimension(150, 20));
        tfSohlenbreite.setPreferredSize(new java.awt.Dimension(150, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlenbreite}"),
                tfSohlenbreite,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setSourceNullValue("0.0");
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent1.add(tfSohlenbreite, gridBagConstraints);

        tfObereProfilbreite.setMinimumSize(new java.awt.Dimension(150, 20));
        tfObereProfilbreite.setPreferredSize(new java.awt.Dimension(150, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.obere_profilbreite}"),
                tfObereProfilbreite,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setSourceNullValue("0.0");
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent1.add(tfObereProfilbreite, gridBagConstraints);

        panInfo2.add(panInfoContent1, java.awt.BorderLayout.CENTER);

        jpQuer.add(panInfo2, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 20, 0, 0);
        panInfo.add(jpQuer, gridBagConstraints);

        jPanel1.setMinimumSize(new java.awt.Dimension(1100, 250));
        jPanel1.setOpaque(false);
        jPanel1.setPreferredSize(new java.awt.Dimension(1100, 250));
        jPanel1.setLayout(new java.awt.BorderLayout());

        panHeadInfo2.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo2.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo2.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo2.setLayout(new java.awt.FlowLayout());

        lblHeading2.setForeground(new java.awt.Color(255, 255, 255));
        lblHeading2.setText(org.openide.util.NbBundle.getMessage(
                FgskKartierabschnittQuerprofil.class,
                "FgskKartierabschnittQuerprofil.lblHeading2.text")); // NOI18N
        panHeadInfo2.add(lblHeading2);

        panInfo3.add(panHeadInfo2, java.awt.BorderLayout.NORTH);

        panInfoContent2.setMinimumSize(new java.awt.Dimension(1057, 250));
        panInfoContent2.setOpaque(false);
        panInfoContent2.setLayout(new java.awt.GridBagLayout());

        sepMiddle.setOrientation(javax.swing.SwingConstants.VERTICAL);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(15, 15, 5, 25);
        panInfoContent2.add(sepMiddle, gridBagConstraints);

        lblBreitenvarianz.setText(org.openide.util.NbBundle.getMessage(
                FgskKartierabschnittQuerprofil.class,
                "FgskKartierabschnittQuerprofil.lblBreitenvarianz.text")); // NOI18N
        lblBreitenvarianz.setMaximumSize(new java.awt.Dimension(120, 17));
        lblBreitenvarianz.setMinimumSize(new java.awt.Dimension(130, 17));
        lblBreitenvarianz.setPreferredSize(new java.awt.Dimension(130, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent2.add(lblBreitenvarianz, gridBagConstraints);

        lblBreitenerosion.setText(org.openide.util.NbBundle.getMessage(
                FgskKartierabschnittQuerprofil.class,
                "FgskKartierabschnittQuerprofil.lblBreitenerosion.text")); // NOI18N
        lblBreitenerosion.setMaximumSize(new java.awt.Dimension(120, 17));
        lblBreitenerosion.setMinimumSize(new java.awt.Dimension(130, 17));
        lblBreitenerosion.setPreferredSize(new java.awt.Dimension(130, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent2.add(lblBreitenerosion, gridBagConstraints);

        rdVarianz.setMinimumSize(new java.awt.Dimension(180, 140));
        rdVarianz.setOpaque(false);
        rdVarianz.setPreferredSize(new java.awt.Dimension(180, 140));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.breitenvarianz_id}"),
                rdVarianz,
                org.jdesktop.beansbinding.BeanProperty.create("selectedElements"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 10);
        panInfoContent2.add(rdVarianz, gridBagConstraints);

        rdErosion.setMinimumSize(new java.awt.Dimension(180, 100));
        rdErosion.setOpaque(false);
        rdErosion.setPreferredSize(new java.awt.Dimension(180, 100));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.breitenerosion_id}"),
                rdErosion,
                org.jdesktop.beansbinding.BeanProperty.create("selectedElements"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 10);
        panInfoContent2.add(rdErosion, gridBagConstraints);

        panInfo3.add(panInfoContent2, java.awt.BorderLayout.CENTER);

        jPanel1.add(panInfo3, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        panInfo.add(jPanel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(panInfo, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                this.cidsBean);
            bindingGroup.bind();
            kartierabschnittUebersicht1.setCidsBean(cidsBean);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public void setReadOnly(final boolean readOnly) {
        if (readOnly) {
            glassPanel.addMouseListener(new MouseAdapter() {
                });
        } else {
            for (final MouseListener ml : glassPanel.getMouseListeners()) {
                glassPanel.removeMouseListener(ml);
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  wkk  DOCUMENT ME!
     */
    public void setWkk(final String wkk) {
        kartierabschnittUebersicht1.setWkk(wkk);
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
        kartierabschnittUebersicht1.dispose();
    }

    @Override
    public void editorClosed(final EditorClosedEvent event) {
    }

    @Override
    public boolean prepareForSave() {
        final double einschnitttiefe = CidsBeanSupport.textToDouble(tfEinschnitttiefe, -1);
        final double wassertiefe = CidsBeanSupport.textToDouble(tfWassertiefe, -1);
        final double wasserspiegelbreite = CidsBeanSupport.textToDouble(tfWasserspiegelbreite, -1);
        final double sohlbreite = CidsBeanSupport.textToDouble(tfSohlenbreite, -1);
        final double obereProfilbreite = CidsBeanSupport.textToDouble(tfObereProfilbreite, -1);

        if (einschnitttiefe == -1) {
            JOptionPane.showMessageDialog(
                StaticSwingTools.getParentFrame(this),
                "Die Einschnitttiefe wurde nicht gesetzt.",
                "Ungültige Eingabe",
                JOptionPane.ERROR_MESSAGE);
            return false;
        } else if (wassertiefe == -1) {
            JOptionPane.showMessageDialog(
                StaticSwingTools.getParentFrame(this),
                "Die Wassertiefe wurde nicht gesetzt.",
                "Ungültige Eingabe",
                JOptionPane.ERROR_MESSAGE);
            return false;
        } else if (wasserspiegelbreite == -1) {
            JOptionPane.showMessageDialog(
                StaticSwingTools.getParentFrame(this),
                "Die Wasserspiegelbreite wurde nicht gesetzt.",
                "Ungültige Eingabe",
                JOptionPane.ERROR_MESSAGE);
            return false;
        } else if (sohlbreite == -1) {
            JOptionPane.showMessageDialog(
                StaticSwingTools.getParentFrame(this),
                "Die Sohlbreite wurde nicht gesetzt.",
                "Ungültige Eingabe",
                JOptionPane.ERROR_MESSAGE);
            return false;
        } else if (obereProfilbreite == -1) {
            JOptionPane.showMessageDialog(
                StaticSwingTools.getParentFrame(this),
                "Die obere Profiltiefe wurde nicht gesetzt.",
                "Ungültige Eingabe",
                JOptionPane.ERROR_MESSAGE);
            return false;
        } else if (wasserspiegelbreite < sohlbreite) {
            JOptionPane.showMessageDialog(
                StaticSwingTools.getParentFrame(this),
                "Die Wasserspiegelbreite ist kleiner als die Sohlbreite.",
                "Ungültige Eingabe",
                JOptionPane.ERROR_MESSAGE);
            return false;
        } else if (obereProfilbreite < wasserspiegelbreite) {
            JOptionPane.showMessageDialog(
                StaticSwingTools.getParentFrame(this),
                "Die obere Profilbreite ist kleiner als die Wasserspiegelbreite.",
                "Ungültige Eingabe",
                JOptionPane.ERROR_MESSAGE);
            return false;
        }

        return true;
    }
}
