/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * WkFgPanOne.java
 *
 * Created on 04.08.2010, 13:44:05
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;

import de.cismet.cids.custom.wrrl_db_mv.commons.WRRLUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.YesNoDecider;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;

import de.cismet.cids.editors.DefaultCustomObjectEditor;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

/**
 * DOCUMENT ME!
 *
 * @author   stefan
 * @version  $Revision$, $Date$
 */
public class FgskKartierabschnittSohlenverbau extends javax.swing.JPanel implements DisposableCidsBeanStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            FgskKartierabschnittSohlenverbau.class);
    private static final MetaClass MC = ClassCacheMultiple.getMetaClass(
            WRRLUtil.DOMAIN_NAME,
            "fgsk_z_sohlenverbau");
    private static final int NONE_VAL = 4;
    private static final int NONE_VAL_STATE = 4;

    //~ Instance fields --------------------------------------------------------

    private YesNoDecider decider;
    private CidsBean cidsBean;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.tools.gui.RoundedPanel glassPanel;
    private de.cismet.tools.gui.RoundedPanel jpZustand;
    private de.cismet.cids.custom.objecteditors.wrrl_db_mv.KartierabschnittBesSohlen kartierabschnittBesSohlen1;
    private de.cismet.cids.custom.objecteditors.wrrl_db_mv.KartierabschnittSohlenstrukturen
        kartierabschnittSohlenstrukturen1;
    private de.cismet.cids.custom.objecteditors.wrrl_db_mv.KartierabschnittSohlensubstrat
        kartierabschnittSohlensubstrat1;
    private de.cismet.cids.custom.objecteditors.wrrl_db_mv.KartierabschnittUebersicht kartierabschnittUebersicht1;
    private javax.swing.JLabel lblHeading;
    private javax.swing.JLabel lblSohlenverbau;
    private javax.swing.JLabel lblZustand;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo;
    private de.cismet.tools.gui.RoundedPanel panInfo;
    private javax.swing.JPanel panInfoContent;
    private de.cismet.cids.editors.DefaultBindableRadioButtonField rdSohlenverbau;
    private de.cismet.cids.editors.DefaultBindableRadioButtonField rdZustand;
    private javax.swing.JSeparator sepMiddle;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WkFgPanOne.
     */
    public FgskKartierabschnittSohlenverbau() {
        initComponents();
        setOpaque(false);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        glassPanel = new de.cismet.tools.gui.RoundedPanel();
        panInfo = new de.cismet.tools.gui.RoundedPanel();
        kartierabschnittUebersicht1 = new de.cismet.cids.custom.objecteditors.wrrl_db_mv.KartierabschnittUebersicht();
        jpZustand = new de.cismet.tools.gui.RoundedPanel();
        panHeadInfo = new de.cismet.tools.gui.SemiRoundedPanel();
        lblHeading = new javax.swing.JLabel();
        panInfoContent = new javax.swing.JPanel();
        lblSohlenverbau = new javax.swing.JLabel();
        sepMiddle = new javax.swing.JSeparator();
        lblZustand = new javax.swing.JLabel();
        rdSohlenverbau = new de.cismet.cids.editors.DefaultBindableRadioButtonField();
        rdZustand = new de.cismet.cids.editors.DefaultBindableRadioButtonField();
        kartierabschnittSohlensubstrat1 =
            new de.cismet.cids.custom.objecteditors.wrrl_db_mv.KartierabschnittSohlensubstrat();
        kartierabschnittSohlenstrukturen1 =
            new de.cismet.cids.custom.objecteditors.wrrl_db_mv.KartierabschnittSohlenstrukturen();
        kartierabschnittBesSohlen1 = new de.cismet.cids.custom.objecteditors.wrrl_db_mv.KartierabschnittBesSohlen();

        setMaximumSize(new java.awt.Dimension(1100, 650));
        setMinimumSize(new java.awt.Dimension(1100, 650));
        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(1100, 650));
        setLayout(new java.awt.GridBagLayout());

        glassPanel.setAlpha(0);
        glassPanel.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(glassPanel, gridBagConstraints);

        panInfo.setLayout(new java.awt.GridBagLayout());

        kartierabschnittUebersicht1.setMinimumSize(new java.awt.Dimension(1100, 100));
        kartierabschnittUebersicht1.setPreferredSize(new java.awt.Dimension(1100, 100));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        panInfo.add(kartierabschnittUebersicht1, gridBagConstraints);

        jpZustand.setMinimumSize(new java.awt.Dimension(1100, 140));
        jpZustand.setPreferredSize(new java.awt.Dimension(1100, 140));

        panHeadInfo.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setLayout(new java.awt.FlowLayout());

        lblHeading.setForeground(new java.awt.Color(255, 255, 255));
        lblHeading.setText(org.openide.util.NbBundle.getMessage(
                FgskKartierabschnittSohlenverbau.class,
                "FgskKartierabschnittSohlenverbau.lblHeading.text")); // NOI18N
        panHeadInfo.add(lblHeading);

        jpZustand.add(panHeadInfo, java.awt.BorderLayout.NORTH);

        panInfoContent.setMinimumSize(new java.awt.Dimension(1057, 250));
        panInfoContent.setOpaque(false);
        panInfoContent.setLayout(new java.awt.GridBagLayout());

        lblSohlenverbau.setText(org.openide.util.NbBundle.getMessage(
                FgskKartierabschnittSohlenverbau.class,
                "FgskKartierabschnittSohlenverbau.lblSohlenverbau.text")); // NOI18N
        lblSohlenverbau.setMaximumSize(new java.awt.Dimension(120, 17));
        lblSohlenverbau.setMinimumSize(new java.awt.Dimension(130, 17));
        lblSohlenverbau.setPreferredSize(new java.awt.Dimension(130, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblSohlenverbau, gridBagConstraints);

        sepMiddle.setOrientation(javax.swing.SwingConstants.VERTICAL);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 15, 5, 25);
        panInfoContent.add(sepMiddle, gridBagConstraints);

        lblZustand.setText(org.openide.util.NbBundle.getMessage(
                FgskKartierabschnittSohlenverbau.class,
                "FgskKartierabschnittSohlenverbau.lblZustand.text")); // NOI18N
        lblZustand.setMinimumSize(new java.awt.Dimension(130, 17));
        lblZustand.setPreferredSize(new java.awt.Dimension(130, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 5);
        panInfoContent.add(lblZustand, gridBagConstraints);

        rdSohlenverbau.setMinimumSize(new java.awt.Dimension(180, 80));
        rdSohlenverbau.setOpaque(false);
        rdSohlenverbau.setPreferredSize(new java.awt.Dimension(180, 80));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlenverbau_id}"),
                rdSohlenverbau,
                org.jdesktop.beansbinding.BeanProperty.create("selectedElements"));
        bindingGroup.addBinding(binding);

        rdSohlenverbau.addPropertyChangeListener(new java.beans.PropertyChangeListener() {

                @Override
                public void propertyChange(final java.beans.PropertyChangeEvent evt) {
                    rdSohlenverbauPropertyChange(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 10);
        panInfoContent.add(rdSohlenverbau, gridBagConstraints);

        rdZustand.setMinimumSize(new java.awt.Dimension(180, 80));
        rdZustand.setOpaque(false);
        rdZustand.setPreferredSize(new java.awt.Dimension(180, 80));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.z_sohlenverbau_id}"),
                rdZustand,
                org.jdesktop.beansbinding.BeanProperty.create("selectedElements"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 10);
        panInfoContent.add(rdZustand, gridBagConstraints);

        jpZustand.add(panInfoContent, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        panInfo.add(jpZustand, gridBagConstraints);

        kartierabschnittSohlensubstrat1.setMinimumSize(new java.awt.Dimension(360, 380));
        kartierabschnittSohlensubstrat1.setPreferredSize(new java.awt.Dimension(360, 380));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        panInfo.add(kartierabschnittSohlensubstrat1, gridBagConstraints);

        kartierabschnittSohlenstrukturen1.setMinimumSize(new java.awt.Dimension(360, 380));
        kartierabschnittSohlenstrukturen1.setPreferredSize(new java.awt.Dimension(360, 380));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 0);
        panInfo.add(kartierabschnittSohlenstrukturen1, gridBagConstraints);

        kartierabschnittBesSohlen1.setMinimumSize(new java.awt.Dimension(360, 380));
        kartierabschnittBesSohlen1.setPreferredSize(new java.awt.Dimension(360, 380));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 0);
        panInfo.add(kartierabschnittBesSohlen1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(panInfo, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void rdSohlenverbauPropertyChange(final java.beans.PropertyChangeEvent evt) { //GEN-FIRST:event_rdSohlenverbauPropertyChange
        if ((evt.getPropertyName().equals("selectedElements"))) {
            final CidsBean newValue = (CidsBean)evt.getNewValue();
            refreshState(newValue);
        }
    }                                                                                     //GEN-LAST:event_rdSohlenverbauPropertyChange

    /**
     * DOCUMENT ME!
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public void setReadOnly(final boolean readOnly) {
        if (readOnly) {
            glassPanel.addMouseListener(new MouseAdapter() {
                });
        } else {
            for (final MouseListener ml : glassPanel.getMouseListeners()) {
                glassPanel.removeMouseListener(ml);
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  selectedElement  DOCUMENT ME!
     */
    private void refreshState(final CidsBean selectedElement) {
        new Thread(new Runnable() {

                @Override
                public void run() {
                    try {
                        final boolean enabled = isStateEnabled(selectedElement);

                        if (decider == null) {
                            decider = new YesNoDecider(enabled);
                            decider.addPositiveException(getZSohlenverbauByValue(NONE_VAL_STATE).getMetaObject());
                        } else {
                            decider.setEnable(enabled);
                        }

                        if (!enabled) {
                            final CidsBean none = getZSohlenverbauByValue(NONE_VAL_STATE);
                            cidsBean.setProperty("z_sohlenverbau_id", none);
                            rdZustand.setSelectedElements(none);
                        } else {
                            final CidsBean selected = (CidsBean)rdZustand.getSelectedElements();
                            if (selected != null) {
                                final Integer val = (Integer)selected.getProperty("value");
                                if (val == NONE_VAL_STATE) {
                                    cidsBean.setProperty("z_sohlenverbau_id", getZSohlenverbauByValue(1));
                                    rdZustand.setSelectedElements(getZSohlenverbauByValue(1));
                                }
                            }
                        }

                        rdZustand.refreshCheckboxState(decider, false);
                    } catch (final Exception e) {
                        LOG.error("Error while refreshing the state.", e);
                    }
                }
            }).start();
    }

    /**
     * DOCUMENT ME!
     *
     * @param   bean  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private boolean isStateEnabled(final CidsBean bean) {
//        CidsBean sohle = (CidsBean)bean.getProperty("sohlenverbau_id");

        if (bean != null) {
            final Integer value = (Integer)bean.getProperty("value");

            if ((value != null) && (value == NONE_VAL)) {
                return false;
            }
        }

        return true;
    }

    /**
     * DOCUMENT ME!
     *
     * @param   value  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     *
     * @throws  ConnectionException  DOCUMENT ME!
     */
    private CidsBean getZSohlenverbauByValue(final int value) throws ConnectionException {
        final String query = "select " + MC.getID() + ", " + MC.getPrimaryKey() + " from "
                    + MC.getTableName() + " where value = " + value;
        final MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);

        if (metaObjects.length == 1) {
            return metaObjects[0].getBean();
        } else {
            return null;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                this.cidsBean);
            bindingGroup.bind();
            kartierabschnittUebersicht1.setCidsBean(cidsBean);
            kartierabschnittSohlenstrukturen1.setCidsBean(cidsBean);
            kartierabschnittSohlensubstrat1.setCidsBean(cidsBean);
            kartierabschnittBesSohlen1.setCidsBean(cidsBean);
            refreshState((CidsBean)cidsBean.getProperty("sohlenverbau_id"));
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  wkk  DOCUMENT ME!
     */
    public void setWkk(final String wkk) {
        kartierabschnittUebersicht1.setWkk(wkk);
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
        kartierabschnittUebersicht1.dispose();
        kartierabschnittSohlenstrukturen1.dispose();
        kartierabschnittSohlensubstrat1.dispose();
        kartierabschnittBesSohlen1.dispose();
    }
}
