/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * GupMassnahmeSohle.java
 *
 * Created on 27.11.2012, 11:49:19
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;

import Sirius.server.newuser.User;

import java.util.ArrayList;
import java.util.List;

import de.cismet.cids.client.tools.DevelopmentTools;

import de.cismet.cids.custom.objectrenderer.wrrl_db_mv.LinearReferencedLineRenderer;
import de.cismet.cids.custom.wrrl_db_mv.util.RendererTools;
import de.cismet.cids.custom.wrrl_db_mv.util.ScrollableComboBox;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class GeschuetzteArtAbschnittEditor extends javax.swing.JPanel implements CidsBeanRenderer, EditorSaveListener {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            GeschuetzteArtAbschnittEditor.class);

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private List<CidsBean> others;
    private boolean withVerbreitungsraum;
    private CidsBean verbreitungsraum;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.cids.editors.DefaultBindableReferenceCombo cbName;
    private de.cismet.cids.editors.DefaultBindableDateChooser dcDatenalter;
    private javax.swing.JLabel lblAlter;
    private javax.swing.JLabel lblArt;
    private javax.swing.JLabel lblHerkunft;
    private javax.swing.JLabel lblVermeidungsgruppe;
    private de.cismet.cids.custom.objecteditors.wrrl_db_mv.LinearReferencedLineEditor linearReferencedLineEditor;
    private javax.swing.JTextField txtHerkunft;
    private javax.swing.JTextField txtVermeidungsgruppe;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form GupMassnahmeSohle.
     */
    public GeschuetzteArtAbschnittEditor() {
        this(false);
    }

    /**
     * Creates new form GupMassnahmeSohle.
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public GeschuetzteArtAbschnittEditor(final boolean readOnly) {
        this(readOnly, false);
    }

    /**
     * Creates new form GupMassnahmeSohle.
     *
     * @param  readOnly              DOCUMENT ME!
     * @param  withVerbreitungsraum  DOCUMENT ME!
     */
    public GeschuetzteArtAbschnittEditor(final boolean readOnly, final boolean withVerbreitungsraum) {
        linearReferencedLineEditor = (readOnly) ? new LinearReferencedLineRenderer(true)
                                                : new LinearReferencedLineEditor();
        linearReferencedLineEditor.setLineField("linie");
        this.withVerbreitungsraum = withVerbreitungsraum;
        initComponents();

        txtVermeidungsgruppe.setVisible(withVerbreitungsraum);
        lblVermeidungsgruppe.setVisible(withVerbreitungsraum);
        final String group = SessionManager.getSession().getUser().getUserGroup().getName();

        if (!group.equalsIgnoreCase("gup-admin") && !group.equalsIgnoreCase("administratoren")) {
            lblArt.setVisible(false);
            cbName.setVisible(false);
        }

        if (!readOnly) {
            linearReferencedLineEditor.setOtherLinesEnabled(true);
            linearReferencedLineEditor.setOtherLinesQueryAddition(
                "geschuetzte_art_abschnitt",
                "geschuetzte_art_abschnitt.linie = ");
            linearReferencedLineEditor.setShowOtherInDialog(true);
        } else {
            RendererTools.makeReadOnly(cbName);
            RendererTools.makeReadOnly(txtVermeidungsgruppe);
            RendererTools.makeReadOnly(txtHerkunft);
            RendererTools.makeReadOnly(dcDatenalter);
        }
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        lblArt = new javax.swing.JLabel();
        cbName = new ScrollableComboBox();
        linearReferencedLineEditor = linearReferencedLineEditor;
        lblVermeidungsgruppe = new javax.swing.JLabel();
        txtVermeidungsgruppe = new javax.swing.JTextField();
        lblHerkunft = new javax.swing.JLabel();
        txtHerkunft = new javax.swing.JTextField();
        lblAlter = new javax.swing.JLabel();
        dcDatenalter = new de.cismet.cids.editors.DefaultBindableDateChooser();

        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(994, 400));
        setLayout(new java.awt.GridBagLayout());

        lblArt.setText(org.openide.util.NbBundle.getMessage(
                GeschuetzteArtAbschnittEditor.class,
                "GeschuetzteArtAbschnittEditor.lblArt.text")); // NOI18N
        lblArt.setMaximumSize(new java.awt.Dimension(170, 17));
        lblArt.setMinimumSize(new java.awt.Dimension(170, 17));
        lblArt.setPreferredSize(new java.awt.Dimension(170, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        add(lblArt, gridBagConstraints);

        cbName.setMaximumSize(new java.awt.Dimension(550, 25));
        cbName.setMinimumSize(new java.awt.Dimension(550, 25));
        cbName.setPreferredSize(new java.awt.Dimension(550, 25));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.art}"),
                cbName,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 15);
        add(cbName, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 10, 10);
        add(linearReferencedLineEditor, gridBagConstraints);

        lblVermeidungsgruppe.setText(org.openide.util.NbBundle.getMessage(
                GeschuetzteArtAbschnittEditor.class,
                "GeschuetzteArtAbschnittEditor.lblVermeidungsgruppe.text")); // NOI18N
        lblVermeidungsgruppe.setMaximumSize(new java.awt.Dimension(170, 17));
        lblVermeidungsgruppe.setMinimumSize(new java.awt.Dimension(170, 17));
        lblVermeidungsgruppe.setPreferredSize(new java.awt.Dimension(170, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(25, 15, 5, 5);
        add(lblVermeidungsgruppe, gridBagConstraints);

        txtVermeidungsgruppe.setMinimumSize(new java.awt.Dimension(550, 25));
        txtVermeidungsgruppe.setPreferredSize(new java.awt.Dimension(550, 25));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(25, 5, 5, 15);
        add(txtVermeidungsgruppe, gridBagConstraints);

        lblHerkunft.setText(org.openide.util.NbBundle.getMessage(
                GeschuetzteArtAbschnittEditor.class,
                "GeschuetzteArtAbschnittEditor.lblHerkunft.text")); // NOI18N
        lblHerkunft.setMaximumSize(new java.awt.Dimension(170, 17));
        lblHerkunft.setMinimumSize(new java.awt.Dimension(170, 17));
        lblHerkunft.setPreferredSize(new java.awt.Dimension(170, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        add(lblHerkunft, gridBagConstraints);

        txtHerkunft.setMinimumSize(new java.awt.Dimension(550, 25));
        txtHerkunft.setPreferredSize(new java.awt.Dimension(550, 25));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.datenherkunft}"),
                txtHerkunft,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 15);
        add(txtHerkunft, gridBagConstraints);

        lblAlter.setText(org.openide.util.NbBundle.getMessage(
                GeschuetzteArtAbschnittEditor.class,
                "GeschuetzteArtAbschnittEditor.lblAlter.text")); // NOI18N
        lblAlter.setMaximumSize(new java.awt.Dimension(170, 17));
        lblAlter.setMinimumSize(new java.awt.Dimension(170, 17));
        lblAlter.setPreferredSize(new java.awt.Dimension(170, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        add(lblAlter, gridBagConstraints);

        dcDatenalter.setMinimumSize(new java.awt.Dimension(550, 25));
        dcDatenalter.setPreferredSize(new java.awt.Dimension(550, 25));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.datenalter}"),
                dcDatenalter,
                org.jdesktop.beansbinding.BeanProperty.create("date"));
        binding.setConverter(dcDatenalter.getConverter());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 15);
        add(dcDatenalter, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        this.cidsBean = cidsBean;

        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                cidsBean);
            bindingGroup.bind();

            if (this.others != null) {
                final List<CidsBean> lineBeans = new ArrayList<CidsBean>();
                final Object id = cidsBean.getProperty("linie.id");

                for (final CidsBean b : this.others) {
                    final CidsBean tmp = (CidsBean)b.getProperty("linie");

                    if ((tmp != null) && (!tmp.getProperty("id").equals(id))) {
                        lineBeans.add(tmp);
                    }
                }
                linearReferencedLineEditor.setOtherLines(lineBeans);
            }

            linearReferencedLineEditor.setCidsBean(cidsBean);

            if (withVerbreitungsraum && (verbreitungsraum != null)) {
                String gruppe = (String)verbreitungsraum.getProperty("name");
                if (gruppe == null) {
                    gruppe = "unbenannt";
                }
                txtVermeidungsgruppe.setText(gruppe);
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  others  DOCUMENT ME!
     */
    public void setOthers(final List<CidsBean> others) {
        this.others = others;
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
        linearReferencedLineEditor.dispose();
    }

    @Override
    public String getTitle() {
        return "Vermeidungsgruppe";
    }

    @Override
    public void setTitle(final String title) {
    }

    @Override
    public void editorClosed(final EditorClosedEvent event) {
        linearReferencedLineEditor.editorClosed(event);
    }

    @Override
    public boolean prepareForSave() {
        return linearReferencedLineEditor.prepareForSave();
    }
    /**
     * DOCUMENT ME!
     *
     * @param   args  DOCUMENT ME!
     *
     * @throws  Exception  DOCUMENT ME!
     */
    public static void main(final String[] args) throws Exception {
        DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost(
            "WRRL_DB_MV",
            "Administratoren",
            "admin",
            "x",
            "vermeidungsgruppen_abschnitt",
            1,
            1280,
            1024);
    }

    /**
     * DOCUMENT ME!
     *
     * @return  the verbreitungsraum
     */
    public CidsBean getVerbreitungsraum() {
        return verbreitungsraum;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  verbreitungsraum  the verbreitungsraum to set
     */
    public void setVerbreitungsraum(final CidsBean verbreitungsraum) {
        this.verbreitungsraum = verbreitungsraum;
    }
}
