/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * GupPegelEditor.java
 *
 * Created on 26.10.2011, 11:16:19
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;

import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import de.cismet.cids.client.tools.DevelopmentTools;

import de.cismet.cids.custom.wrrl_db_mv.commons.WRRLUtil;
import de.cismet.cids.custom.wrrl_db_mv.server.search.WkSearchByStations;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.GupHelper;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.CidsServerSearch;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class GupGewaesserWrrl extends javax.swing.JPanel implements CidsBeanRenderer, EditorSaveListener {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            GupGewaesserWrrl.class);
    private static final MetaClass MC = ClassCacheMultiple.getMetaClass(WRRLUtil.DOMAIN_NAME, "wk_fg");

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private boolean readOnly = false;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.tools.gui.RoundedPanel glassPanel;
    private javax.swing.JPanel panGewaesserInner;
    private javax.swing.JScrollPane scrollGewaesser;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form GupMassnahmeSohle.
     */
    public GupGewaesserWrrl() {
        this(false);
    }

    /**
     * Creates new form GupMassnahmeSohle.
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public GupGewaesserWrrl(final boolean readOnly) {
        this.readOnly = readOnly;
        initComponents();
//        tabPegel.setModel(new HydroTableModel());
        scrollGewaesser.getViewport().setOpaque(false);
        setReadOnly(readOnly);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        scrollGewaesser = new javax.swing.JScrollPane();
        panGewaesserInner = new javax.swing.JPanel();
        glassPanel = new de.cismet.tools.gui.RoundedPanel();

        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(994, 800));
        setLayout(new java.awt.GridBagLayout());

        scrollGewaesser.setBorder(null);
        scrollGewaesser.setOpaque(false);

        panGewaesserInner.setBorder(null);
        panGewaesserInner.setMinimumSize(new java.awt.Dimension(100, 100));
        panGewaesserInner.setOpaque(false);
        scrollGewaesser.setViewportView(panGewaesserInner);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(scrollGewaesser, gridBagConstraints);

        glassPanel.setAlpha(0);
        glassPanel.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(glassPanel, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  args  DOCUMENT ME!
     */
    public static void main(final String[] args) {
        try {
            DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost(
                "WRRL_DB_MV",
                "Administratoren",
                "admin",
                "sb",
                "gup_gewaesserabschnitt",
                1,
                1280,
                1024);
        } catch (Exception e) {
        }
    }

    @Override
    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
//        bindingGroup.unbind();
        this.cidsBean = cidsBean;

        if (cidsBean != null) {
//            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
//                bindingGroup,
//                cidsBean);
//            bindingGroup.bind();
            new Thread(new Runnable() {

                    @Override
                    public void run() {
                        refreshFields();
                    }
                }).start();
        }
    }

    /**
     * DOCUMENT ME!
     */
    public void refreshFields() {
        try {
            final List<String> wkkList = new ArrayList<String>();
            final CidsBean statLine = GupHelper.getStationLinie(cidsBean);
            if (statLine != null) {
                final CidsBean statVon = (CidsBean)statLine.getProperty("von");
                if (statVon != null) {
                    final CidsBean route = (CidsBean)statVon.getProperty("route");
                    if (route != null) {
                        final CidsServerSearch searchWK = new WkSearchByStations(GupHelper.getMinStart(cidsBean),
                                GupHelper.getMaxEnd(cidsBean),
                                String.valueOf(route.getProperty("gwk")));

                        final Collection resWK = SessionManager.getProxy()
                                    .customServerSearch(SessionManager.getSession().getUser(), searchWK);
                        final ArrayList<ArrayList> resArray = (ArrayList<ArrayList>)resWK;

                        if ((resArray != null) && (resArray.size() > 0) && (resArray.get(0).size() > 0)) {
                            String wkkCond = null;
                            for (final ArrayList tmp : resArray) {
                                final Object o = tmp.get(0);

                                if (o instanceof String) {
                                    wkkList.add(o.toString());

                                    if (wkkCond == null) {
                                        wkkCond = "wk_k = '" + o.toString() + "'";
                                    } else {
                                        wkkCond += " OR wk_k = '" + o.toString() + "'";
                                    }
                                }
                            }

//                            final String query = "select " + MC.getID() + ", " + MC.getPrimaryKey() + " from "
//                                        + MC.getTableName() + " where " + wkkCond;
//                            final MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);

                            EventQueue.invokeLater(new Runnable() {

                                    @Override
                                    public void run() {
                                        if ((wkkList != null) && (wkkList.size() > 0)) {
                                            panGewaesserInner.setLayout(new FlowLayout());
                                            for (final String mo : wkkList) {
                                                final GupWasserkoerper tmp = new GupWasserkoerper();
                                                tmp.setBeanName(mo);
                                                panGewaesserInner.add(tmp);
                                            }
                                        }
                                    }
                                });
                        } else {
                            LOG.error("Server error in getWk_k(). Cids server search return null. " // NOI18N
                                        + "See the server logs for further information");     // NOI18N
                        }
                    }
                }
            }
        } catch (Exception e) {
            LOG.error("Problem beim Suchen der Wasserkoerper", e);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public void setReadOnly(final boolean readOnly) {
        if (readOnly) {
            glassPanel.addMouseListener(new MouseAdapter() {
                });
        } else {
            for (final MouseListener ml : glassPanel.getMouseListeners()) {
                glassPanel.removeMouseListener(ml);
            }
        }
    }

    @Override
    public void dispose() {
//        bindingGroup.unbind();
    }

    @Override
    public String getTitle() {
        return "WRRL";
    }

    @Override
    public void setTitle(final String title) {
    }

    @Override
    public void editorClosed(final EditorClosedEvent event) {
    }

    @Override
    public boolean prepareForSave() {
        return true;
    }
}
