/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * GupMassnahmeSohle.java
 *
 * Created on 04.04.2012, 11:49:19
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.tools.CacheException;
import Sirius.navigator.tools.MetaObjectCache;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;

import java.util.ArrayList;
import java.util.List;

import javax.swing.SwingWorker;

import de.cismet.cids.client.tools.DevelopmentTools;

import de.cismet.cids.custom.objectrenderer.wrrl_db_mv.LinearReferencedLineRenderer;
import de.cismet.cids.custom.wrrl_db_mv.commons.WRRLUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.CustomListCellRenderer;
import de.cismet.cids.custom.wrrl_db_mv.util.RendererTools;
import de.cismet.cids.custom.wrrl_db_mv.util.ScrollableComboBox;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;

import de.cismet.tools.CismetThreadPool;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class GupUmlandnutzungEditor extends javax.swing.JPanel implements CidsBeanRenderer, EditorSaveListener {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            GupUmlandnutzungEditor.class);
    private static final MetaClass OBERGRUPPE_ART = ClassCacheMultiple.getMetaClass(
            WRRLUtil.DOMAIN_NAME,
            "GUP_UMLANDNUTZUNGSOBERGRUPPE");

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private boolean readOnly = false;
    private List<CidsBean> others;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.cids.editors.DefaultBindableReferenceCombo cbUmlandnutzungsart;
    private javax.swing.JLabel lblObergruppe;
    private javax.swing.JLabel lblSchutzkategorie;
    private javax.swing.JTextField lblSchutzkategorieVal;
    private javax.swing.JLabel lblUmlandnutzungsart;
    private javax.swing.JLabel lblUmlandnutzungsobergruppe;
    private de.cismet.cids.custom.objecteditors.wrrl_db_mv.LinearReferencedLineEditor linearReferencedLineEditor;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form GupMassnahmeSohle.
     */
    public GupUmlandnutzungEditor() {
        this(false);
    }

    /**
     * Creates new form GupMassnahmeSohle.
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public GupUmlandnutzungEditor(final boolean readOnly) {
        this.readOnly = readOnly;
        linearReferencedLineEditor = (readOnly) ? new LinearReferencedLineRenderer(true)
                                                : new LinearReferencedLineEditor();
        linearReferencedLineEditor.setLineField("linie");
        linearReferencedLineEditor.setShowOtherInDialog(true);
        initComponents();

        lblObergruppe.setVisible(false);
        lblUmlandnutzungsobergruppe.setVisible(false);

        if (!readOnly) {
            linearReferencedLineEditor.setOtherLinesEnabled(true);
            linearReferencedLineEditor.setOtherLinesQueryAddition(
                "gup_unterhaltungserfordernis",
                "gup_unterhaltungserfordernis.linie = ");
        } else {
            RendererTools.makeReadOnly(lblSchutzkategorieVal);
            RendererTools.makeReadOnly(cbUmlandnutzungsart);
        }
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        lblUmlandnutzungsobergruppe = new javax.swing.JLabel();
        lblObergruppe = new javax.swing.JLabel();
        lblUmlandnutzungsart = new javax.swing.JLabel();
        cbUmlandnutzungsart = new ScrollableComboBox();
        lblSchutzkategorie = new javax.swing.JLabel();
        linearReferencedLineEditor = linearReferencedLineEditor;
        lblSchutzkategorieVal = new javax.swing.JTextField();

        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(994, 500));
        setLayout(new java.awt.GridBagLayout());

        lblUmlandnutzungsobergruppe.setText(org.openide.util.NbBundle.getMessage(
                GupUmlandnutzungEditor.class,
                "GupUmlandnutzungEditor.lblUmlandnutzungsobergruppe.text")); // NOI18N
        lblUmlandnutzungsobergruppe.setMaximumSize(new java.awt.Dimension(150, 17));
        lblUmlandnutzungsobergruppe.setMinimumSize(new java.awt.Dimension(150, 17));
        lblUmlandnutzungsobergruppe.setPreferredSize(new java.awt.Dimension(150, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(25, 15, 5, 5);
        add(lblUmlandnutzungsobergruppe, gridBagConstraints);

        lblObergruppe.setMaximumSize(new java.awt.Dimension(290, 20));
        lblObergruppe.setMinimumSize(new java.awt.Dimension(290, 20));
        lblObergruppe.setPreferredSize(new java.awt.Dimension(290, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(25, 5, 5, 5);
        add(lblObergruppe, gridBagConstraints);

        lblUmlandnutzungsart.setText(org.openide.util.NbBundle.getMessage(
                GupUmlandnutzungEditor.class,
                "GupUmlandnutzungEditor.lblUmlandnutzungsart.text")); // NOI18N
        lblUmlandnutzungsart.setMaximumSize(new java.awt.Dimension(150, 17));
        lblUmlandnutzungsart.setMinimumSize(new java.awt.Dimension(150, 17));
        lblUmlandnutzungsart.setPreferredSize(new java.awt.Dimension(150, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        add(lblUmlandnutzungsart, gridBagConstraints);

        cbUmlandnutzungsart.setMaximumSize(new java.awt.Dimension(360, 20));
        cbUmlandnutzungsart.setMinimumSize(new java.awt.Dimension(360, 20));
        cbUmlandnutzungsart.setPreferredSize(new java.awt.Dimension(360, 20));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.art}"),
                cbUmlandnutzungsart,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        cbUmlandnutzungsart.addItemListener(new java.awt.event.ItemListener() {

                @Override
                public void itemStateChanged(final java.awt.event.ItemEvent evt) {
                    cbUmlandnutzungsartItemStateChanged(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(cbUmlandnutzungsart, gridBagConstraints);

        lblSchutzkategorie.setText(org.openide.util.NbBundle.getMessage(
                GupUmlandnutzungEditor.class,
                "GupUmlandnutzungEditor.lblSchutzkategorie.text")); // NOI18N
        lblSchutzkategorie.setMaximumSize(new java.awt.Dimension(150, 17));
        lblSchutzkategorie.setMinimumSize(new java.awt.Dimension(150, 17));
        lblSchutzkategorie.setPreferredSize(new java.awt.Dimension(150, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        add(lblSchutzkategorie, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 10, 10);
        add(linearReferencedLineEditor, gridBagConstraints);

        lblSchutzkategorieVal.setMaximumSize(new java.awt.Dimension(360, 20));
        lblSchutzkategorieVal.setMinimumSize(new java.awt.Dimension(360, 20));
        lblSchutzkategorieVal.setPreferredSize(new java.awt.Dimension(360, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.schutzkategorie}"),
                lblSchutzkategorieVal,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(lblSchutzkategorieVal, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbUmlandnutzungsartItemStateChanged(final java.awt.event.ItemEvent evt) { //GEN-FIRST:event_cbUmlandnutzungsartItemStateChanged
        if (evt.getItem() != null) {
            setSuperGroup((CidsBean)evt.getItem());
        }
    }                                                                                      //GEN-LAST:event_cbUmlandnutzungsartItemStateChanged

    @Override
    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        this.cidsBean = cidsBean;

        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                cidsBean);
            bindingGroup.bind();

            if (this.others != null) {
                final List<CidsBean> lineBeans = new ArrayList<CidsBean>();
                final Object id = cidsBean.getProperty("linie.id");

                for (final CidsBean b : this.others) {
                    final CidsBean tmp = (CidsBean)b.getProperty("linie");

                    if ((tmp != null) && (!tmp.getProperty("id").equals(id))) {
                        lineBeans.add(tmp);
                    }
                }
                linearReferencedLineEditor.setOtherLines(lineBeans);
            }

            linearReferencedLineEditor.setCidsBean(cidsBean);
            setSuperGroup((CidsBean)cidsBean.getProperty("art"));
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  others  DOCUMENT ME!
     */
    public void setOthers(final List<CidsBean> others) {
        this.others = others;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  art  DOCUMENT ME!
     */
    private void setSuperGroup(final CidsBean art) {
        CismetThreadPool.executeSequentially(new SwingWorker<String, String>() {

                @Override
                protected String doInBackground() throws Exception {
                    if (art != null) {
                        final Integer groupId = (Integer)art.getProperty("id");

                        if (groupId != null) {
                            final String query = "select " + OBERGRUPPE_ART.getID() + ", o."
                                        + OBERGRUPPE_ART.getPrimaryKey() + " from "
                                        + OBERGRUPPE_ART.getTableName() + " o, gup_umlandnutzungsobergruppe_gruppe ug "
                                        + "where o.gruppen = ug.gup_obergruppe_reference and ug.gruppe = " + groupId; // NOI18N

                            try {
                                final MetaObject[] metaObjects = MetaObjectCache.getInstance()
                                            .getMetaObjectsByQuery(query, WRRLUtil.DOMAIN_NAME);

                                if ((metaObjects != null) && (metaObjects.length == 1)) {
                                    return metaObjects[0].getBean().toString();
                                }
                            } catch (CacheException e) {
                                LOG.error("Cache Exception", e);
                            }
                        }
                    }
                    return "";
                }

                @Override
                protected void done() {
                    try {
                        final String res = get();
                        lblObergruppe.setText(res);
                    } catch (Exception e) {
                        LOG.error("Error while retrieving the super group.", e);
                    }
                }
            });
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
        linearReferencedLineEditor.dispose();
    }

    @Override
    public String getTitle() {
        return "Umlandnutzung";
    }

    @Override
    public void setTitle(final String title) {
    }

    @Override
    public void editorClosed(final EditorClosedEvent event) {
        linearReferencedLineEditor.editorClosed(event);
    }

    @Override
    public boolean prepareForSave() {
        return linearReferencedLineEditor.prepareForSave();
    }

    /**
     * DOCUMENT ME!
     *
     * @param   args  DOCUMENT ME!
     *
     * @throws  Exception  DOCUMENT ME!
     */
    public static void main(final String[] args) throws Exception {
        DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost(
            "WRRL_DB_MV",
            "Administratoren",
            "admin",
            "x",
            "gup_umlandnutzung",
            1,
            1280,
            1024);
    }
}
